/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.diagram;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.GraphicDevice;
import net.sf.sdedit.drawable.Drawable;

public abstract class AbstractGraphicDevice
implements GraphicDevice {
    private Iterable<Drawable> drawables;
    private Font plainFont;
    private Font boldFont;
    private int width;
    private int height;
    private FontRenderContext fontRenderContext;

    protected Iterable<Drawable> drawables() {
        return this.drawables;
    }

    protected void setFontRenderContext(boolean antialiasing) {
        this.fontRenderContext = new FontRenderContext(null, antialiasing, true);
    }

    @Override
    public void initialize(Diagram diagram) {
        this.drawables = diagram.getPaintDevice();
        this.plainFont = diagram.getConfiguration().getFont();
        this.boldFont = new Font(this.plainFont.getName(), 1, this.plainFont.getSize() + 1);
        this.setFontRenderContext(false);
    }

    @Override
    public int getTextHeight(boolean bold) {
        return Math.round(this.getFont(bold).getLineMetrics("A", this.fontRenderContext).getHeight());
    }

    @Override
    public int getTextWidth(String text, boolean bold) {
        return (int)Math.ceil(this.getFont(bold).getStringBounds(text, this.fontRenderContext).getWidth());
    }

    @Override
    public Font getFont(boolean bold) {
        return bold ? this.boldFont : this.plainFont;
    }

    @Override
    public void close(int width, int height, boolean empty) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

