/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import javax.swing.SwingUtilities;

public abstract class DelayedActivity
extends Thread {
    private boolean notified;

    protected DelayedActivity() {
        this.setDaemon(true);
    }

    public synchronized void indicateChange() {
        this.notified = true;
        this.notify();
    }

    @Override
    public void run() {
        boolean changed = false;
        DelayedActivity delayedActivity = this;
        synchronized (delayedActivity) {
            while (true) {
                try {
                    this.wait(Math.max(1, this.getDelay()));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (this.notified) {
                    changed = true;
                } else if (changed) {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            DelayedActivity delayedActivity = DelayedActivity.this;
                            synchronized (delayedActivity) {
                                DelayedActivity.this.perform();
                            }
                        }
                    });
                    changed = false;
                }
                this.notified = false;
            }
        }
    }

    protected abstract int getDelay();

    protected abstract void perform();
}

