/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.sdedit.ui.components.ButtonPanel;
import net.sf.sdedit.util.Ref;
import net.sf.sdedit.util.UIUtilities;

public class OptionDialog
extends JDialog {
    private static final long serialVersionUID = -2944581694704728259L;
    private String chosenOption;
    private ButtonPanel buttonPanel;
    private JFrame owner;
    private boolean empty;
    private JCheckBox decisionCheckBox;

    public OptionDialog(JFrame owner, String title, ImageIcon icon, String text) {
        this(owner, title, icon, text, null);
    }

    public OptionDialog(JFrame owner, String title, ImageIcon icon, String text, String decision) {
        super(owner);
        this.owner = owner;
        this.setModal(true);
        this.setTitle(title);
        this.init(icon, text, decision);
        this.empty = false;
    }

    private void init(ImageIcon icon, String text, String decision) {
        this.getContentPane().setLayout(new BorderLayout());
        this.buttonPanel = new ButtonPanel();
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridLayout(decision == null ? 1 : 2, 1));
        if (decision != null) {
            this.decisionCheckBox = new JCheckBox(decision);
            bottomPanel.add(this.decisionCheckBox);
        }
        bottomPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)bottomPanel, "South");
        JPanel center = new JPanel();
        center.setLayout(new BorderLayout());
        this.getContentPane().add((Component)center, "Center");
        JLabel label = new JLabel();
        label.setBorder(BorderFactory.createEmptyBorder(2, 2, 10, 20));
        label.setText(text);
        center.add((Component)label, "Center");
        if (icon != null) {
            JLabel iconLabel = new JLabel(icon);
            iconLabel.setBorder(BorderFactory.createEmptyBorder(10, 25, 10, 25));
            center.add((Component)iconLabel, "West");
        }
    }

    public void addOption(String optionText) {
        int i;
        boolean isDefault = false;
        String option = optionText;
        if (option.endsWith("#")) {
            option = option.substring(0, option.length() - 1);
            isDefault = true;
        }
        for (i = -1; i < option.length() - 1 && option.charAt(i + 1) == ':'; ++i) {
        }
        final String theOption = option.substring(i + 1);
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = 3674364416011034074L;
            {
                this.putValue("Name", theOption);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionDialog.this.chosenOption = theOption;
                OptionDialog.this.setVisible(false);
            }
        };
        this.buttonPanel.addAction(action, i * 10, isDefault);
    }

    public String getOption() {
        return this.getOption(null);
    }

    public String getOption(Ref<Boolean> decision) {
        if (this.empty) {
            throw new IllegalStateException("Refusing to show option dialog because no option has been added");
        }
        this.pack();
        UIUtilities.centerWindow(this, this.owner);
        this.setVisible(true);
        this.dispose();
        if (decision != null && this.decisionCheckBox != null) {
            decision.t = this.decisionCheckBox.isSelected();
        }
        return this.chosenOption;
    }
}

