/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.sdedit.ui.components.GrabbableViewport;
import net.sf.sdedit.ui.components.Scalable;
import net.sf.sdedit.ui.components.Zoomable;

public class ZoomPane
extends JPanel
implements Scalable,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -1422640857L;
    private double scale = 1.0;
    private Zoomable<? extends JComponent> viewPort;
    private JScrollPane scrollPane;
    private List<MouseListener> mouseListeners;
    private List<MouseMotionListener> mouseMotionListeners;
    private MyObservable observable = new MyObservable();
    private JComponent root;
    private GrabbableViewport port;
    private JPanel internal = new JPanel(){

        @Override
        public Dimension getPreferredSize() {
            if (ZoomPane.this.viewPort == null) {
                return super.getPreferredSize();
            }
            return new Dimension((int)((double)ZoomPane.this.viewPort.getAbsoluteWidth() * ZoomPane.this.scale), (int)((double)ZoomPane.this.viewPort.getAbsoluteHeight() * ZoomPane.this.scale));
        }

        @Override
        public void setCursor(Cursor cursor) {
            ZoomPane.this.root.setCursor(cursor);
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            if (ZoomPane.this.viewPort == null) {
                return "";
            }
            return ((JComponent)ZoomPane.this.viewPort.asJComponent()).getToolTipText(ZoomPane.this.translate(e));
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.scale(ZoomPane.this.scale, ZoomPane.this.scale);
            if (ZoomPane.this.viewPort == null) {
                Rectangle rectangle = g2d.getClipBounds();
                g2d.setColor(Color.WHITE);
                g2d.fill(rectangle);
            } else {
                ZoomPane.this.viewPort.paintComponent(g2d);
            }
            g2d.dispose();
        }
    };

    public ZoomPane() {
        this(true);
    }

    public ZoomPane(boolean enableScrolling) {
        this.mouseListeners = new LinkedList<MouseListener>();
        this.mouseMotionListeners = new LinkedList<MouseMotionListener>();
        this.inheritListeners();
        this.setLayout(new BorderLayout());
        this.internal.addMouseListener(this);
        this.internal.addMouseMotionListener(this);
        this.port = new GrabbableViewport();
        this.port.setView(this.internal);
        if (enableScrolling) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewport(this.port);
            this.scrollPane.setDoubleBuffered(true);
            this.scrollPane.getVerticalScrollBar().setUnitIncrement(30);
            this.add((Component)this.scrollPane, "Center");
        } else {
            this.add((Component)this.internal, "Center");
        }
        this.root = this;
    }

    public Object createAnchoring(Point logicalPosition) {
        int x = (int)((double)logicalPosition.x * this.scale);
        int y = (int)((double)logicalPosition.y * this.scale);
        Point vp = this.scrollPane.getViewport().getViewPosition();
        Point anchor = new Point(x - vp.x, y - vp.y);
        return anchor;
    }

    public void restoreAnchoring(Point logicalPosition, Object anchoring) {
        Point vp = (Point)anchoring;
        int x = (int)((double)logicalPosition.x * this.scale);
        int y = (int)((double)logicalPosition.y * this.scale);
        Point np = new Point(x - vp.x, y - vp.y);
        this.scrollPane.getViewport().setViewPosition(np);
    }

    public void setRoot(JComponent root) {
        this.root = root;
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.internal.addMouseListener(mouseListener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.internal.addMouseMotionListener(mouseMotionListener);
    }

    public JPanel getPanel() {
        return this.internal;
    }

    public void scrollToBottom() {
        this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
    }

    public void scrollToRectangle(Rectangle rect) {
        rect.x = (int)((double)rect.x * this.scale);
        rect.y = (int)((double)rect.y * this.scale);
        rect.width = (int)((double)rect.width * this.scale);
        rect.height = (int)((double)rect.height * this.scale);
        this.internal.scrollRectToVisible(rect);
    }

    public void home() {
        this.scrollPane.getVerticalScrollBar().setValue(0);
        this.scrollPane.getHorizontalScrollBar().setValue(0);
    }

    private void inheritListeners() {
        this.mouseListeners.clear();
        this.mouseMotionListeners.clear();
        if (this.viewPort != null) {
            this.mouseListeners.addAll(Arrays.asList(this.viewPort.asJComponent().getMouseListeners()));
            this.mouseMotionListeners.addAll(Arrays.asList(this.viewPort.asJComponent().getMouseMotionListeners()));
        }
    }

    @Override
    public void fitWidth() {
        if (this.viewPort == null) {
            return;
        }
        this.setScale(1.0 * (double)this.getWidth() / (double)this.viewPort.getAbsoluteWidth());
    }

    @Override
    public void fitHeight() {
        if (this.viewPort == null) {
            return;
        }
        this.setScale(1.0 * (double)this.getHeight() / (double)this.viewPort.getAbsoluteHeight());
    }

    @Override
    public void fitSize() {
        if (this.viewPort == null) {
            return;
        }
        double w = 1.0 * (double)this.getWidth() / (double)this.viewPort.getAbsoluteWidth();
        double h = 1.0 * (double)this.getHeight() / (double)this.viewPort.getAbsoluteHeight();
        this.setScale(Math.min(w, h));
    }

    @Override
    public void setScale(double scale) {
        Rectangle visible = this.internal.getVisibleRect();
        double factor = scale / this.scale;
        this.scale = Math.min(4.0, scale);
        this.redraw();
        visible = new Rectangle((int)((double)visible.x * factor), (int)((double)visible.y * factor), (int)((double)visible.width * factor), (int)((double)visible.height * factor));
        this.internal.scrollRectToVisible(visible);
        this.observable.setChanged();
        this.observable.notifyObservers(this);
    }

    public void redraw() {
        if (this.scrollPane != null) {
            this.scrollPane.setViewportView(this.internal);
        }
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void setViewportView(Zoomable<? extends JComponent> viewPort) {
        this.viewPort = viewPort;
        if (viewPort != null) {
            viewPort.setZoomPane(this);
        }
        this.inheritListeners();
        this.redraw();
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    private MouseEvent translate(MouseEvent e) {
        int x = (int)((double)e.getX() / this.scale);
        int y = (int)((double)e.getY() / this.scale);
        return new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), x, y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        for (MouseListener ml : this.mouseListeners) {
            ml.mouseEntered(this.translate(e));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        for (MouseListener ml : this.mouseListeners) {
            ml.mouseExited(this.translate(e));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        for (MouseListener ml : this.mouseListeners) {
            ml.mouseClicked(this.translate(e));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        for (MouseListener ml : this.mouseListeners) {
            ml.mousePressed(this.translate(e));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        for (MouseListener ml : this.mouseListeners) {
            ml.mouseReleased(this.translate(e));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        for (MouseMotionListener ml : this.mouseMotionListeners) {
            ml.mouseDragged(this.translate(e));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        for (MouseMotionListener ml : this.mouseMotionListeners) {
            try {
                ml.mouseMoved(this.translate(e));
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Override
    public Observable asObservable() {
        return this.observable;
    }

    private static class MyObservable
    extends Observable {
        private MyObservable() {
        }

        @Override
        public synchronized void setChanged() {
            super.setChanged();
        }
    }
}

