/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyDescriptor;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.Configurator;
import net.sf.sdedit.ui.components.configuration.DataObject;

public class FileConfigurator<C extends DataObject>
extends Configurator<File, C>
implements FocusListener {
    private static final long serialVersionUID = -8346750584632429872L;
    private JTextField fileTextField;
    private JButton browseButton;
    private JLabel label;
    private String description;
    private String[] fileTypes;
    private static ImageIcon openIcon = Icons.getIcon("open");

    public FileConfigurator(Bean<C> bean, PropertyDescriptor property) {
        super(bean, property);
        this.setLayout(new BorderLayout());
        this.description = this.getAdjustable().info();
        this.label = new JLabel(this.description + ":");
        this.add((Component)this.label, "West");
        this.browseButton = new JButton(openIcon);
        this.browseButton.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 1));
        this.browseButton.setOpaque(true);
        this.browseButton.setMargin(new Insets(1, 1, 1, 1));
        this.add((Component)this.browseButton, "East");
        this.fileTextField = new JTextField();
        this.fileTextField.addActionListener(this);
        this.fileTextField.addFocusListener(this);
        this.fileTextField.setText("");
        this.add((Component)this.fileTextField, "Center");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileConfigurator.this.browse();
            }
        });
        this.label.setHorizontalAlignment(4);
        this.fileTypes = this.getProperty().getWriteMethod().getAnnotation(Adjustable.class).filetypes();
    }

    public void setFile(File file) {
        this.fileTextField.setText(file.getAbsolutePath());
    }

    public File getFile() {
        return new File(this.fileTextField.getText());
    }

    private void browse() {
        File file;
        int val;
        File current = this.getFile();
        if (current != null && current.getParentFile() != null) {
            FileConfigurator.fileChooser().setCurrentDirectory(current.getParentFile());
        }
        if (this.fileTypes.length > 0) {
            this.addFileTypes(this.fileTypes);
        }
        if ((val = FileConfigurator.fileChooser().showOpenDialog(null)) == 0 && (file = FileConfigurator.fileChooser().getSelectedFile()) != null) {
            this.refresh(file);
            this._actionPerformed(null);
        }
        this.removeFileTypes(this.fileTypes);
    }

    @Override
    protected void _actionPerformed(ActionEvent evt) {
        String text = this.fileTextField.getText();
        if (!text.equals("")) {
            this.getBean().setValue(this.getProperty(), new File(this.fileTextField.getText()));
        }
    }

    @Override
    protected void refresh(File value) {
        this.fileTextField.setText(value == null ? "" : value.getAbsolutePath());
    }

    @Override
    public int getLabelWidth() {
        return this.label.getPreferredSize().width;
    }

    @Override
    public void setLabelWidth(int width) {
        this.label.setPreferredSize(new Dimension(width, this.label.getPreferredSize().height));
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.actionPerformed(null);
    }

    @Override
    protected void _setEnabled(boolean enabled) {
    }

    @Override
    public void focus() {
        this.fileTextField.requestFocusInWindow();
    }
}

