/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.math;

import org.sunflow.math.MathUtils;
import org.sunflow.math.Matrix4;

public final class MovingMatrix4 {
    private Matrix4[] transforms;
    private float t0;
    private float t1;
    private float inv;

    public MovingMatrix4(Matrix4 matrix4) {
        this.transforms = new Matrix4[]{matrix4};
        this.t1 = 0.0f;
        this.t0 = 0.0f;
        this.inv = 1.0f;
    }

    private MovingMatrix4(int n, float f, float f2, float f3) {
        this.transforms = new Matrix4[n];
        this.t0 = f;
        this.t1 = f2;
        this.inv = f3;
    }

    public void setSteps(int n) {
        if (this.transforms.length != n) {
            this.transforms = new Matrix4[n];
            this.inv = this.t0 < this.t1 ? (float)(this.transforms.length - 1) / (this.t1 - this.t0) : 1.0f;
        }
    }

    public void updateData(int n, Matrix4 matrix4) {
        this.transforms[n] = matrix4;
    }

    public Matrix4 getData(int n) {
        return this.transforms[n];
    }

    public int numSegments() {
        return this.transforms.length;
    }

    public void updateTimes(float f, float f2) {
        this.t0 = f;
        this.t1 = f2;
        this.inv = f < f2 ? (float)(this.transforms.length - 1) / (f2 - f) : 1.0f;
    }

    public MovingMatrix4 inverse() {
        MovingMatrix4 movingMatrix4 = new MovingMatrix4(this.transforms.length, this.t0, this.t1, this.inv);
        for (int i = 0; i < this.transforms.length; ++i) {
            if (this.transforms[i] == null) continue;
            movingMatrix4.transforms[i] = this.transforms[i].inverse();
            if (movingMatrix4.transforms[i] != null) continue;
            return null;
        }
        return movingMatrix4;
    }

    public Matrix4 sample(float f) {
        if (this.transforms.length == 1 || this.t0 >= this.t1) {
            return this.transforms[0];
        }
        float f2 = (MathUtils.clamp(f, this.t0, this.t1) - this.t0) * this.inv;
        int n = (int)f2;
        int n2 = Math.min(n + 1, this.transforms.length - 1);
        return Matrix4.blend(this.transforms[n], this.transforms[n2], f2 - (float)n);
    }
}

