/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.utils.MiscUtils;

public class ClassPath {
    private JarLRUCache zipFileNameToFile;
    private PathEntry[] paths;
    private boolean isCP;

    public ClassPath(String string, boolean bl) {
        this.isCP = bl;
        ArrayList<PathEntry> arrayList = new ArrayList<PathEntry>();
        this.zipFileNameToFile = new JarLRUCache();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            File file;
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("") || !(file = new File(string2)).exists()) continue;
            if (file.isDirectory()) {
                arrayList.add(new Dir(file));
                continue;
            }
            arrayList.add(new Zip(file.getPath()));
        }
        this.paths = arrayList.toArray(new PathEntry[0]);
    }

    public DynamicClassInfo getClassInfoForClass(String string, int n) throws IOException, ClassFormatError {
        String string2 = string.replace('.', '/');
        String string3 = this.getLocationForClass(string2);
        if (string3 == null) {
            return null;
        }
        return new DynamicClassInfo(string2, n, string3);
    }

    public String getLocationForClass(String string) {
        String string2 = string + (this.isCP ? ".class" : ".java");
        for (int i = 0; i < this.paths.length; ++i) {
            String string3 = this.paths[i].getLocationForClassFile(string2);
            if (string3 == null) continue;
            return string3;
        }
        return null;
    }

    public ZipFile getZipFileForName(String string) throws IOException {
        ZipFile zipFile = (ZipFile)this.zipFileNameToFile.get(string);
        if (zipFile == null) {
            zipFile = new ZipFile(string);
            this.zipFileNameToFile.put(string, zipFile);
        }
        return zipFile;
    }

    public void close() {
        Iterator iterator = this.zipFileNameToFile.values().iterator();
        while (iterator.hasNext()) {
            try {
                ((ZipFile)iterator.next()).close();
            }
            catch (IOException iOException) {}
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.paths.length; ++i) {
            stringBuilder.append(this.paths[i] instanceof Dir ? ((Dir)this.paths[i]).dir.getAbsolutePath() : ((Zip)this.paths[i]).zipFilePath);
            stringBuilder.append(File.pathSeparatorChar);
        }
        return stringBuilder.toString();
    }

    private static class JarLRUCache
    extends LinkedHashMap {
        private static final int MAX_CAPACITY = 100;

        private JarLRUCache() {
            super(10, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            if (this.size() > 100) {
                try {
                    ((ZipFile)entry.getValue()).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
    }

    private class Zip
    extends PathEntry {
        private String zipFilePath;

        Zip(String string) {
            this.zipFilePath = string;
            this.threshHits = 50 + this.r.nextInt(20);
        }

        @Override
        String getLocationForClassFile(String string) {
            ZipFile zipFile;
            if (this.entries != null) {
                if (this.entries.contains(string)) {
                    return this.zipFilePath;
                }
                return null;
            }
            if (++this.hits >= this.threshHits) {
                this.entries = new HashSet();
                MiscUtils.getAllClassesInJar(this.zipFilePath, false, this.entries);
                return this.getLocationForClassFile(string);
            }
            try {
                zipFile = ClassPath.this.getZipFileForName(this.zipFilePath);
            }
            catch (IOException iOException) {
                System.err.println("Warning: CLASSPATH component " + this.zipFilePath + ": " + iOException);
                return null;
            }
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry != null) {
                return this.zipFilePath;
            }
            return null;
        }
    }

    private static class Dir
    extends PathEntry {
        private File dir;

        Dir(File file) {
            this.dir = file;
            this.threshHits = 100 + this.r.nextInt(40);
        }

        @Override
        String getLocationForClassFile(String string) {
            if (this.entries != null) {
                if (this.entries.contains(string)) {
                    return this.dir.getAbsolutePath();
                }
                return null;
            }
            if (++this.hits >= this.threshHits) {
                this.entries = new HashSet();
                MiscUtils.getAllClassesInDir(this.dir.getAbsolutePath(), "", false, this.entries);
                return this.getLocationForClassFile(string);
            }
            File file = new File(this.dir, string);
            if (file.exists()) {
                return this.dir.getAbsolutePath();
            }
            return null;
        }
    }

    private static abstract class PathEntry {
        protected HashSet entries;
        protected int hits;
        protected int threshHits;
        protected final Random r = new Random(System.currentTimeMillis());

        private PathEntry() {
        }

        abstract String getLocationForClassFile(String var1);
    }
}

