/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.LatchedActionListener;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;

public class InternalClusterInfoService
implements ClusterInfoService,
LocalNodeMasterListener,
ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(InternalClusterInfoService.class);
    public static final Setting<TimeValue> INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL_SETTING = Setting.timeSetting("cluster.info.update.interval", TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueSeconds((long)10L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INTERNAL_CLUSTER_INFO_TIMEOUT_SETTING = Setting.positiveTimeSetting("cluster.info.update.timeout", TimeValue.timeValueSeconds((long)15L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile TimeValue updateFrequency;
    private volatile ImmutableOpenMap<String, DiskUsage> leastAvailableSpaceUsages = ImmutableOpenMap.of();
    private volatile ImmutableOpenMap<String, DiskUsage> mostAvailableSpaceUsages = ImmutableOpenMap.of();
    private volatile ImmutableOpenMap<ShardRouting, String> shardRoutingToDataPath = ImmutableOpenMap.of();
    private volatile ImmutableOpenMap<String, Long> shardSizes = ImmutableOpenMap.of();
    private volatile boolean isMaster = false;
    private volatile boolean enabled;
    private volatile TimeValue fetchTimeout;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final NodeClient client;
    private final Consumer<ClusterInfo> listener;

    public InternalClusterInfoService(Settings settings, ClusterService clusterService, ThreadPool threadPool, NodeClient client, Consumer<ClusterInfo> listener) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.updateFrequency = INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL_SETTING.get(settings);
        this.fetchTimeout = INTERNAL_CLUSTER_INFO_TIMEOUT_SETTING.get(settings);
        this.enabled = DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING.get(settings);
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(INTERNAL_CLUSTER_INFO_TIMEOUT_SETTING, this::setFetchTimeout);
        clusterSettings.addSettingsUpdateConsumer(INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL_SETTING, this::setUpdateFrequency);
        clusterSettings.addSettingsUpdateConsumer(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING, this::setEnabled);
        this.clusterService.addLocalNodeMasterListener(this);
        this.clusterService.addListener(this);
        this.listener = listener;
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void setFetchTimeout(TimeValue fetchTimeout) {
        this.fetchTimeout = fetchTimeout;
    }

    void setUpdateFrequency(TimeValue updateFrequency) {
        this.updateFrequency = updateFrequency;
    }

    @Override
    public void onMaster() {
        this.isMaster = true;
        if (logger.isTraceEnabled()) {
            logger.trace("I have been elected master, scheduling a ClusterInfoUpdateJob");
        }
        this.threadPool.scheduleUnlessShuttingDown(this.updateFrequency, this.executorName(), new SubmitReschedulingClusterInfoUpdatedJob());
        try {
            if (this.clusterService.state().getNodes().getDataNodes().size() > 1) {
                this.threadPool.executor(this.executorName()).execute(() -> this.maybeRefresh());
            }
        }
        catch (EsRejectedExecutionException ex) {
            logger.debug("Couldn't schedule cluster info update task - node might be shutting down", (Throwable)ex);
        }
    }

    @Override
    public void offMaster() {
        this.isMaster = false;
    }

    @Override
    public String executorName() {
        return "management";
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!this.enabled) {
            return;
        }
        boolean dataNodeAdded = false;
        for (DiscoveryNode addedNode : event.nodesDelta().addedNodes()) {
            if (!addedNode.isDataNode()) continue;
            dataNodeAdded = true;
            break;
        }
        if (this.isMaster && dataNodeAdded && event.state().getNodes().getDataNodes().size() > 1) {
            if (logger.isDebugEnabled()) {
                logger.debug("data node was added, retrieving new cluster info");
            }
            this.threadPool.executor(this.executorName()).execute(() -> this.maybeRefresh());
        }
        if (this.isMaster && event.nodesRemoved()) {
            for (DiscoveryNode removedNode : event.nodesDelta().removedNodes()) {
                if (!removedNode.isDataNode()) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace("Removing node from cluster info: {}", (Object)removedNode.getId());
                }
                if (this.leastAvailableSpaceUsages.containsKey(removedNode.getId())) {
                    ImmutableOpenMap.Builder<String, DiskUsage> newMaxUsages = ImmutableOpenMap.builder(this.leastAvailableSpaceUsages);
                    newMaxUsages.remove(removedNode.getId());
                    this.leastAvailableSpaceUsages = newMaxUsages.build();
                }
                if (!this.mostAvailableSpaceUsages.containsKey(removedNode.getId())) continue;
                ImmutableOpenMap.Builder<String, DiskUsage> newMinUsages = ImmutableOpenMap.builder(this.mostAvailableSpaceUsages);
                newMinUsages.remove(removedNode.getId());
                this.mostAvailableSpaceUsages = newMinUsages.build();
            }
        }
    }

    @Override
    public ClusterInfo getClusterInfo() {
        return new ClusterInfo(this.leastAvailableSpaceUsages, this.mostAvailableSpaceUsages, this.shardSizes, this.shardRoutingToDataPath);
    }

    protected CountDownLatch updateNodeStats(ActionListener<NodesStatsResponse> listener) {
        CountDownLatch latch = new CountDownLatch(1);
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest("data:true");
        nodesStatsRequest.clear();
        nodesStatsRequest.fs(true);
        nodesStatsRequest.timeout(this.fetchTimeout);
        this.client.admin().cluster().nodesStats(nodesStatsRequest, new LatchedActionListener<NodesStatsResponse>(listener, latch));
        return latch;
    }

    protected CountDownLatch updateIndicesStats(ActionListener<IndicesStatsResponse> listener) {
        CountDownLatch latch = new CountDownLatch(1);
        IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
        indicesStatsRequest.clear();
        indicesStatsRequest.store(true);
        this.client.admin().indices().stats(indicesStatsRequest, new LatchedActionListener<IndicesStatsResponse>(listener, latch));
        return latch;
    }

    private void maybeRefresh() {
        if (this.enabled) {
            this.refresh();
        } else if (logger.isTraceEnabled()) {
            logger.trace("Skipping ClusterInfoUpdatedJob since it is disabled");
        }
    }

    public final ClusterInfo refresh() {
        if (logger.isTraceEnabled()) {
            logger.trace("Performing ClusterInfoUpdateJob");
        }
        CountDownLatch nodeLatch = this.updateNodeStats(new ActionListener<NodesStatsResponse>(){

            @Override
            public void onResponse(NodesStatsResponse nodeStatses) {
                ImmutableOpenMap.Builder<String, DiskUsage> newLeastAvaiableUsages = ImmutableOpenMap.builder();
                ImmutableOpenMap.Builder<String, DiskUsage> newMostAvaiableUsages = ImmutableOpenMap.builder();
                InternalClusterInfoService.fillDiskUsagePerNode(logger, nodeStatses.getNodes(), newLeastAvaiableUsages, newMostAvaiableUsages);
                InternalClusterInfoService.this.leastAvailableSpaceUsages = newLeastAvaiableUsages.build();
                InternalClusterInfoService.this.mostAvailableSpaceUsages = newMostAvaiableUsages.build();
            }

            @Override
            public void onFailure(Exception e) {
                if (e instanceof ReceiveTimeoutTransportException) {
                    logger.error("NodeStatsAction timed out for ClusterInfoUpdateJob", (Throwable)e);
                } else {
                    if (e instanceof ClusterBlockException) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Failed to execute NodeStatsAction for ClusterInfoUpdateJob", (Throwable)e);
                        }
                    } else {
                        logger.warn("Failed to execute NodeStatsAction for ClusterInfoUpdateJob", (Throwable)e);
                    }
                    InternalClusterInfoService.this.leastAvailableSpaceUsages = ImmutableOpenMap.of();
                    InternalClusterInfoService.this.mostAvailableSpaceUsages = ImmutableOpenMap.of();
                }
            }
        });
        CountDownLatch indicesLatch = this.updateIndicesStats(new ActionListener<IndicesStatsResponse>(){

            @Override
            public void onResponse(IndicesStatsResponse indicesStatsResponse) {
                ShardStats[] stats = indicesStatsResponse.getShards();
                ImmutableOpenMap.Builder<String, Long> newShardSizes = ImmutableOpenMap.builder();
                ImmutableOpenMap.Builder<ShardRouting, String> newShardRoutingToDataPath = ImmutableOpenMap.builder();
                InternalClusterInfoService.buildShardLevelInfo(logger, stats, newShardSizes, newShardRoutingToDataPath, InternalClusterInfoService.this.clusterService.state());
                InternalClusterInfoService.this.shardSizes = newShardSizes.build();
                InternalClusterInfoService.this.shardRoutingToDataPath = newShardRoutingToDataPath.build();
            }

            @Override
            public void onFailure(Exception e) {
                if (e instanceof ReceiveTimeoutTransportException) {
                    logger.error("IndicesStatsAction timed out for ClusterInfoUpdateJob", (Throwable)e);
                } else {
                    if (e instanceof ClusterBlockException) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Failed to execute IndicesStatsAction for ClusterInfoUpdateJob", (Throwable)e);
                        }
                    } else {
                        logger.warn("Failed to execute IndicesStatsAction for ClusterInfoUpdateJob", (Throwable)e);
                    }
                    InternalClusterInfoService.this.shardSizes = ImmutableOpenMap.of();
                    InternalClusterInfoService.this.shardRoutingToDataPath = ImmutableOpenMap.of();
                }
            }
        });
        try {
            if (!nodeLatch.await(this.fetchTimeout.getMillis(), TimeUnit.MILLISECONDS)) {
                logger.warn("Failed to update node information for ClusterInfoUpdateJob within {} timeout", (Object)this.fetchTimeout);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            if (!indicesLatch.await(this.fetchTimeout.getMillis(), TimeUnit.MILLISECONDS)) {
                logger.warn("Failed to update shard information for ClusterInfoUpdateJob within {} timeout", (Object)this.fetchTimeout);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        ClusterInfo clusterInfo = this.getClusterInfo();
        try {
            this.listener.accept(clusterInfo);
        }
        catch (Exception e) {
            logger.info("Failed executing ClusterInfoService listener", (Throwable)e);
        }
        return clusterInfo;
    }

    static void buildShardLevelInfo(Logger logger, ShardStats[] stats, ImmutableOpenMap.Builder<String, Long> newShardSizes, ImmutableOpenMap.Builder<ShardRouting, String> newShardRoutingToDataPath, ClusterState state) {
        for (ShardStats s : stats) {
            newShardRoutingToDataPath.put(s.getShardRouting(), s.getDataPath());
            long size = s.getStats().getStore().sizeInBytes();
            String sid = ClusterInfo.shardIdentifierFromRouting(s.getShardRouting());
            if (logger.isTraceEnabled()) {
                logger.trace("shard: {} size: {}", (Object)sid, (Object)size);
            }
            newShardSizes.put(sid, size);
        }
    }

    static void fillDiskUsagePerNode(Logger logger, List<NodeStats> nodeStatsArray, ImmutableOpenMap.Builder<String, DiskUsage> newLeastAvaiableUsages, ImmutableOpenMap.Builder<String, DiskUsage> newMostAvaiableUsages) {
        for (NodeStats nodeStats : nodeStatsArray) {
            if (nodeStats.getFs() == null) {
                logger.warn("Unable to retrieve node FS stats for {}", (Object)nodeStats.getNode().getName());
                continue;
            }
            FsInfo.Path leastAvailablePath = null;
            FsInfo.Path mostAvailablePath = null;
            for (FsInfo.Path info : nodeStats.getFs()) {
                if (leastAvailablePath == null) {
                    assert (mostAvailablePath == null);
                    mostAvailablePath = leastAvailablePath = info;
                    continue;
                }
                if (leastAvailablePath.getAvailable().getBytes() > info.getAvailable().getBytes()) {
                    leastAvailablePath = info;
                    continue;
                }
                if (mostAvailablePath.getAvailable().getBytes() >= info.getAvailable().getBytes()) continue;
                mostAvailablePath = info;
            }
            String nodeId = nodeStats.getNode().getId();
            String nodeName = nodeStats.getNode().getName();
            if (logger.isTraceEnabled()) {
                logger.trace("node: [{}], most available: total disk: {}, available disk: {} / least available: total disk: {}, available disk: {}", (Object)nodeId, (Object)mostAvailablePath.getTotal(), (Object)leastAvailablePath.getAvailable(), (Object)leastAvailablePath.getTotal(), (Object)leastAvailablePath.getAvailable());
            }
            if (leastAvailablePath.getTotal().getBytes() < 0L) {
                if (logger.isTraceEnabled()) {
                    logger.trace("node: [{}] least available path has less than 0 total bytes of disk [{}], skipping", (Object)nodeId, (Object)leastAvailablePath.getTotal().getBytes());
                }
            } else {
                newLeastAvaiableUsages.put(nodeId, new DiskUsage(nodeId, nodeName, leastAvailablePath.getPath(), leastAvailablePath.getTotal().getBytes(), leastAvailablePath.getAvailable().getBytes()));
            }
            if (mostAvailablePath.getTotal().getBytes() < 0L) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("node: [{}] most available path has less than 0 total bytes of disk [{}], skipping", (Object)nodeId, (Object)mostAvailablePath.getTotal().getBytes());
                continue;
            }
            newMostAvaiableUsages.put(nodeId, new DiskUsage(nodeId, nodeName, mostAvailablePath.getPath(), mostAvailablePath.getTotal().getBytes(), mostAvailablePath.getAvailable().getBytes()));
        }
    }

    public class SubmitReschedulingClusterInfoUpdatedJob
    implements Runnable {
        @Override
        public void run() {
            block3: {
                if (logger.isTraceEnabled()) {
                    logger.trace("Submitting new rescheduling cluster info update job");
                }
                try {
                    InternalClusterInfoService.this.threadPool.executor(InternalClusterInfoService.this.executorName()).execute(() -> {
                        try {
                            InternalClusterInfoService.this.maybeRefresh();
                        }
                        finally {
                            if (InternalClusterInfoService.this.isMaster) {
                                if (logger.isTraceEnabled()) {
                                    logger.trace("Scheduling next run for updating cluster info in: {}", (Object)InternalClusterInfoService.this.updateFrequency.toString());
                                }
                                InternalClusterInfoService.this.threadPool.scheduleUnlessShuttingDown(InternalClusterInfoService.this.updateFrequency, InternalClusterInfoService.this.executorName(), this);
                            }
                        }
                    });
                }
                catch (EsRejectedExecutionException ex) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Couldn't re-schedule cluster info update task - node might be shutting down", (Throwable)ex);
                }
            }
        }
    }
}

