/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.IOException;
import javajs.util.SB;
import jspecview.common.Coordinate;
import jspecview.source.JDXSourceStreamTokenizer;
import org.jmol.util.Logger;

public class JDXDecompressor {
    private double xFactor;
    private double yFactor;
    private double deltaX;
    private int nPoints;
    private static final String allDelim = "+-%@ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrs? ,\t\n";
    private int ich;
    private int lineNumber = 0;
    private JDXSourceStreamTokenizer t;
    private double firstX;
    private double dx;
    private double maxY = Double.MIN_VALUE;
    private double minY = Double.MAX_VALUE;
    private boolean debugging;
    private Coordinate[] xyCoords;
    private int ipt;
    private String line;
    private String lastLine;
    private int lineLen;
    private SB errorLog;
    private int difVal = Integer.MIN_VALUE;
    private int lastDif = Integer.MIN_VALUE;
    private int dupCount;
    private double xval;
    private double yval;
    private double[] firstLastX;
    private static final String WHITE_SPACE = " ,\t\n";

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public JDXDecompressor(JDXSourceStreamTokenizer jDXSourceStreamTokenizer, double d, double d2, double d3, double d4, int n) {
        this.t = jDXSourceStreamTokenizer;
        this.firstX = d;
        this.xFactor = d2;
        this.yFactor = d3;
        this.deltaX = d4;
        this.nPoints = n;
        this.lineNumber = jDXSourceStreamTokenizer.labelLineNo;
        this.debugging = Logger.isActiveLevel(6);
    }

    private void addPoint(Coordinate coordinate) {
        double d;
        if (this.ipt == this.xyCoords.length) {
            Coordinate[] coordinateArray = new Coordinate[this.ipt * 2];
            System.arraycopy(this.xyCoords, 0, coordinateArray, 0, this.ipt);
            this.xyCoords = coordinateArray;
        }
        if ((d = coordinate.getYVal()) > this.maxY) {
            this.maxY = d;
        } else if (d < this.minY) {
            this.minY = d;
        }
        if (this.debugging) {
            this.logError("Coord: " + this.ipt + coordinate);
        }
        this.xyCoords[this.ipt++] = coordinate;
        this.firstLastX[1] = coordinate.getXVal();
    }

    public Coordinate[] decompressData(SB sB, double[] dArray) {
        this.errorLog = sB;
        this.firstLastX = dArray;
        if (this.debugging) {
            this.logError("firstX=" + this.firstX + " xFactor=" + this.xFactor + " yFactor=" + this.yFactor + " deltaX=" + this.deltaX + " nPoints=" + this.nPoints);
        }
        this.testAlgorithm();
        this.xyCoords = new Coordinate[this.nPoints];
        double d = Math.abs(0.35 * this.deltaX);
        double d2 = Math.abs(1.4 * this.deltaX);
        double d3 = Math.abs(0.6 * this.deltaX);
        try {
            while ((this.line = this.t.readLineTrimmed()) != null && this.line.indexOf("##") < 0) {
                ++this.lineNumber;
                if (this.debugging) {
                    this.logError(String.valueOf(this.lineNumber) + "\t" + this.line);
                }
                if ((this.lineLen = this.line.length()) == 0) continue;
                this.ich = 0;
                boolean bl = this.lastDif != Integer.MIN_VALUE;
                this.xval = this.getValueDelim() * this.xFactor;
                if (this.ipt == 0) {
                    dArray[0] = this.xval;
                    this.dx = this.firstX - this.xval;
                }
                this.xval += this.dx;
                this.yval = this.getYValue();
                Coordinate coordinate = new Coordinate().set(this.xval, this.yval * this.yFactor);
                if (this.ipt == 0) {
                    this.addPoint(coordinate);
                } else {
                    Coordinate coordinate2 = this.xyCoords[this.ipt - 1];
                    double d4 = Math.abs(coordinate2.getXVal() - coordinate.getXVal());
                    if (bl && d4 < d) {
                        this.xyCoords[this.ipt - 1] = coordinate;
                        double d5 = coordinate2.getYVal();
                        double d6 = coordinate.getYVal();
                        if (d6 != d5) {
                            this.logError(String.valueOf(this.lastLine) + "\n" + this.line + "\nY-value Checkpoint Error! Line " + this.lineNumber + " for y1=" + d6 + " y0=" + d5);
                        }
                    } else {
                        this.addPoint(coordinate);
                        if (d4 < d3 || d4 > d2) {
                            this.logError(String.valueOf(this.lastLine) + "\n" + this.line + "\nX-sequence Checkpoint Error! Line " + this.lineNumber + " |x1-x0|=" + d4 + " instead of " + Math.abs(this.deltaX) + " for x1=" + coordinate.getXVal() + " x0=" + coordinate2.getXVal());
                        }
                    }
                }
                while (this.ich < this.lineLen || this.difVal != Integer.MIN_VALUE || this.dupCount > 0) {
                    this.xval += this.deltaX;
                    this.yval = this.getYValue();
                    if (Double.isNaN(this.yval)) continue;
                    this.addPoint(new Coordinate().set(this.xval, this.yval * this.yFactor));
                }
                this.lastLine = this.line;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.nPoints != this.ipt) {
            this.logError("Decompressor did not find " + this.nPoints + " points -- instead " + this.ipt);
            Coordinate[] coordinateArray = new Coordinate[this.ipt];
            System.arraycopy(this.xyCoords, 0, coordinateArray, 0, this.ipt);
            this.xyCoords = coordinateArray;
        }
        return this.deltaX > 0.0 ? this.xyCoords : Coordinate.reverse(this.xyCoords);
    }

    private void logError(String string) {
        if (this.debugging) {
            Logger.debug(string);
        }
        this.errorLog.append(string).appendC('\n');
    }

    private double getYValue() {
        if (this.dupCount > 0) {
            --this.dupCount;
            this.yval = this.lastDif == Integer.MIN_VALUE ? this.yval : this.yval + (double)this.lastDif;
            return this.yval;
        }
        if (this.difVal != Integer.MIN_VALUE) {
            this.yval += (double)this.difVal;
            this.lastDif = this.difVal;
            this.difVal = Integer.MIN_VALUE;
            return this.yval;
        }
        if (this.ich == this.lineLen) {
            return Double.NaN;
        }
        char c = this.line.charAt(this.ich);
        if (this.debugging) {
            Logger.info("" + c);
        }
        switch (c) {
            case '%': {
                this.difVal = 0;
                break;
            }
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': {
                this.difVal = c - 73;
                break;
            }
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': {
                this.difVal = 105 - c;
                break;
            }
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': {
                this.dupCount = c - 82;
                break;
            }
            case 's': {
                this.dupCount = 9;
                break;
            }
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case '@': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': {
                this.lastDif = Integer.MIN_VALUE;
                return this.getValue();
            }
            case '?': {
                this.lastDif = Integer.MIN_VALUE;
                return Double.NaN;
            }
            default: {
                ++this.ich;
                this.lastDif = Integer.MIN_VALUE;
                return this.getYValue();
            }
        }
        ++this.ich;
        if (this.difVal != Integer.MIN_VALUE) {
            this.difVal = this.getDifDup(this.difVal);
        } else {
            this.dupCount = this.getDifDup(this.dupCount) - 1;
        }
        return this.getYValue();
    }

    private int getDifDup(int n) {
        int n2 = this.ich;
        this.next();
        String string = String.valueOf(n) + this.line.substring(n2, this.ich);
        return n2 == this.ich ? n : Integer.valueOf(string);
    }

    private double getValue() {
        int n = this.ich;
        if (this.ich == this.lineLen) {
            return Double.NaN;
        }
        char c = this.line.charAt(this.ich);
        int n2 = 0;
        switch (c) {
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.getValueDelim();
            }
            case '@': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': {
                n2 = c - 64;
                n = ++this.ich;
                break;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': {
                n2 = 96 - c;
                n = ++this.ich;
                break;
            }
            default: {
                ++this.ich;
                return this.getValue();
            }
        }
        this.next();
        return Double.valueOf(String.valueOf(n2) + this.line.substring(n, this.ich));
    }

    /*
     * Unable to fully structure code
     */
    private double getValueDelim() {
        var1_1 = this.ich;
        var2_2 = 0;
        if (true) ** GOTO lbl6
        do {
            ++this.ich;
lbl6:
            // 2 sources

            if (this.ich >= this.lineLen) break;
            v0 = this.line.charAt(this.ich);
            var2_2 = v0;
        } while (" ,\t\n".indexOf(v0) >= 0);
        var3_3 = 1.0;
        switch (var2_2) {
            case 45: {
                var3_3 = -1.0;
            }
            case 43: {
                var1_1 = ++this.ich;
            }
        }
        var2_2 = this.next();
        if (var2_2 == 69 && this.ich + 3 < this.lineLen) {
            switch (this.line.charAt(this.ich + 1)) {
                case '+': 
                case '-': {
                    this.ich += 4;
                    if (this.ich >= this.lineLen) break;
                    v1 = this.line.charAt(this.ich);
                    var2_2 = v1;
                    if (v1 < '0' || var2_2 > 57) break;
                    ++this.ich;
                }
            }
        }
        return var3_3 * Double.valueOf(this.line.substring(var1_1, this.ich));
    }

    private char next() {
        while (this.ich < this.lineLen && allDelim.indexOf(this.line.charAt(this.ich)) < 0) {
            ++this.ich;
        }
        return this.ich == this.lineLen ? (char)'\u0000' : this.line.charAt(this.ich);
    }

    private void testAlgorithm() {
    }
}

