/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.io.File;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Scanner;
import javajs.util.PT;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jmol.api.JmolAppAPI;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.HistoryFile;
import org.openscience.jmol.app.InputScannerThread;
import org.openscience.jmol.app.SplashInterface;

public class JmolApp
implements JmolAppAPI {
    public int port;
    public int startupWidth;
    public int startupHeight;
    public Point border;
    public boolean haveBorder;
    public File userPropsFile;
    public HistoryFile historyFile;
    public HistoryFile pluginFile;
    public boolean haveConsole = true;
    public boolean haveDisplay = true;
    public boolean splashEnabled = true;
    public boolean isDataOnly;
    public boolean isKiosk;
    public boolean isPrintOnly;
    public boolean isSilent;
    public Map<String, Object> info = new Hashtable<String, Object>();
    public Point jmolPosition;
    public float autoAnimationDelay = 0.2f;
    private String modelFilename;
    private String scriptFilename;
    private String script1 = "";
    private String script2 = "";
    private boolean scanInput;
    private String menuFile;

    public JmolApp() {
    }

    public JmolApp(String[] args) {
        if (System.getProperty("javawebstart.version") != null) {
            System.setSecurityManager(null);
        }
        if (System.getProperty("user.home") == null) {
            System.err.println(GT.$("Error starting Jmol: the property 'user.home' is not defined."));
            System.exit(1);
        }
        File ujmoldir = new File(new File(System.getProperty("user.home")), ".jmol");
        ujmoldir.mkdirs();
        this.userPropsFile = new File(ujmoldir, "properties");
        this.historyFile = new HistoryFile(new File(ujmoldir, "history"), "Jmol's persistent values");
        this.pluginFile = new HistoryFile(new File(ujmoldir, "plugins"), "Jmol plugin persistent values");
        this.parseCommandLine(args);
    }

    public void parseCommandLine(String[] args) {
        Options options = this.getOptions();
        CommandLine line = null;
        try {
            PosixParser parser = new PosixParser();
            line = parser.parse(options, args);
        }
        catch (ParseException exception) {
            System.err.println("Unexpected exception: " + exception.toString());
        }
        args = line.getArgs();
        if (args.length > 0) {
            this.modelFilename = args[0];
        }
        this.checkOptions(line, options);
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption("a", "autoanimationdelay", true, GT.$("delay time in seconds for press-and-hold operation of toolbar animation buttons (default 0.2; numbers > 10 assumed to be milliseconds; set to 0 to disable)"));
        options.addOption("b", "backgroundtransparent", false, GT.$("transparent background"));
        options.addOption("C", "checkload", false, GT.$("check script syntax only - with file loading"));
        options.addOption("c", "check", false, GT.$("check script syntax only - no file loading"));
        OptionBuilder.withValueSeparator();
        options.addOption("D", "property=value", true, GT.$("supported options are given below"));
        options.addOption("d", "debug", false, GT.$("debug"));
        options.addOption("g", "geometry", true, GT.o(GT.$("window width x height, e.g. {0}"), "-g500x500"));
        options.addOption("h", "help", false, GT.$("give this help page"));
        options.addOption("I", "input", false, GT.$("allow piping of input from System.Input"));
        options.addOption("i", "silent", false, GT.$("silent startup operation"));
        options.addOption("J", "jmolscript1", true, GT.$("Jmol script to execute BEFORE -s option"));
        options.addOption("j", "jmolscript2", true, GT.$("Jmol script to execute AFTER -s option"));
        options.addOption("k", "kiosk", false, GT.$("kiosk mode -- no frame"));
        options.addOption("L", "nosplash", false, GT.$("start with no splash screen"));
        options.addOption("l", "list", false, GT.$("list commands during script execution"));
        options.addOption("M", "multitouch", true, GT.$("use multitouch interface (requires \"sparshui\" parameter"));
        options.addOption("m", "menu", true, GT.$("menu file to use"));
        options.addOption("n", "nodisplay", false, GT.$("no display (and also exit when done)"));
        options.addOption("o", "noconsole", false, GT.$("no console -- all output to sysout"));
        options.addOption("P", "port", true, GT.$("port for JSON/MolecularPlayground-style communication"));
        options.addOption("p", "printOnly", false, GT.$("send only output from print messages to console (implies -i)"));
        options.addOption("q", "quality", true, GT.$("JPG image quality (1-100; default 75) or PNG image compression (0-9; default 2, maximum compression 9)"));
        options.addOption("R", "restricted", false, GT.$("restrict local file access"));
        options.addOption("r", "restrictSpt", false, GT.$("restrict local file access (allow reading of SPT files)"));
        options.addOption("s", "script", true, GT.$("script file to execute or '-' for System.in"));
        options.addOption("T", "headlessmaxtime", true, GT.$("headless max time (sec)"));
        options.addOption("t", "threaded", false, GT.$("independent command thread"));
        options.addOption("U", "plugin", true, GT.$("plugin to start initially"));
        options.addOption("w", "write", true, GT.o(GT.$("{0} or {1}:filename"), new Object[]{"CLIP", "GIF|JPG|JPG64|PNG|PPM"}));
        options.addOption("x", "exit", false, GT.$("exit after script (implicit with -n)"));
        return options;
    }

    private void checkOptions(CommandLine line, Options options) {
        if (line.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.setOptionComparator(new OptSort());
            formatter.printHelp("Jmol", options);
            System.out.println();
            System.out.println(GT.$("For example:"));
            System.out.println();
            System.out.println("Jmol -ions myscript.spt -w JPEG:myfile.jpg > output.txt");
            System.out.println();
            System.out.println(GT.$("The -D options are as follows (defaults in parenthesis) and must be called preceding '-jar Jmol.jar':"));
            System.out.println();
            System.out.println("  cdk.debugging=[true|false] (false)");
            System.out.println("  cdk.debug.stdout=[true|false] (false)");
            System.out.println("  display.speed=[fps|ms] (ms)");
            System.out.println("  logger.debug=[true|false] (false)");
            System.out.println("  logger.error=[true|false] (true)");
            System.out.println("  logger.fatal=[true|false] (true)");
            System.out.println("  logger.info=[true|false] (true)");
            System.out.println("  logger.logLevel=[true|false] (false)");
            System.out.println("  logger.warn=[true|false] (true)");
            System.out.println("  plugin.dir (unset)");
            System.out.println("  user.language=[ca|cs|de|en_GB|en_US|es|fr|hu|it|ko|nl|pt_BR|tr|zh_TW] (en_US)");
            System.exit(0);
        }
        if (line.hasOption("a")) {
            this.autoAnimationDelay = PT.parseFloat(line.getOptionValue("a"));
            if (this.autoAnimationDelay > 10.0f) {
                this.autoAnimationDelay /= 1000.0f;
            }
            Logger.info("setting autoAnimationDelay to " + this.autoAnimationDelay + " seconds");
        }
        if (line.hasOption("d")) {
            Logger.setLogLevel(5);
        }
        this.info.put(this.isDataOnly ? "JmolData" : "Jmol", Boolean.TRUE);
        if (line.hasOption("k")) {
            this.isKiosk = true;
            this.info.put("isKiosk", true);
        }
        if (line.hasOption("P")) {
            this.port = PT.parseInt(line.getOptionValue("P"));
        }
        if (this.port > 0) {
            this.info.put("port", this.port);
        }
        if (line.hasOption("p")) {
            this.isPrintOnly = true;
        }
        if (this.isPrintOnly) {
            this.info.put("printOnly", Boolean.TRUE);
            this.isSilent = true;
        }
        if (line.hasOption("i")) {
            this.isSilent = true;
        }
        if (this.isSilent) {
            this.info.put("silent", Boolean.TRUE);
        }
        if (line.hasOption("o")) {
            this.haveConsole = false;
        }
        if (!this.haveConsole) {
            this.info.put("noConsole", Boolean.TRUE);
        }
        if (line.hasOption("b")) {
            this.info.put("transparentBackground", Boolean.TRUE);
        }
        if (line.hasOption("R")) {
            this.info.put("access:NONE", Boolean.TRUE);
        }
        if (line.hasOption("r")) {
            this.info.put("access:READSPT", Boolean.TRUE);
        }
        if (line.hasOption("t")) {
            this.info.put("useCommandThread", Boolean.TRUE);
        }
        if (line.hasOption("l")) {
            this.info.put("listCommands", Boolean.TRUE);
        }
        if (line.hasOption("L")) {
            this.splashEnabled = false;
        }
        if (line.hasOption("c")) {
            this.info.put("check", Boolean.TRUE);
        }
        if (line.hasOption("C")) {
            this.info.put("checkLoad", Boolean.TRUE);
        }
        if (line.hasOption("m")) {
            this.menuFile = line.getOptionValue("m");
        }
        if (line.hasOption("J")) {
            this.script1 = line.getOptionValue("J");
        }
        if (line.hasOption("M")) {
            this.info.put("multitouch", line.getOptionValue("M"));
        }
        if (line.hasOption("s")) {
            this.scriptFilename = line.getOptionValue("s");
        }
        if (line.hasOption("U")) {
            this.info.put("plugin", line.getOptionValue("U"));
        }
        if (line.hasOption("j")) {
            this.script2 = line.getOptionValue("j");
        }
        if (this.haveDisplay && this.historyFile != null) {
            String vers = System.getProperty("java.version");
            if (vers.compareTo("1.1.2") < 0) {
                System.out.println("!!!WARNING: Swing components require a 1.1.2 or higher version VM!!!");
            }
            if (!this.isKiosk) {
                Dimension size = this.historyFile.getWindowSize("Jmol");
                if (size != null) {
                    this.startupWidth = size.width;
                    this.startupHeight = size.height;
                }
                this.historyFile.getWindowBorder("Jmol");
                this.border = new Point(12, 116);
            }
        }
        int width = this.isKiosk ? 0 : 500;
        int height = 500;
        if (line.hasOption("g")) {
            String geometry = line.getOptionValue("g");
            int indexX = geometry.indexOf(120);
            if (indexX > 0) {
                width = PT.parseInt(geometry.substring(0, indexX));
                height = PT.parseInt(geometry.substring(indexX + 1));
            } else {
                width = height = PT.parseInt(geometry);
            }
            this.startupWidth = -1;
        }
        if (this.startupWidth <= 0 || this.startupHeight <= 0) {
            if (this.haveDisplay && !this.isKiosk && this.border != null) {
                this.startupWidth = width + this.border.x;
                this.startupHeight = height + this.border.y;
            } else {
                this.startupWidth = width;
                this.startupHeight = height;
            }
        }
        if (line.hasOption("w")) {
            String type_name;
            int quality = -1;
            if (line.hasOption("q")) {
                quality = PT.parseInt(line.getOptionValue("q"));
            }
            if ((type_name = line.getOptionValue("w")) != null) {
                if (type_name.length() == 0) {
                    type_name = "JPG:jpg";
                }
                if (type_name.indexOf(":") < 0) {
                    type_name = type_name + ":jpg";
                }
                int i = type_name.indexOf(":");
                String type = type_name.substring(0, i).toUpperCase();
                type_name = type_name.substring(i + 1).trim();
                if (type.indexOf(" ") >= 0) {
                    quality = PT.parseInt(type.substring(type.indexOf(" ")).trim());
                    type.substring(0, type.indexOf(" "));
                }
                if (GraphicsEnvironment.isHeadless()) {
                    Hashtable<String, Object> data = new Hashtable<String, Object>();
                    data.put("fileName", type_name);
                    data.put("type", type);
                    data.put("quality", quality);
                    data.put("width", width);
                    data.put("height", height);
                    this.info.put("headlessImage", data);
                } else {
                    this.script2 = this.script2 + ";write image " + (width > 0 && height > 0 ? width + " " + height : "") + " " + type + " " + quality + " " + PT.esc(type_name);
                }
            }
        }
        if (GraphicsEnvironment.isHeadless()) {
            this.info.put("headlistMaxTimeMs", 1000 * (line.hasOption("T") ? PT.parseInt(line.getOptionValue("T")) : 60));
        }
        if (line.hasOption("I")) {
            this.scanInput = true;
        }
        boolean exitUponCompletion = false;
        if (line.hasOption("n")) {
            this.haveDisplay = false;
            boolean bl = exitUponCompletion = !this.scanInput;
        }
        if (line.hasOption("x")) {
            exitUponCompletion = true;
        }
        if (!this.haveDisplay) {
            this.info.put("noDisplay", Boolean.TRUE);
        }
        if (exitUponCompletion) {
            this.info.put("exit", Boolean.TRUE);
            this.script2 = this.script2 + ";exitJmol;";
        }
    }

    public void startViewer(JmolViewer vwr, SplashInterface splash, boolean isJmolData) {
        String plugin;
        if (this.menuFile != null) {
            vwr.setMenu(this.menuFile, true);
        }
        if (this.modelFilename != null) {
            if (this.script1 == null) {
                this.script1 = "";
            }
            this.script1 = (this.modelFilename.endsWith(".spt") ? "script " : "load ") + PT.esc(this.modelFilename) + ";" + this.script1;
        }
        if (this.script1 != null && this.script1.length() > 0) {
            if (!this.isSilent) {
                Logger.info("Executing script: " + this.script1);
            }
            if (splash != null) {
                splash.showStatus(GT.$("Executing script 1..."));
            }
            this.runScript(this.script1, isJmolData, vwr);
        }
        if (this.scriptFilename != null) {
            if (!this.isSilent) {
                Logger.info("Executing script from file: " + this.scriptFilename);
            }
            if (splash != null) {
                splash.showStatus(GT.$("Executing script file..."));
            }
            if (this.scriptFilename.equals("-")) {
                Scanner scan = new Scanner(System.in);
                String linein = "";
                StringBuilder script = new StringBuilder();
                while (scan.hasNextLine() && (linein = scan.nextLine()) != null && !linein.equals("!quit")) {
                    script.append(linein).append("\n");
                }
                scan.close();
                this.runScript(script.toString(), isJmolData, vwr);
            } else {
                vwr.evalFile(this.scriptFilename);
            }
        }
        if (this.script2 != null && this.script2.length() > 0) {
            if (!this.isSilent) {
                Logger.info("Executing script: " + this.script2);
            }
            if (splash != null) {
                splash.showStatus(GT.$("Executing script 2..."));
            }
            this.runScript(this.script2, isJmolData, vwr);
        }
        if ((plugin = (String)this.info.get("plugin")) != null) {
            ((Viewer)vwr).startPlugin(plugin);
        }
        if (this.scanInput) {
            new InputScannerThread(vwr, this.isSilent);
        }
    }

    private void runScript(String script, boolean outputResults, JmolViewer vwr) {
        if (outputResults) {
            System.out.print(vwr.scriptWaitStatus(script, null));
        } else {
            vwr.script(script);
        }
    }

    @Override
    public void addHistoryWindowInfo(String name, Component window, Point border) {
        this.historyFile.addWindowInfo(name, window, border);
    }

    @Override
    public Point getHistoryWindowPosition(String name) {
        return this.historyFile.getWindowPosition(name);
    }

    @Override
    public Dimension getHistoryWindowSize(String name) {
        return this.historyFile.getWindowSize(name);
    }

    class OptSort
    implements Comparator<Option> {
        OptSort() {
        }

        @Override
        public int compare(Option o1, Option o2) {
            char uc2;
            char c1 = o1.getOpt().charAt(0);
            char c2 = o2.getOpt().charAt(0);
            char uc1 = Character.toUpperCase(c1);
            return uc1 == (uc2 = Character.toUpperCase(c2)) ? (c1 < c2 ? -1 : 1) : Character.compare(uc1, uc2);
        }
    }
}

