/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.SequenceElement;
import net.sf.sdedit.drawable.Strokes;
import net.sf.sdedit.util.Direction;

public class Note
extends SequenceElement {
    private int number;
    private int padding;
    private int margin;
    private List<Point> targets;
    private Point[] anchors;
    private Lifeline location;
    private boolean consuming;
    private URI link;
    private long targetId;
    private int subId;

    public Note(Lifeline location, int number, String[] text, boolean consuming) {
        super(location.getDiagram(), location, location.getRightNeighbour(), text, Direction.RIGHT, 0);
        this.number = number;
        this.consuming = consuming;
        this.location = location;
        this.padding = this.configuration().getNotePadding();
        this.margin = this.configuration().getNoteMargin();
        int totalTextHeight = this.textHeight();
        this.setHeight(this.margin * 2 + this.padding + totalTextHeight);
        this.setWidth(this.margin * 2 + this.padding * 2 + this.leftPadding() + this.rightPadding() + this.textWidth());
        this.targets = new LinkedList<Point>();
        this.targetId = 0L;
        this.subId = -1;
    }

    public void setTargetId(long id) {
        this.targetId = id;
    }

    public long getTargetId() {
        return this.targetId;
    }

    public void setSubId(int id) {
        this.subId = id;
    }

    public int getSubId() {
        return this.subId;
    }

    public boolean isConsuming() {
        return this.consuming;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void addTarget(Point target) {
        this.targets.add(target);
    }

    public Lifeline getLocation() {
        return this.location;
    }

    public void setLink(URI link) {
        this.link = link;
    }

    public URI getLink() {
        return this.link;
    }

    private int distance2(Point p0, Point p1) {
        int d0 = Math.abs(p0.x - p1.x);
        int d1 = Math.abs(p0.y - p1.y);
        return d0 * d0 + d1 * d1;
    }

    private Point findStart(Point anch) {
        Point a = null;
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            int d = this.distance2(anch, this.anchors[i]);
            if (d > min) continue;
            a = this.anchors[i];
            min = d;
        }
        return a;
    }

    @Override
    public void computeLayoutInformation() {
        int left = this.getLeftEndpoint().getLeft() + this.getLeftEndpoint().getWidth();
        this.setLeft(left);
        this.anchors = new Point[4];
        this.anchors[0] = new Point(this.getLeft() + this.margin, this.getTop() + this.getHeight() / 2);
        this.anchors[1] = new Point(this.getLeft() + this.getWidth() / 2, this.getTop() + this.margin);
        this.anchors[2] = new Point(this.getLeft() + this.getWidth() / 2, this.getTop() + this.getHeight() - this.margin);
        this.anchors[3] = new Point(this.getLeft() + this.getWidth() - this.margin, this.getTop() + this.getHeight() / 2);
    }

    @Override
    protected void drawObject(Graphics2D g2d) {
        int left = this.getLeft();
        int cornerx = left + this.getWidth() - this.margin - this.padding;
        int cornery = this.getTop() + this.margin + this.padding;
        g2d.setStroke(Strokes.getStroke(Strokes.StrokeType.SOLID, this.diagram().getConfiguration().getNoteBorderThickness()));
        Polygon p1 = new Polygon();
        p1.addPoint(left + this.margin, this.getTop() + this.margin);
        p1.addPoint(cornerx, this.getTop() + this.margin);
        p1.addPoint(left + this.getWidth() - this.margin, cornery);
        p1.addPoint(left + this.getWidth() - this.margin, this.getTop() + this.getHeight() - this.margin);
        p1.addPoint(left + this.margin, this.getTop() + this.getHeight() - this.margin);
        Polygon p2 = new Polygon();
        p2.addPoint(cornerx, this.getTop() + this.margin);
        p2.addPoint(cornerx, cornery);
        p2.addPoint(left + this.getWidth() - this.margin, cornery);
        g2d.setColor(this.configuration().getNoteBgColor());
        g2d.fillPolygon(p1);
        g2d.fillPolygon(p2);
        g2d.setColor(Color.BLACK);
        g2d.draw(p1);
        g2d.draw(p2);
        this.drawMultilineString(g2d, Color.BLACK, left + this.margin + this.padding, this.getTop() + this.getHeight() - this.margin - this.padding, null);
        for (Point anchor : this.targets) {
            Point start = this.findStart(anchor);
            g2d.setStroke(Strokes.getStroke(Strokes.StrokeType.DOTTED, 1));
            g2d.drawLine(anchor.x, anchor.y, start.x, start.y);
        }
    }

    @Override
    public boolean intersects(Rectangle rectangle) {
        if (this.targets.isEmpty()) {
            return super.intersects(rectangle);
        }
        int left = this.getLeft();
        int right = left + this.getWidth();
        int top = this.getTop();
        int bottom = top + this.getHeight();
        for (Point a : this.targets) {
            left = Math.min(left, a.x);
            right = Math.max(right, a.x);
            top = Math.min(top, a.y);
            bottom = Math.max(bottom, a.y);
        }
        return rectangle.intersects(left - 10, top - 10, right - left + 20, bottom - top + 20);
    }
}

