/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.Configurator;
import net.sf.sdedit.ui.components.configuration.DataObject;
import net.sf.sdedit.util.ListModelAdapter;
import net.sf.sdedit.util.UIUtilities;
import net.sf.sdedit.util.Utilities;

public class FileSetConfigurator<C extends DataObject>
extends Configurator<File[], C>
implements ListSelectionListener,
ListDataListener {
    private static final long serialVersionUID = -7878808664490939790L;
    private JList list;
    private JButton addButton;
    private JButton removeButton;
    private ListModelAdapter lma;
    private JLabel descriptionLabel;
    protected String[] fileTypes;
    private boolean refresh;

    public FileSetConfigurator(Bean<C> bean, PropertyDescriptor property) {
        super(bean, property);
        this.setLayout(new BorderLayout());
        this.lma = new ListModelAdapter();
        this.list = new JList(this.lma);
        this.lma.addListDataListener(this);
        this.list.addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.list);
        this.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        this.removeButton = new JButton(Icons.getIcon("minus"));
        UIUtilities.changeIconButton(this.removeButton);
        this.addButton = new JButton(Icons.getIcon("plus"));
        UIUtilities.changeIconButton(this.addButton);
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.removeButton);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.descriptionLabel = new JLabel(this.getAdjustable().info());
        topPanel.add((Component)this.descriptionLabel, "Center");
        topPanel.add((Component)buttonPanel, "East");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSetConfigurator.this.addFiles();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSetConfigurator.this.removeFiles();
            }
        });
        this.removeButton.addActionListener(this);
        this.removeButton.setEnabled(false);
        this.setPreferredSize(new Dimension(300, 125));
        this.fileTypes = this.getProperty().getWriteMethod().getAnnotation(Adjustable.class).filetypes();
    }

    @Override
    protected void _actionPerformed(ActionEvent evt) {
        this.getBean().setValue(this.getProperty(), Utilities.castArray(this.lma.getData(), File.class));
    }

    protected void addFiles() {
        int val;
        if (this.fileTypes.length > 0) {
            this.addFileTypes(this.fileTypes);
        }
        File dir = null;
        for (File file : (File[])this.getValue()) {
            if (dir == null) {
                dir = file.getParentFile();
                continue;
            }
            if (file.getParentFile().equals(dir)) continue;
            dir = null;
            break;
        }
        if (dir != null) {
            FileSetConfigurator.fileChooser().setCurrentDirectory(dir);
        }
        if ((val = FileSetConfigurator.fileChooser().showOpenDialog(null)) == 0) {
            LinkedList<File> files = new LinkedList<File>(Arrays.asList(Utilities.castArray(this.lma.getData(), File.class)));
            for (File selected : FileSetConfigurator.fileChooser().getSelectedFiles()) {
                if (files.contains(selected)) continue;
                files.add(selected);
            }
            this.lma.setData(files);
        }
        this.removeFileTypes(this.fileTypes);
    }

    protected void removeFiles() {
        int[] indices = this.list.getSelectedIndices();
        File[] old = Utilities.castArray(this.lma.getData(), File.class);
        LinkedList<File> newFiles = new LinkedList<File>();
        int j = 0;
        for (int i = 0; i < old.length; ++i) {
            if (j < indices.length && indices[j] == i) {
                ++j;
                continue;
            }
            newFiles.add(old[i]);
        }
        this.lma.setData(newFiles);
    }

    @Override
    protected void _setEnabled(boolean enabled) {
        this.descriptionLabel.setEnabled(enabled);
        this.list.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled && ((File[])this.getValue()).length > 0 && this.list.getSelectedIndices().length > 0);
    }

    @Override
    protected void refresh(File[] value) {
        this.refresh = true;
        this.lma.setData(Arrays.asList(value));
        this.refresh = false;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int l = ((File[])FileSetConfigurator.this.getValue()).length;
                FileSetConfigurator.this.removeButton.setEnabled(l > 0 && FileSetConfigurator.this.list.getSelectedIndices().length > 0);
            }
        });
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (!this.refresh) {
            this.actionPerformed(null);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        if (!this.refresh) {
            this.actionPerformed(null);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        if (!this.refresh) {
            this.actionPerformed(null);
        }
    }

    @Override
    public void focus() {
        this.list.requestFocusInWindow();
    }
}

