/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Vector;
import org.freehep.graphicsio.CubicToLinePathConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PolylinePathConstructor
extends CubicToLinePathConstructor {
    private Vector<Point2D.Double> polyline;
    protected boolean closed = false;
    protected boolean fill;

    public PolylinePathConstructor(boolean fill) {
        this(fill, 0.025);
    }

    public PolylinePathConstructor(boolean fill, double resolution) {
        super(resolution);
        this.fill = fill;
    }

    @Override
    public void move(double x, double y) throws IOException {
        this.writePolyline();
        this.polyline = new Vector();
        this.polyline.add(new Point2D.Double(x, y));
        super.move(x, y);
    }

    @Override
    public void line(double x, double y) throws IOException {
        this.polyline.add(new Point2D.Double(x, y));
        super.line(x, y);
    }

    @Override
    public void closePath(double x0, double y0) throws IOException {
        this.closed = true;
        this.writePolyline();
        super.closePath(x0, y0);
    }

    public void writePolyline() throws IOException {
        if (this.polyline != null) {
            this.writePolyline(this.polyline);
        }
        this.closed = false;
        this.polyline = null;
    }

    protected abstract void writePolyline(Vector<Point2D.Double> var1) throws IOException;
}

