/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;
    RGB[] rgbs;

    public ColorDialog(Shell shell) {
        this(shell, 65536);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, ColorDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB[] getRGBs() {
        return this.rgbs;
    }

    public RGB open() {
        boolean bl;
        long l;
        long l2;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        long l3 = 0L;
        l3 = OS.GTK_VERSION >= OS.VERSION(3, 4, 0) ? OS.gtk_color_chooser_dialog_new(byArray, this.parent.topHandle()) : OS.gtk_color_selection_dialog_new(byArray);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        long l4 = 0L;
        GdkColor gdkColor = new GdkColor();
        GdkRGBA gdkRGBA = new GdkRGBA();
        if (OS.GTK_VERSION <= OS.VERSION(3, 4, 0)) {
            if (this.parent != null) {
                l2 = this.parent.topHandle();
                OS.gtk_window_set_transient_for(l3, l2);
                l = OS.gtk_window_get_icon_list(l2);
                if (l != 0L) {
                    OS.gtk_window_set_icon_list(l3, l);
                    OS.g_list_free(l);
                }
            }
            l2 = OS.gtk_window_get_group(0L);
            OS.gtk_window_group_add_window(l2, l3);
            OS.gtk_window_set_modal(l3, true);
            l4 = OS.gtk_color_selection_dialog_get_color_selection(l3);
            if (this.rgb != null) {
                gdkColor.red = (short)(this.rgb.red & 0xFF | (this.rgb.red & 0xFF) << 8);
                gdkColor.green = (short)(this.rgb.green & 0xFF | (this.rgb.green & 0xFF) << 8);
                gdkColor.blue = (short)(this.rgb.blue & 0xFF | (this.rgb.blue & 0xFF) << 8);
                OS.gtk_color_selection_set_current_color(l4, gdkColor);
            }
            OS.gtk_color_selection_set_has_palette(l4, true);
        } else {
            if (this.rgb != null) {
                gdkRGBA.red = (double)this.rgb.red / 255.0;
                gdkRGBA.green = (double)this.rgb.green / 255.0;
                gdkRGBA.blue = (double)this.rgb.blue / 255.0;
                gdkRGBA.alpha = 1.0;
            }
            OS.gtk_color_chooser_set_rgba(l3, gdkRGBA);
        }
        if (this.rgbs != null) {
            if (OS.GTK_VERSION >= OS.VERSION(3, 4, 0)) {
                int n = 9;
                long l5 = OS.g_malloc(GdkRGBA.sizeof * this.rgbs.length);
                for (int i = 0; i < this.rgbs.length; ++i) {
                    RGB rGB = this.rgbs[i];
                    if (rGB == null) continue;
                    gdkRGBA.red = (double)rGB.red / 255.0;
                    gdkRGBA.green = (double)rGB.green / 255.0;
                    gdkRGBA.blue = (double)rGB.blue / 255.0;
                    OS.memmove(l5 + (long)(i * GdkRGBA.sizeof), gdkRGBA, (long)GdkRGBA.sizeof);
                }
                OS.gtk_color_chooser_add_palette(l3, 0, n, this.rgbs.length, l5);
                OS.gtk_color_chooser_set_rgba(l3, gdkRGBA);
                if (OS.gtk_color_chooser_get_use_alpha(l3)) {
                    OS.gtk_color_chooser_set_use_alpha(l3, false);
                }
                OS.g_free(l5);
            } else {
                l2 = OS.g_malloc(GdkColor.sizeof * this.rgbs.length);
                for (int i = 0; i < this.rgbs.length; ++i) {
                    RGB rGB = this.rgbs[i];
                    if (rGB == null) continue;
                    gdkColor.red = (short)(rGB.red & 0xFF | (rGB.red & 0xFF) << 8);
                    gdkColor.green = (short)(rGB.green & 0xFF | (rGB.green & 0xFF) << 8);
                    gdkColor.blue = (short)(rGB.blue & 0xFF | (rGB.blue & 0xFF) << 8);
                    OS.memmove(l2 + (long)(i * GdkColor.sizeof), gdkColor, (long)GdkColor.sizeof);
                }
                l = OS.gtk_color_selection_palette_to_string(l2, this.rgbs.length);
                int n = OS.strlen(l);
                byArray = new byte[n];
                OS.memmove(byArray, l, (long)n);
                String string = new String(Converter.mbcsToWcs(null, byArray));
                byArray = Converter.wcsToMbcs(null, string, true);
                OS.g_free(l2);
                long l6 = OS.gtk_settings_get_default();
                if (l6 != 0L) {
                    OS.gtk_settings_set_string_property(l6, OS.gtk_color_palette, byArray, Converter.wcsToMbcs(null, "gtk_color_selection_palette_to_string", true));
                }
            }
        }
        display.addIdleProc();
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(l3)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n = 0;
        l = 0L;
        if ((this.style & 0x4000000) != 0) {
            n = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            l = OS.g_signal_add_emission_hook(n, 0, display.emissionProc, l3, 0L);
        }
        display.sendPreExternalEventDispatchEvent();
        int n2 = OS.gtk_dialog_run(l3);
        OS.gdk_threads_leave();
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n, l);
        }
        if (OS.gtk_window_get_modal(l3)) {
            display.setModalDialog(dialog);
        }
        boolean bl2 = bl = n2 == -5;
        if (bl) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (OS.GTK_VERSION >= OS.VERSION(3, 4, 0)) {
                OS.gtk_color_chooser_get_rgba(l3, gdkRGBA);
                n3 = (int)(gdkRGBA.red * 255.0);
                n4 = (int)(gdkRGBA.green * 255.0);
                n5 = (int)(gdkRGBA.blue * 255.0);
            } else {
                OS.gtk_color_selection_get_current_color(l4, gdkColor);
                n3 = gdkColor.red >> 8 & 0xFF;
                n4 = gdkColor.green >> 8 & 0xFF;
                n5 = gdkColor.blue >> 8 & 0xFF;
                long l7 = OS.gtk_settings_get_default();
                if (l7 != 0L) {
                    long[] lArray = new long[1];
                    OS.g_object_get(l7, OS.gtk_color_palette, lArray, 0L);
                    if (lArray[0] != 0L) {
                        int n6 = OS.strlen(lArray[0]);
                        byArray = new byte[n6];
                        OS.memmove(byArray, lArray[0], (long)n6);
                        OS.g_free(lArray[0]);
                        String[] stringArray = null;
                        if (n6 > 0) {
                            String string = new String(Converter.mbcsToWcs(null, byArray));
                            stringArray = ColorDialog.splitString(string, ':');
                            n6 = stringArray.length;
                        }
                        this.rgbs = new RGB[n6];
                        for (int i = 0; i < n6; ++i) {
                            String string = stringArray[i];
                            byArray = Converter.wcsToMbcs(null, string, true);
                            OS.gdk_color_parse(byArray, gdkColor);
                            int n7 = gdkColor.red >> 8 & 0xFF;
                            int n8 = gdkColor.green >> 8 & 0xFF;
                            int n9 = gdkColor.blue >> 8 & 0xFF;
                            this.rgbs[i] = new RGB(n7, n8, n9);
                        }
                    }
                }
            }
            this.rgb = new RGB(n3, n4, n5);
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(l3);
        if (!bl) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }

    public void setRGBs(RGB[] rGBArray) {
        this.rgbs = rGBArray;
    }

    static String[] splitString(String string, char c) {
        String[] stringArray = new String[1];
        int n = 0;
        int n2 = 0;
        while (n2 != -1) {
            n2 = string.indexOf(c, n);
            if (n2 == -1) {
                stringArray[stringArray.length - 1] = string.substring(n);
                continue;
            }
            stringArray[stringArray.length - 1] = string.substring(n, n2);
            n = n2 + 1;
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
        }
        return stringArray;
    }
}

