/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.hamcrest.Condition;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.beans.PropertyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasPropertyWithValue<T>
extends TypeSafeDiagnosingMatcher<T> {
    private static final Condition.Step<PropertyDescriptor, Method> WITH_READ_METHOD = HasPropertyWithValue.withReadMethod();
    private final String propertyName;
    private final Matcher<Object> valueMatcher;

    public HasPropertyWithValue(String propertyName, Matcher<?> valueMatcher) {
        this.propertyName = propertyName;
        this.valueMatcher = HasPropertyWithValue.nastyGenericsWorkaround(valueMatcher);
    }

    public boolean matchesSafely(T bean, Description mismatch) {
        return this.propertyOn(bean, mismatch).and(WITH_READ_METHOD).and(this.withPropertyValue(bean)).matching(this.valueMatcher, "property '" + this.propertyName + "' ");
    }

    public void describeTo(Description description) {
        description.appendText("hasProperty(").appendValue((Object)this.propertyName).appendText(", ").appendDescriptionOf(this.valueMatcher).appendText(")");
    }

    private Condition<PropertyDescriptor> propertyOn(T bean, Description mismatch) {
        PropertyDescriptor property = PropertyUtil.getPropertyDescriptor(this.propertyName, bean);
        if (property == null) {
            mismatch.appendText("No property \"" + this.propertyName + "\"");
            return Condition.notMatched();
        }
        return Condition.matched((Object)property, (Description)mismatch);
    }

    private Condition.Step<Method, Object> withPropertyValue(final T bean) {
        return new Condition.Step<Method, Object>(){

            public Condition<Object> apply(Method readMethod, Description mismatch) {
                try {
                    return Condition.matched((Object)readMethod.invoke(bean, PropertyUtil.NO_ARGUMENTS), (Description)mismatch);
                }
                catch (Exception e) {
                    mismatch.appendText(e.getMessage());
                    return Condition.notMatched();
                }
            }
        };
    }

    private static Matcher<Object> nastyGenericsWorkaround(Matcher<?> valueMatcher) {
        return valueMatcher;
    }

    private static Condition.Step<PropertyDescriptor, Method> withReadMethod() {
        return new Condition.Step<PropertyDescriptor, Method>(){

            public Condition<Method> apply(PropertyDescriptor property, Description mismatch) {
                Method readMethod = property.getReadMethod();
                if (null == readMethod) {
                    mismatch.appendText("property \"" + property.getName() + "\" is not readable");
                    return Condition.notMatched();
                }
                return Condition.matched((Object)readMethod, (Description)mismatch);
            }
        };
    }

    @Factory
    public static <T> Matcher<T> hasProperty(String propertyName, Matcher<?> valueMatcher) {
        return new HasPropertyWithValue<T>(propertyName, valueMatcher);
    }
}

