# The PEP 484 type hints stub file for the QtQuick module.
#
# Generated by SIP 4.19.18
#
# Copyright (c) 2019 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt5.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import typing
import sip

from PyQt5 import QtQml
from PyQt5 import QtGui
from PyQt5 import QtCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., None], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], sip.Buffer, int, None]


class QQuickItem(QtCore.QObject, QtQml.QQmlParserStatus):

    class TransformOrigin(int): ...
    TopLeft = ... # type: 'QQuickItem.TransformOrigin'
    Top = ... # type: 'QQuickItem.TransformOrigin'
    TopRight = ... # type: 'QQuickItem.TransformOrigin'
    Left = ... # type: 'QQuickItem.TransformOrigin'
    Center = ... # type: 'QQuickItem.TransformOrigin'
    Right = ... # type: 'QQuickItem.TransformOrigin'
    BottomLeft = ... # type: 'QQuickItem.TransformOrigin'
    Bottom = ... # type: 'QQuickItem.TransformOrigin'
    BottomRight = ... # type: 'QQuickItem.TransformOrigin'

    class ItemChange(int): ...
    ItemChildAddedChange = ... # type: 'QQuickItem.ItemChange'
    ItemChildRemovedChange = ... # type: 'QQuickItem.ItemChange'
    ItemSceneChange = ... # type: 'QQuickItem.ItemChange'
    ItemVisibleHasChanged = ... # type: 'QQuickItem.ItemChange'
    ItemParentHasChanged = ... # type: 'QQuickItem.ItemChange'
    ItemOpacityHasChanged = ... # type: 'QQuickItem.ItemChange'
    ItemActiveFocusHasChanged = ... # type: 'QQuickItem.ItemChange'
    ItemRotationHasChanged = ... # type: 'QQuickItem.ItemChange'
    ItemAntialiasingHasChanged = ... # type: 'QQuickItem.ItemChange'
    ItemDevicePixelRatioHasChanged = ... # type: 'QQuickItem.ItemChange'
    ItemEnabledHasChanged = ... # type: 'QQuickItem.ItemChange'

    class Flag(int): ...
    ItemClipsChildrenToShape = ... # type: 'QQuickItem.Flag'
    ItemAcceptsInputMethod = ... # type: 'QQuickItem.Flag'
    ItemIsFocusScope = ... # type: 'QQuickItem.Flag'
    ItemHasContents = ... # type: 'QQuickItem.Flag'
    ItemAcceptsDrops = ... # type: 'QQuickItem.Flag'

    class Flags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QQuickItem.Flags', 'QQuickItem.Flag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QQuickItem.Flags') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QQuickItem.Flags': ...
        def __int__(self) -> int: ...

    class ItemChangeData(sip.simplewrapper):

        boolValue = ... # type: bool
        item = ... # type: 'QQuickItem'
        realValue = ... # type: float
        window = ... # type: 'QQuickWindow'

        @typing.overload
        def __init__(self, v: 'QQuickItem') -> None: ...
        @typing.overload
        def __init__(self, v: 'QQuickWindow') -> None: ...
        @typing.overload
        def __init__(self, v: float) -> None: ...
        @typing.overload
        def __init__(self, v: bool) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QQuickItem.ItemChangeData') -> None: ...

    class UpdatePaintNodeData(sip.simplewrapper):

        transformNode = ... # type: 'QSGTransformNode'

        def __init__(self, a0: 'QQuickItem.UpdatePaintNodeData') -> None: ...

    def __init__(self, parent: typing.Optional['QQuickItem'] = ...) -> None: ...

    def containmentMaskChanged(self) -> None: ...
    def setContainmentMask(self, mask: QtCore.QObject) -> None: ...
    def containmentMask(self) -> QtCore.QObject: ...
    def setAcceptTouchEvents(self, accept: bool) -> None: ...
    def acceptTouchEvents(self) -> bool: ...
    def size(self) -> QtCore.QSizeF: ...
    def mapFromGlobal(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    def mapToGlobal(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    def isAncestorOf(self, child: 'QQuickItem') -> bool: ...
    def grabToImage(self, targetSize: QtCore.QSize = ...) -> 'QQuickItemGrabResult': ...
    def resetAntialiasing(self) -> None: ...
    def windowChanged(self, window: 'QQuickWindow') -> None: ...
    def nextItemInFocusChain(self, forward: bool = ...) -> 'QQuickItem': ...
    def setActiveFocusOnTab(self, a0: bool) -> None: ...
    def activeFocusOnTab(self) -> bool: ...
    def updatePolish(self) -> None: ...
    def releaseResources(self) -> None: ...
    def updatePaintNode(self, a0: 'QSGNode', a1: 'QQuickItem.UpdatePaintNodeData') -> 'QSGNode': ...
    def geometryChanged(self, newGeometry: QtCore.QRectF, oldGeometry: QtCore.QRectF) -> None: ...
    def childMouseEventFilter(self, a0: 'QQuickItem', a1: QtCore.QEvent) -> bool: ...
    def dropEvent(self, a0: QtGui.QDropEvent) -> None: ...
    def dragLeaveEvent(self, a0: QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, a0: QtGui.QDragMoveEvent) -> None: ...
    def dragEnterEvent(self, a0: QtGui.QDragEnterEvent) -> None: ...
    def hoverLeaveEvent(self, event: QtGui.QHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: QtGui.QHoverEvent) -> None: ...
    def hoverEnterEvent(self, event: QtGui.QHoverEvent) -> None: ...
    def touchEvent(self, event: QtGui.QTouchEvent) -> None: ...
    def wheelEvent(self, event: QtGui.QWheelEvent) -> None: ...
    def touchUngrabEvent(self) -> None: ...
    def mouseUngrabEvent(self) -> None: ...
    def mouseDoubleClickEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def focusOutEvent(self, a0: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, a0: QtGui.QFocusEvent) -> None: ...
    def inputMethodEvent(self, a0: QtGui.QInputMethodEvent) -> None: ...
    def keyReleaseEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def componentComplete(self) -> None: ...
    def classBegin(self) -> None: ...
    def heightValid(self) -> bool: ...
    def widthValid(self) -> bool: ...
    def updateInputMethod(self, queries: typing.Union[QtCore.Qt.InputMethodQueries, QtCore.Qt.InputMethodQuery] = ...) -> None: ...
    def itemChange(self, a0: 'QQuickItem.ItemChange', a1: 'QQuickItem.ItemChangeData') -> None: ...
    def isComponentComplete(self) -> bool: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def update(self) -> None: ...
    def textureProvider(self) -> 'QSGTextureProvider': ...
    def isTextureProvider(self) -> bool: ...
    def inputMethodQuery(self, query: QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def childAt(self, x: float, y: float) -> 'QQuickItem': ...
    @typing.overload
    def forceActiveFocus(self) -> None: ...
    @typing.overload
    def forceActiveFocus(self, reason: QtCore.Qt.FocusReason) -> None: ...
    def polish(self) -> None: ...
    def mapRectFromScene(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    def mapRectFromItem(self, item: 'QQuickItem', rect: QtCore.QRectF) -> QtCore.QRectF: ...
    def mapFromScene(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    def mapFromItem(self, item: 'QQuickItem', point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    def mapRectToScene(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    def mapRectToItem(self, item: 'QQuickItem', rect: QtCore.QRectF) -> QtCore.QRectF: ...
    def mapToScene(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    def mapToItem(self, item: 'QQuickItem', point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def setKeepTouchGrab(self, a0: bool) -> None: ...
    def keepTouchGrab(self) -> bool: ...
    def ungrabTouchPoints(self) -> None: ...
    def grabTouchPoints(self, ids: typing.Iterable[int]) -> None: ...
    def setFiltersChildMouseEvents(self, filter: bool) -> None: ...
    def filtersChildMouseEvents(self) -> bool: ...
    def setKeepMouseGrab(self, a0: bool) -> None: ...
    def keepMouseGrab(self) -> bool: ...
    def ungrabMouse(self) -> None: ...
    def grabMouse(self) -> None: ...
    def unsetCursor(self) -> None: ...
    def setCursor(self, cursor: typing.Union[QtGui.QCursor, QtCore.Qt.CursorShape]) -> None: ...
    def cursor(self) -> QtGui.QCursor: ...
    def setAcceptHoverEvents(self, enabled: bool) -> None: ...
    def acceptHoverEvents(self) -> bool: ...
    def setAcceptedMouseButtons(self, buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton]) -> None: ...
    def acceptedMouseButtons(self) -> QtCore.Qt.MouseButtons: ...
    def scopedFocusItem(self) -> 'QQuickItem': ...
    def isFocusScope(self) -> bool: ...
    @typing.overload
    def setFocus(self, a0: bool) -> None: ...
    @typing.overload
    def setFocus(self, focus: bool, reason: QtCore.Qt.FocusReason) -> None: ...
    def hasFocus(self) -> bool: ...
    def hasActiveFocus(self) -> bool: ...
    def setFlags(self, flags: typing.Union['QQuickItem.Flags', 'QQuickItem.Flag']) -> None: ...
    def setFlag(self, flag: 'QQuickItem.Flag', enabled: bool = ...) -> None: ...
    def flags(self) -> 'QQuickItem.Flags': ...
    def setAntialiasing(self, a0: bool) -> None: ...
    def antialiasing(self) -> bool: ...
    def setSmooth(self, a0: bool) -> None: ...
    def smooth(self) -> bool: ...
    def setEnabled(self, a0: bool) -> None: ...
    def isEnabled(self) -> bool: ...
    def setVisible(self, a0: bool) -> None: ...
    def isVisible(self) -> bool: ...
    def setOpacity(self, a0: float) -> None: ...
    def opacity(self) -> float: ...
    def setScale(self, a0: float) -> None: ...
    def scale(self) -> float: ...
    def setRotation(self, a0: float) -> None: ...
    def rotation(self) -> float: ...
    def setZ(self, a0: float) -> None: ...
    def z(self) -> float: ...
    def setTransformOrigin(self, a0: 'QQuickItem.TransformOrigin') -> None: ...
    def transformOrigin(self) -> 'QQuickItem.TransformOrigin': ...
    def implicitHeight(self) -> float: ...
    def setImplicitHeight(self, a0: float) -> None: ...
    def resetHeight(self) -> None: ...
    def setHeight(self, a0: float) -> None: ...
    def height(self) -> float: ...
    def implicitWidth(self) -> float: ...
    def setImplicitWidth(self, a0: float) -> None: ...
    def resetWidth(self) -> None: ...
    def setWidth(self, a0: float) -> None: ...
    def width(self) -> float: ...
    def setY(self, a0: float) -> None: ...
    def setX(self, a0: float) -> None: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def setBaselineOffset(self, a0: float) -> None: ...
    def baselineOffset(self) -> float: ...
    def setState(self, a0: str) -> None: ...
    def state(self) -> str: ...
    def setClip(self, a0: bool) -> None: ...
    def clip(self) -> bool: ...
    def childItems(self) -> typing.List['QQuickItem']: ...
    def childrenRect(self) -> QtCore.QRectF: ...
    def stackAfter(self, a0: 'QQuickItem') -> None: ...
    def stackBefore(self, a0: 'QQuickItem') -> None: ...
    def setParentItem(self, parent: 'QQuickItem') -> None: ...
    def parentItem(self) -> 'QQuickItem': ...
    def window(self) -> 'QQuickWindow': ...


class QQuickFramebufferObject(QQuickItem):

    class Renderer(sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QQuickFramebufferObject.Renderer') -> None: ...

        def invalidateFramebufferObject(self) -> None: ...
        def update(self) -> None: ...
        def framebufferObject(self) -> QtGui.QOpenGLFramebufferObject: ...
        def synchronize(self, a0: 'QQuickFramebufferObject') -> None: ...
        def createFramebufferObject(self, size: QtCore.QSize) -> QtGui.QOpenGLFramebufferObject: ...
        def render(self) -> None: ...

    def __init__(self, parent: typing.Optional[QQuickItem] = ...) -> None: ...

    def mirrorVerticallyChanged(self, a0: bool) -> None: ...
    def setMirrorVertically(self, enable: bool) -> None: ...
    def mirrorVertically(self) -> bool: ...
    def releaseResources(self) -> None: ...
    def textureProvider(self) -> 'QSGTextureProvider': ...
    def isTextureProvider(self) -> bool: ...
    def textureFollowsItemSizeChanged(self, a0: bool) -> None: ...
    def updatePaintNode(self, a0: 'QSGNode', a1: QQuickItem.UpdatePaintNodeData) -> 'QSGNode': ...
    def geometryChanged(self, newGeometry: QtCore.QRectF, oldGeometry: QtCore.QRectF) -> None: ...
    def createRenderer(self) -> 'QQuickFramebufferObject.Renderer': ...
    def setTextureFollowsItemSize(self, follows: bool) -> None: ...
    def textureFollowsItemSize(self) -> bool: ...


class QQuickTextureFactory(QtCore.QObject):

    def __init__(self) -> None: ...

    @staticmethod
    def textureFactoryForImage(image: QtGui.QImage) -> 'QQuickTextureFactory': ...
    def image(self) -> QtGui.QImage: ...
    def textureByteCount(self) -> int: ...
    def textureSize(self) -> QtCore.QSize: ...
    def createTexture(self, window: 'QQuickWindow') -> 'QSGTexture': ...


class QQuickImageProvider(QtQml.QQmlImageProviderBase):

    @typing.overload
    def __init__(self, type: QtQml.QQmlImageProviderBase.ImageType, flags: typing.Union[QtQml.QQmlImageProviderBase.Flags, QtQml.QQmlImageProviderBase.Flag] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QQuickImageProvider') -> None: ...

    def requestTexture(self, id: str, requestedSize: QtCore.QSize) -> typing.Tuple[QQuickTextureFactory, QtCore.QSize]: ...
    def requestPixmap(self, id: str, requestedSize: QtCore.QSize) -> typing.Tuple[QtGui.QPixmap, QtCore.QSize]: ...
    def requestImage(self, id: str, requestedSize: QtCore.QSize) -> typing.Tuple[QtGui.QImage, QtCore.QSize]: ...
    def flags(self) -> QtQml.QQmlImageProviderBase.Flags: ...
    def imageType(self) -> QtQml.QQmlImageProviderBase.ImageType: ...


class QQuickImageResponse(QtCore.QObject):

    def __init__(self) -> None: ...

    def finished(self) -> None: ...
    def cancel(self) -> None: ...
    def errorString(self) -> str: ...
    def textureFactory(self) -> QQuickTextureFactory: ...


class QQuickAsyncImageProvider(QQuickImageProvider):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QQuickAsyncImageProvider') -> None: ...

    def requestImageResponse(self, id: str, requestedSize: QtCore.QSize) -> QQuickImageResponse: ...


class QQuickItemGrabResult(QtCore.QObject):

    def ready(self) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def saveToFile(self, fileName: str) -> bool: ...
    def url(self) -> QtCore.QUrl: ...
    def image(self) -> QtGui.QImage: ...


class QQuickPaintedItem(QQuickItem):

    class PerformanceHint(int): ...
    FastFBOResizing = ... # type: 'QQuickPaintedItem.PerformanceHint'

    class RenderTarget(int): ...
    Image = ... # type: 'QQuickPaintedItem.RenderTarget'
    FramebufferObject = ... # type: 'QQuickPaintedItem.RenderTarget'
    InvertedYFramebufferObject = ... # type: 'QQuickPaintedItem.RenderTarget'

    class PerformanceHints(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QQuickPaintedItem.PerformanceHints', 'QQuickPaintedItem.PerformanceHint']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QQuickPaintedItem.PerformanceHints') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QQuickPaintedItem.PerformanceHints': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QQuickItem] = ...) -> None: ...

    def textureSizeChanged(self) -> None: ...
    def setTextureSize(self, size: QtCore.QSize) -> None: ...
    def textureSize(self) -> QtCore.QSize: ...
    def itemChange(self, a0: QQuickItem.ItemChange, a1: QQuickItem.ItemChangeData) -> None: ...
    def releaseResources(self) -> None: ...
    def textureProvider(self) -> 'QSGTextureProvider': ...
    def isTextureProvider(self) -> bool: ...
    def updatePaintNode(self, a0: 'QSGNode', a1: QQuickItem.UpdatePaintNodeData) -> 'QSGNode': ...
    def renderTargetChanged(self) -> None: ...
    def contentsScaleChanged(self) -> None: ...
    def contentsSizeChanged(self) -> None: ...
    def fillColorChanged(self) -> None: ...
    def paint(self, painter: QtGui.QPainter) -> None: ...
    def setRenderTarget(self, target: 'QQuickPaintedItem.RenderTarget') -> None: ...
    def renderTarget(self) -> 'QQuickPaintedItem.RenderTarget': ...
    def setFillColor(self, a0: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def fillColor(self) -> QtGui.QColor: ...
    def setContentsScale(self, a0: float) -> None: ...
    def contentsScale(self) -> float: ...
    def resetContentsSize(self) -> None: ...
    def setContentsSize(self, a0: QtCore.QSize) -> None: ...
    def contentsSize(self) -> QtCore.QSize: ...
    def contentsBoundingRect(self) -> QtCore.QRectF: ...
    def setPerformanceHints(self, hints: typing.Union['QQuickPaintedItem.PerformanceHints', 'QQuickPaintedItem.PerformanceHint']) -> None: ...
    def setPerformanceHint(self, hint: 'QQuickPaintedItem.PerformanceHint', enabled: bool = ...) -> None: ...
    def performanceHints(self) -> 'QQuickPaintedItem.PerformanceHints': ...
    def setMipmap(self, enable: bool) -> None: ...
    def mipmap(self) -> bool: ...
    def setAntialiasing(self, enable: bool) -> None: ...
    def antialiasing(self) -> bool: ...
    def setOpaquePainting(self, opaque: bool) -> None: ...
    def opaquePainting(self) -> bool: ...
    def update(self, rect: QtCore.QRect = ...) -> None: ...


class QQuickRenderControl(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def sceneChanged(self) -> None: ...
    def renderRequested(self) -> None: ...
    def prepareThread(self, targetThread: QtCore.QThread) -> None: ...
    def renderWindow(self, offset: QtCore.QPoint) -> QtGui.QWindow: ...
    @staticmethod
    def renderWindowFor(win: 'QQuickWindow', offset: typing.Optional[QtCore.QPoint] = ...) -> QtGui.QWindow: ...
    def grab(self) -> QtGui.QImage: ...
    def sync(self) -> bool: ...
    def render(self) -> None: ...
    def polishItems(self) -> None: ...
    def invalidate(self) -> None: ...
    def initialize(self, gl: QtGui.QOpenGLContext) -> None: ...


class QQuickTextDocument(QtCore.QObject):

    def __init__(self, parent: QQuickItem) -> None: ...

    def textDocument(self) -> QtGui.QTextDocument: ...


class QQuickWindow(QtGui.QWindow):

    class TextRenderType(int): ...
    QtTextRendering = ... # type: 'QQuickWindow.TextRenderType'
    NativeTextRendering = ... # type: 'QQuickWindow.TextRenderType'

    class RenderStage(int): ...
    BeforeSynchronizingStage = ... # type: 'QQuickWindow.RenderStage'
    AfterSynchronizingStage = ... # type: 'QQuickWindow.RenderStage'
    BeforeRenderingStage = ... # type: 'QQuickWindow.RenderStage'
    AfterRenderingStage = ... # type: 'QQuickWindow.RenderStage'
    AfterSwapStage = ... # type: 'QQuickWindow.RenderStage'
    NoStage = ... # type: 'QQuickWindow.RenderStage'

    class SceneGraphError(int): ...
    ContextNotAvailable = ... # type: 'QQuickWindow.SceneGraphError'

    class CreateTextureOption(int): ...
    TextureHasAlphaChannel = ... # type: 'QQuickWindow.CreateTextureOption'
    TextureHasMipmaps = ... # type: 'QQuickWindow.CreateTextureOption'
    TextureOwnsGLTexture = ... # type: 'QQuickWindow.CreateTextureOption'
    TextureCanUseAtlas = ... # type: 'QQuickWindow.CreateTextureOption'
    TextureIsOpaque = ... # type: 'QQuickWindow.CreateTextureOption'

    class CreateTextureOptions(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QQuickWindow.CreateTextureOptions', 'QQuickWindow.CreateTextureOption']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QQuickWindow.CreateTextureOptions') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QQuickWindow.CreateTextureOptions': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QtGui.QWindow] = ...) -> None: ...

    @staticmethod
    def setTextRenderType(renderType: 'QQuickWindow.TextRenderType') -> None: ...
    @staticmethod
    def textRenderType() -> 'QQuickWindow.TextRenderType': ...
    @staticmethod
    def sceneGraphBackend() -> str: ...
    def createImageNode(self) -> 'QSGImageNode': ...
    def createRectangleNode(self) -> 'QSGRectangleNode': ...
    @typing.overload
    @staticmethod
    def setSceneGraphBackend(api: 'QSGRendererInterface.GraphicsApi') -> None: ...
    @typing.overload
    @staticmethod
    def setSceneGraphBackend(backend: str) -> None: ...
    def rendererInterface(self) -> 'QSGRendererInterface': ...
    def isSceneGraphInitialized(self) -> bool: ...
    def effectiveDevicePixelRatio(self) -> float: ...
    def scheduleRenderJob(self, job: QtCore.QRunnable, schedule: 'QQuickWindow.RenderStage') -> None: ...
    def sceneGraphError(self, error: 'QQuickWindow.SceneGraphError', message: str) -> None: ...
    def sceneGraphAboutToStop(self) -> None: ...
    def afterAnimating(self) -> None: ...
    def afterSynchronizing(self) -> None: ...
    def openglContextCreated(self, context: QtGui.QOpenGLContext) -> None: ...
    def resetOpenGLState(self) -> None: ...
    def activeFocusItemChanged(self) -> None: ...
    def closing(self, close: 'QQuickCloseEvent') -> None: ...
    @staticmethod
    def setDefaultAlphaBuffer(useAlpha: bool) -> None: ...
    @staticmethod
    def hasDefaultAlphaBuffer() -> bool: ...
    def wheelEvent(self, a0: QtGui.QWheelEvent) -> None: ...
    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mouseDoubleClickEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def keyReleaseEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def focusOutEvent(self, a0: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, a0: QtGui.QFocusEvent) -> None: ...
    def hideEvent(self, a0: QtGui.QHideEvent) -> None: ...
    def showEvent(self, a0: QtGui.QShowEvent) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def exposeEvent(self, a0: QtGui.QExposeEvent) -> None: ...
    def releaseResources(self) -> None: ...
    def update(self) -> None: ...
    def colorChanged(self, a0: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def afterRendering(self) -> None: ...
    def beforeRendering(self) -> None: ...
    def beforeSynchronizing(self) -> None: ...
    def sceneGraphInvalidated(self) -> None: ...
    def sceneGraphInitialized(self) -> None: ...
    def frameSwapped(self) -> None: ...
    def openglContext(self) -> QtGui.QOpenGLContext: ...
    def isPersistentSceneGraph(self) -> bool: ...
    def setPersistentSceneGraph(self, persistent: bool) -> None: ...
    def isPersistentOpenGLContext(self) -> bool: ...
    def setPersistentOpenGLContext(self, persistent: bool) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def clearBeforeRendering(self) -> bool: ...
    def setClearBeforeRendering(self, enabled: bool) -> None: ...
    def createTextureFromId(self, id: int, size: QtCore.QSize, options: typing.Union['QQuickWindow.CreateTextureOptions', 'QQuickWindow.CreateTextureOption'] = ...) -> 'QSGTexture': ...
    @typing.overload
    def createTextureFromImage(self, image: QtGui.QImage) -> 'QSGTexture': ...
    @typing.overload
    def createTextureFromImage(self, image: QtGui.QImage, options: typing.Union['QQuickWindow.CreateTextureOptions', 'QQuickWindow.CreateTextureOption']) -> 'QSGTexture': ...
    def incubationController(self) -> QtQml.QQmlIncubationController: ...
    def renderTargetSize(self) -> QtCore.QSize: ...
    def renderTargetId(self) -> int: ...
    def renderTarget(self) -> QtGui.QOpenGLFramebufferObject: ...
    @typing.overload
    def setRenderTarget(self, fbo: QtGui.QOpenGLFramebufferObject) -> None: ...
    @typing.overload
    def setRenderTarget(self, fboId: int, size: QtCore.QSize) -> None: ...
    def grabWindow(self) -> QtGui.QImage: ...
    def sendEvent(self, a0: QQuickItem, a1: QtCore.QEvent) -> bool: ...
    def mouseGrabberItem(self) -> QQuickItem: ...
    def focusObject(self) -> QtCore.QObject: ...
    def activeFocusItem(self) -> QQuickItem: ...
    def contentItem(self) -> QQuickItem: ...


class QQuickView(QQuickWindow):

    class Status(int): ...
    Null = ... # type: 'QQuickView.Status'
    Ready = ... # type: 'QQuickView.Status'
    Loading = ... # type: 'QQuickView.Status'
    Error = ... # type: 'QQuickView.Status'

    class ResizeMode(int): ...
    SizeViewToRootObject = ... # type: 'QQuickView.ResizeMode'
    SizeRootObjectToView = ... # type: 'QQuickView.ResizeMode'

    @typing.overload
    def __init__(self, parent: typing.Optional[QtGui.QWindow] = ...) -> None: ...
    @typing.overload
    def __init__(self, engine: QtQml.QQmlEngine, parent: QtGui.QWindow) -> None: ...
    @typing.overload
    def __init__(self, source: QtCore.QUrl, parent: typing.Optional[QtGui.QWindow] = ...) -> None: ...

    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def keyReleaseEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def timerEvent(self, a0: QtCore.QTimerEvent) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def statusChanged(self, a0: 'QQuickView.Status') -> None: ...
    def setSource(self, a0: QtCore.QUrl) -> None: ...
    def initialSize(self) -> QtCore.QSize: ...
    def errors(self) -> typing.List[QtQml.QQmlError]: ...
    def status(self) -> 'QQuickView.Status': ...
    def setResizeMode(self, a0: 'QQuickView.ResizeMode') -> None: ...
    def resizeMode(self) -> 'QQuickView.ResizeMode': ...
    def rootObject(self) -> QQuickItem: ...
    def rootContext(self) -> QtQml.QQmlContext: ...
    def engine(self) -> QtQml.QQmlEngine: ...
    def source(self) -> QtCore.QUrl: ...


class QQuickCloseEvent(sip.simplewrapper): ...


class QSGAbstractRenderer(QtCore.QObject):

    class ClearModeBit(int): ...
    ClearColorBuffer = ... # type: 'QSGAbstractRenderer.ClearModeBit'
    ClearDepthBuffer = ... # type: 'QSGAbstractRenderer.ClearModeBit'
    ClearStencilBuffer = ... # type: 'QSGAbstractRenderer.ClearModeBit'

    class ClearMode(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QSGAbstractRenderer.ClearMode', 'QSGAbstractRenderer.ClearModeBit']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSGAbstractRenderer.ClearMode') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QSGAbstractRenderer.ClearMode': ...
        def __int__(self) -> int: ...

    def sceneGraphChanged(self) -> None: ...
    def renderScene(self, fboId: int = ...) -> None: ...
    def clearMode(self) -> 'QSGAbstractRenderer.ClearMode': ...
    def setClearMode(self, mode: typing.Union['QSGAbstractRenderer.ClearMode', 'QSGAbstractRenderer.ClearModeBit']) -> None: ...
    def clearColor(self) -> QtGui.QColor: ...
    def setClearColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def projectionMatrix(self) -> QtGui.QMatrix4x4: ...
    def setProjectionMatrix(self, matrix: QtGui.QMatrix4x4) -> None: ...
    def setProjectionMatrixToRect(self, rect: QtCore.QRectF) -> None: ...
    def viewportRect(self) -> QtCore.QRect: ...
    @typing.overload
    def setViewportRect(self, rect: QtCore.QRect) -> None: ...
    @typing.overload
    def setViewportRect(self, size: QtCore.QSize) -> None: ...
    def deviceRect(self) -> QtCore.QRect: ...
    @typing.overload
    def setDeviceRect(self, rect: QtCore.QRect) -> None: ...
    @typing.overload
    def setDeviceRect(self, size: QtCore.QSize) -> None: ...


class QSGEngine(QtCore.QObject):

    class CreateTextureOption(int): ...
    TextureHasAlphaChannel = ... # type: 'QSGEngine.CreateTextureOption'
    TextureOwnsGLTexture = ... # type: 'QSGEngine.CreateTextureOption'
    TextureCanUseAtlas = ... # type: 'QSGEngine.CreateTextureOption'
    TextureIsOpaque = ... # type: 'QSGEngine.CreateTextureOption'

    class CreateTextureOptions(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QSGEngine.CreateTextureOptions', 'QSGEngine.CreateTextureOption']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSGEngine.CreateTextureOptions') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QSGEngine.CreateTextureOptions': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def createImageNode(self) -> 'QSGImageNode': ...
    def createRectangleNode(self) -> 'QSGRectangleNode': ...
    def rendererInterface(self) -> 'QSGRendererInterface': ...
    def createTextureFromId(self, id: int, size: QtCore.QSize, options: typing.Union['QSGEngine.CreateTextureOptions', 'QSGEngine.CreateTextureOption'] = ...) -> 'QSGTexture': ...
    def createTextureFromImage(self, image: QtGui.QImage, options: typing.Union['QSGEngine.CreateTextureOptions', 'QSGEngine.CreateTextureOption'] = ...) -> 'QSGTexture': ...
    def createRenderer(self) -> QSGAbstractRenderer: ...
    def invalidate(self) -> None: ...
    def initialize(self, context: QtGui.QOpenGLContext) -> None: ...


class QSGMaterial(sip.wrapper):

    class Flag(int): ...
    Blending = ... # type: 'QSGMaterial.Flag'
    RequiresDeterminant = ... # type: 'QSGMaterial.Flag'
    RequiresFullMatrixExceptTranslate = ... # type: 'QSGMaterial.Flag'
    RequiresFullMatrix = ... # type: 'QSGMaterial.Flag'
    CustomCompileStep = ... # type: 'QSGMaterial.Flag'

    class Flags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QSGMaterial.Flags', 'QSGMaterial.Flag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSGMaterial.Flags') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QSGMaterial.Flags': ...
        def __int__(self) -> int: ...

    def __init__(self) -> None: ...

    def setFlag(self, flags: typing.Union['QSGMaterial.Flags', 'QSGMaterial.Flag'], enabled: bool = ...) -> None: ...
    def flags(self) -> 'QSGMaterial.Flags': ...
    def compare(self, other: 'QSGMaterial') -> int: ...
    def createShader(self) -> 'QSGMaterialShader': ...
    def type(self) -> 'QSGMaterialType': ...


class QSGFlatColorMaterial(QSGMaterial):

    def __init__(self) -> None: ...

    def compare(self, other: QSGMaterial) -> int: ...
    def color(self) -> QtGui.QColor: ...
    def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def createShader(self) -> 'QSGMaterialShader': ...
    def type(self) -> 'QSGMaterialType': ...


class QSGGeometry(sip.wrapper):

    class Type(int): ...
    ByteType = ... # type: 'QSGGeometry.Type'
    UnsignedByteType = ... # type: 'QSGGeometry.Type'
    ShortType = ... # type: 'QSGGeometry.Type'
    UnsignedShortType = ... # type: 'QSGGeometry.Type'
    IntType = ... # type: 'QSGGeometry.Type'
    UnsignedIntType = ... # type: 'QSGGeometry.Type'
    FloatType = ... # type: 'QSGGeometry.Type'

    class DrawingMode(int): ...
    DrawPoints = ... # type: 'QSGGeometry.DrawingMode'
    DrawLines = ... # type: 'QSGGeometry.DrawingMode'
    DrawLineLoop = ... # type: 'QSGGeometry.DrawingMode'
    DrawLineStrip = ... # type: 'QSGGeometry.DrawingMode'
    DrawTriangles = ... # type: 'QSGGeometry.DrawingMode'
    DrawTriangleStrip = ... # type: 'QSGGeometry.DrawingMode'
    DrawTriangleFan = ... # type: 'QSGGeometry.DrawingMode'

    class AttributeType(int): ...
    UnknownAttribute = ... # type: 'QSGGeometry.AttributeType'
    PositionAttribute = ... # type: 'QSGGeometry.AttributeType'
    ColorAttribute = ... # type: 'QSGGeometry.AttributeType'
    TexCoordAttribute = ... # type: 'QSGGeometry.AttributeType'
    TexCoord1Attribute = ... # type: 'QSGGeometry.AttributeType'
    TexCoord2Attribute = ... # type: 'QSGGeometry.AttributeType'

    class DataPattern(int): ...
    AlwaysUploadPattern = ... # type: 'QSGGeometry.DataPattern'
    StreamPattern = ... # type: 'QSGGeometry.DataPattern'
    DynamicPattern = ... # type: 'QSGGeometry.DataPattern'
    StaticPattern = ... # type: 'QSGGeometry.DataPattern'

    GL_POINTS = ... # type: int
    GL_LINES = ... # type: int
    GL_LINE_LOOP = ... # type: int
    GL_LINE_STRIP = ... # type: int
    GL_TRIANGLES = ... # type: int
    GL_TRIANGLE_STRIP = ... # type: int
    GL_TRIANGLE_FAN = ... # type: int

    GL_BYTE = ... # type: int
    GL_DOUBLE = ... # type: int
    GL_FLOAT = ... # type: int
    GL_INT = ... # type: int

    class Attribute(sip.simplewrapper):

        attributeType = ... # type: 'QSGGeometry.AttributeType'
        isVertexCoordinate = ... # type: int
        position = ... # type: int
        tupleSize = ... # type: int
        type = ... # type: int

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSGGeometry.Attribute') -> None: ...

        @staticmethod
        def createWithAttributeType(pos: int, tupleSize: int, primitiveType: int, attributeType: 'QSGGeometry.AttributeType') -> 'QSGGeometry.Attribute': ...
        @staticmethod
        def create(pos: int, tupleSize: int, primitiveType: int, isPosition: bool = ...) -> 'QSGGeometry.Attribute': ...

    class AttributeSet(sip.simplewrapper):

        attributes = ... # type: sip.array[QSGGeometry.Attribute]
        count = ... # type: int
        stride = ... # type: int

        def __init__(self, attributes: typing.Iterable['QSGGeometry.Attribute'], stride: int = ...) -> None: ...

    class Point2D(sip.simplewrapper):

        x = ... # type: float
        y = ... # type: float

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSGGeometry.Point2D') -> None: ...

        def set(self, nx: float, ny: float) -> None: ...

    class TexturedPoint2D(sip.simplewrapper):

        tx = ... # type: float
        ty = ... # type: float
        x = ... # type: float
        y = ... # type: float

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSGGeometry.TexturedPoint2D') -> None: ...

        def set(self, nx: float, ny: float, ntx: float, nty: float) -> None: ...

    class ColoredPoint2D(sip.simplewrapper):

        a = ... # type: int
        b = ... # type: int
        g = ... # type: int
        r = ... # type: int
        x = ... # type: float
        y = ... # type: float

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSGGeometry.ColoredPoint2D') -> None: ...

        def set(self, nx: float, ny: float, nr: int, ng: int, nb: int, na: int) -> None: ...

    @typing.overload
    def __init__(self, attribs: 'QSGGeometry.AttributeSet', vertexCount: int, indexCount: int = ..., indexType: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QSGGeometry') -> None: ...

    @staticmethod
    def updateColoredRectGeometry(g: 'QSGGeometry', rect: QtCore.QRectF) -> None: ...
    def sizeOfIndex(self) -> int: ...
    def vertexDataAsColoredPoint2D(self) -> sip.array[QSGGeometry.ColoredPoint2D]: ...
    def vertexDataAsTexturedPoint2D(self) -> sip.array[QSGGeometry.TexturedPoint2D]: ...
    def vertexDataAsPoint2D(self) -> sip.array[QSGGeometry.Point2D]: ...
    def indexDataAsUShort(self) -> sip.array[int]: ...
    def indexDataAsUInt(self) -> sip.array[int]: ...
    def setLineWidth(self, w: float) -> None: ...
    def lineWidth(self) -> float: ...
    def markVertexDataDirty(self) -> None: ...
    def markIndexDataDirty(self) -> None: ...
    def vertexDataPattern(self) -> 'QSGGeometry.DataPattern': ...
    def setVertexDataPattern(self, p: 'QSGGeometry.DataPattern') -> None: ...
    def indexDataPattern(self) -> 'QSGGeometry.DataPattern': ...
    def setIndexDataPattern(self, p: 'QSGGeometry.DataPattern') -> None: ...
    @staticmethod
    def updateTexturedRectGeometry(g: 'QSGGeometry', rect: QtCore.QRectF, sourceRect: QtCore.QRectF) -> None: ...
    @staticmethod
    def updateRectGeometry(g: 'QSGGeometry', rect: QtCore.QRectF) -> None: ...
    def sizeOfVertex(self) -> int: ...
    def attributes(self) -> sip.array[QSGGeometry.Attribute]: ...
    def attributeCount(self) -> int: ...
    def indexData(self) -> sip.voidptr: ...
    def indexCount(self) -> int: ...
    def indexType(self) -> int: ...
    def vertexData(self) -> sip.voidptr: ...
    def vertexCount(self) -> int: ...
    def allocate(self, vertexCount: int, indexCount: int = ...) -> None: ...
    def drawingMode(self) -> int: ...
    def setDrawingMode(self, mode: int) -> None: ...
    @staticmethod
    def defaultAttributes_ColoredPoint2D() -> 'QSGGeometry.AttributeSet': ...
    @staticmethod
    def defaultAttributes_TexturedPoint2D() -> 'QSGGeometry.AttributeSet': ...
    @staticmethod
    def defaultAttributes_Point2D() -> 'QSGGeometry.AttributeSet': ...


class QSGNode(sip.wrapper):

    class DirtyStateBit(int): ...
    DirtyMatrix = ... # type: 'QSGNode.DirtyStateBit'
    DirtyNodeAdded = ... # type: 'QSGNode.DirtyStateBit'
    DirtyNodeRemoved = ... # type: 'QSGNode.DirtyStateBit'
    DirtyGeometry = ... # type: 'QSGNode.DirtyStateBit'
    DirtyMaterial = ... # type: 'QSGNode.DirtyStateBit'
    DirtyOpacity = ... # type: 'QSGNode.DirtyStateBit'

    class Flag(int): ...
    OwnedByParent = ... # type: 'QSGNode.Flag'
    UsePreprocess = ... # type: 'QSGNode.Flag'
    OwnsGeometry = ... # type: 'QSGNode.Flag'
    OwnsMaterial = ... # type: 'QSGNode.Flag'
    OwnsOpaqueMaterial = ... # type: 'QSGNode.Flag'

    class NodeType(int): ...
    BasicNodeType = ... # type: 'QSGNode.NodeType'
    GeometryNodeType = ... # type: 'QSGNode.NodeType'
    TransformNodeType = ... # type: 'QSGNode.NodeType'
    ClipNodeType = ... # type: 'QSGNode.NodeType'
    OpacityNodeType = ... # type: 'QSGNode.NodeType'

    class Flags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QSGNode.Flags', 'QSGNode.Flag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSGNode.Flags') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QSGNode.Flags': ...
        def __int__(self) -> int: ...

    class DirtyState(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QSGNode.DirtyState', 'QSGNode.DirtyStateBit']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSGNode.DirtyState') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QSGNode.DirtyState': ...
        def __int__(self) -> int: ...

    def __init__(self) -> None: ...

    def preprocess(self) -> None: ...
    def setFlags(self, a0: typing.Union['QSGNode.Flags', 'QSGNode.Flag'], enabled: bool = ...) -> None: ...
    def setFlag(self, a0: 'QSGNode.Flag', enabled: bool = ...) -> None: ...
    def flags(self) -> 'QSGNode.Flags': ...
    def isSubtreeBlocked(self) -> bool: ...
    def markDirty(self, bits: typing.Union['QSGNode.DirtyState', 'QSGNode.DirtyStateBit']) -> None: ...
    def type(self) -> 'QSGNode.NodeType': ...
    def previousSibling(self) -> 'QSGNode': ...
    def nextSibling(self) -> 'QSGNode': ...
    def lastChild(self) -> 'QSGNode': ...
    def firstChild(self) -> 'QSGNode': ...
    def childAtIndex(self, i: int) -> 'QSGNode': ...
    def __len__(self) -> int: ...
    def childCount(self) -> int: ...
    def insertChildNodeAfter(self, node: 'QSGNode', after: 'QSGNode') -> None: ...
    def insertChildNodeBefore(self, node: 'QSGNode', before: 'QSGNode') -> None: ...
    def appendChildNode(self, node: 'QSGNode') -> None: ...
    def prependChildNode(self, node: 'QSGNode') -> None: ...
    def removeAllChildNodes(self) -> None: ...
    def removeChildNode(self, node: 'QSGNode') -> None: ...
    def parent(self) -> 'QSGNode': ...


class QSGBasicGeometryNode(QSGNode):

    def geometry(self) -> QSGGeometry: ...
    def setGeometry(self, geometry: QSGGeometry) -> None: ...


class QSGGeometryNode(QSGBasicGeometryNode):

    def __init__(self) -> None: ...

    def opaqueMaterial(self) -> QSGMaterial: ...
    def setOpaqueMaterial(self, material: QSGMaterial) -> None: ...
    def material(self) -> QSGMaterial: ...
    def setMaterial(self, material: QSGMaterial) -> None: ...


class QSGImageNode(QSGGeometryNode):

    class TextureCoordinatesTransformFlag(int): ...
    NoTransform = ... # type: 'QSGImageNode.TextureCoordinatesTransformFlag'
    MirrorHorizontally = ... # type: 'QSGImageNode.TextureCoordinatesTransformFlag'
    MirrorVertically = ... # type: 'QSGImageNode.TextureCoordinatesTransformFlag'

    class TextureCoordinatesTransformMode(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QSGImageNode.TextureCoordinatesTransformMode', 'QSGImageNode.TextureCoordinatesTransformFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSGImageNode.TextureCoordinatesTransformMode') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QSGImageNode.TextureCoordinatesTransformMode': ...
        def __int__(self) -> int: ...

    @staticmethod
    def rebuildGeometry(g: QSGGeometry, texture: 'QSGTexture', rect: QtCore.QRectF, sourceRect: QtCore.QRectF, texCoordMode: typing.Union['QSGImageNode.TextureCoordinatesTransformMode', 'QSGImageNode.TextureCoordinatesTransformFlag']) -> None: ...
    def ownsTexture(self) -> bool: ...
    def setOwnsTexture(self, owns: bool) -> None: ...
    def textureCoordinatesTransform(self) -> 'QSGImageNode.TextureCoordinatesTransformMode': ...
    def setTextureCoordinatesTransform(self, mode: typing.Union['QSGImageNode.TextureCoordinatesTransformMode', 'QSGImageNode.TextureCoordinatesTransformFlag']) -> None: ...
    def mipmapFiltering(self) -> 'QSGTexture.Filtering': ...
    def setMipmapFiltering(self, filtering: 'QSGTexture.Filtering') -> None: ...
    def filtering(self) -> 'QSGTexture.Filtering': ...
    def setFiltering(self, filtering: 'QSGTexture.Filtering') -> None: ...
    def texture(self) -> 'QSGTexture': ...
    def setTexture(self, texture: 'QSGTexture') -> None: ...
    def sourceRect(self) -> QtCore.QRectF: ...
    @typing.overload
    def setSourceRect(self, r: QtCore.QRectF) -> None: ...
    @typing.overload
    def setSourceRect(self, x: float, y: float, w: float, h: float) -> None: ...
    def rect(self) -> QtCore.QRectF: ...
    @typing.overload
    def setRect(self, rect: QtCore.QRectF) -> None: ...
    @typing.overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...


class QSGMaterialShader(sip.wrapper):

    class RenderState(sip.simplewrapper):

        class DirtyState(int): ...
        DirtyMatrix = ... # type: 'QSGMaterialShader.RenderState.DirtyState'
        DirtyOpacity = ... # type: 'QSGMaterialShader.RenderState.DirtyState'
        DirtyCachedMaterialData = ... # type: 'QSGMaterialShader.RenderState.DirtyState'
        DirtyAll = ... # type: 'QSGMaterialShader.RenderState.DirtyState'

        class DirtyStates(sip.simplewrapper):

            @typing.overload
            def __init__(self) -> None: ...
            @typing.overload
            def __init__(self, f: typing.Union['QSGMaterialShader.RenderState.DirtyStates', 'QSGMaterialShader.RenderState.DirtyState']) -> None: ...
            @typing.overload
            def __init__(self, a0: 'QSGMaterialShader.RenderState.DirtyStates') -> None: ...

            def __hash__(self) -> int: ...
            def __bool__(self) -> int: ...
            def __invert__(self) -> 'QSGMaterialShader.RenderState.DirtyStates': ...
            def __int__(self) -> int: ...

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSGMaterialShader.RenderState') -> None: ...

        def isCachedMaterialDataDirty(self) -> bool: ...
        def devicePixelRatio(self) -> float: ...
        def projectionMatrix(self) -> QtGui.QMatrix4x4: ...
        def context(self) -> QtGui.QOpenGLContext: ...
        def determinant(self) -> float: ...
        def deviceRect(self) -> QtCore.QRect: ...
        def viewportRect(self) -> QtCore.QRect: ...
        def modelViewMatrix(self) -> QtGui.QMatrix4x4: ...
        def combinedMatrix(self) -> QtGui.QMatrix4x4: ...
        def opacity(self) -> float: ...
        def isOpacityDirty(self) -> bool: ...
        def isMatrixDirty(self) -> bool: ...
        def dirtyStates(self) -> 'QSGMaterialShader.RenderState.DirtyStates': ...

    def __init__(self) -> None: ...

    def setShaderSourceFiles(self, type: typing.Union[QtGui.QOpenGLShader.ShaderType, QtGui.QOpenGLShader.ShaderTypeBit], sourceFiles: typing.Iterable[str]) -> None: ...
    def setShaderSourceFile(self, type: typing.Union[QtGui.QOpenGLShader.ShaderType, QtGui.QOpenGLShader.ShaderTypeBit], sourceFile: str) -> None: ...
    def fragmentShader(self) -> str: ...
    def vertexShader(self) -> str: ...
    def initialize(self) -> None: ...
    def compile(self) -> None: ...
    def program(self) -> QtGui.QOpenGLShaderProgram: ...
    def attributeNames(self) -> typing.List[str]: ...
    def updateState(self, state: 'QSGMaterialShader.RenderState', newMaterial: QSGMaterial, oldMaterial: QSGMaterial) -> None: ...
    def deactivate(self) -> None: ...
    def activate(self) -> None: ...


class QSGMaterialType(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QSGMaterialType') -> None: ...


class QSGClipNode(QSGBasicGeometryNode):

    def __init__(self) -> None: ...

    def clipRect(self) -> QtCore.QRectF: ...
    def setClipRect(self, a0: QtCore.QRectF) -> None: ...
    def isRectangular(self) -> bool: ...
    def setIsRectangular(self, rectHint: bool) -> None: ...


class QSGTransformNode(QSGNode):

    def __init__(self) -> None: ...

    def matrix(self) -> QtGui.QMatrix4x4: ...
    def setMatrix(self, matrix: QtGui.QMatrix4x4) -> None: ...


class QSGOpacityNode(QSGNode):

    def __init__(self) -> None: ...

    def opacity(self) -> float: ...
    def setOpacity(self, opacity: float) -> None: ...


class QSGRectangleNode(QSGGeometryNode):

    def color(self) -> QtGui.QColor: ...
    def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def rect(self) -> QtCore.QRectF: ...
    @typing.overload
    def setRect(self, rect: QtCore.QRectF) -> None: ...
    @typing.overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...


class QSGRendererInterface(sip.simplewrapper):

    class ShaderSourceType(int): ...
    ShaderSourceString = ... # type: 'QSGRendererInterface.ShaderSourceType'
    ShaderSourceFile = ... # type: 'QSGRendererInterface.ShaderSourceType'
    ShaderByteCode = ... # type: 'QSGRendererInterface.ShaderSourceType'

    class ShaderCompilationType(int): ...
    RuntimeCompilation = ... # type: 'QSGRendererInterface.ShaderCompilationType'
    OfflineCompilation = ... # type: 'QSGRendererInterface.ShaderCompilationType'

    class ShaderType(int): ...
    UnknownShadingLanguage = ... # type: 'QSGRendererInterface.ShaderType'
    GLSL = ... # type: 'QSGRendererInterface.ShaderType'
    HLSL = ... # type: 'QSGRendererInterface.ShaderType'

    class Resource(int): ...
    DeviceResource = ... # type: 'QSGRendererInterface.Resource'
    CommandQueueResource = ... # type: 'QSGRendererInterface.Resource'
    CommandListResource = ... # type: 'QSGRendererInterface.Resource'
    PainterResource = ... # type: 'QSGRendererInterface.Resource'

    class GraphicsApi(int): ...
    Unknown = ... # type: 'QSGRendererInterface.GraphicsApi'
    Software = ... # type: 'QSGRendererInterface.GraphicsApi'
    OpenGL = ... # type: 'QSGRendererInterface.GraphicsApi'
    Direct3D12 = ... # type: 'QSGRendererInterface.GraphicsApi'
    OpenVG = ... # type: 'QSGRendererInterface.GraphicsApi'

    class ShaderCompilationTypes(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QSGRendererInterface.ShaderCompilationTypes', 'QSGRendererInterface.ShaderCompilationType']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSGRendererInterface.ShaderCompilationTypes') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QSGRendererInterface.ShaderCompilationTypes': ...
        def __int__(self) -> int: ...

    class ShaderSourceTypes(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QSGRendererInterface.ShaderSourceTypes', 'QSGRendererInterface.ShaderSourceType']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSGRendererInterface.ShaderSourceTypes') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QSGRendererInterface.ShaderSourceTypes': ...
        def __int__(self) -> int: ...

    def shaderSourceType(self) -> 'QSGRendererInterface.ShaderSourceTypes': ...
    def shaderCompilationType(self) -> 'QSGRendererInterface.ShaderCompilationTypes': ...
    def shaderType(self) -> 'QSGRendererInterface.ShaderType': ...
    @typing.overload
    def getResource(self, window: QQuickWindow, resource: 'QSGRendererInterface.Resource') -> sip.voidptr: ...
    @typing.overload
    def getResource(self, window: QQuickWindow, resource: str) -> sip.voidptr: ...
    def graphicsApi(self) -> 'QSGRendererInterface.GraphicsApi': ...


class QSGRenderNode(QSGNode):

    class RenderingFlag(int): ...
    BoundedRectRendering = ... # type: 'QSGRenderNode.RenderingFlag'
    DepthAwareRendering = ... # type: 'QSGRenderNode.RenderingFlag'
    OpaqueRendering = ... # type: 'QSGRenderNode.RenderingFlag'

    class StateFlag(int): ...
    DepthState = ... # type: 'QSGRenderNode.StateFlag'
    StencilState = ... # type: 'QSGRenderNode.StateFlag'
    ScissorState = ... # type: 'QSGRenderNode.StateFlag'
    ColorState = ... # type: 'QSGRenderNode.StateFlag'
    BlendState = ... # type: 'QSGRenderNode.StateFlag'
    CullState = ... # type: 'QSGRenderNode.StateFlag'
    ViewportState = ... # type: 'QSGRenderNode.StateFlag'
    RenderTargetState = ... # type: 'QSGRenderNode.StateFlag'

    class StateFlags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QSGRenderNode.StateFlags', 'QSGRenderNode.StateFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSGRenderNode.StateFlags') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QSGRenderNode.StateFlags': ...
        def __int__(self) -> int: ...

    class RenderingFlags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QSGRenderNode.RenderingFlags', 'QSGRenderNode.RenderingFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSGRenderNode.RenderingFlags') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QSGRenderNode.RenderingFlags': ...
        def __int__(self) -> int: ...

    class RenderState(sip.simplewrapper):

        def get(self, state: str) -> sip.voidptr: ...
        def clipRegion(self) -> QtGui.QRegion: ...
        def stencilEnabled(self) -> bool: ...
        def stencilValue(self) -> int: ...
        def scissorEnabled(self) -> bool: ...
        def scissorRect(self) -> QtCore.QRect: ...
        def projectionMatrix(self) -> QtGui.QMatrix4x4: ...

    def inheritedOpacity(self) -> float: ...
    def clipList(self) -> QSGClipNode: ...
    def matrix(self) -> QtGui.QMatrix4x4: ...
    def rect(self) -> QtCore.QRectF: ...
    def flags(self) -> 'QSGRenderNode.RenderingFlags': ...
    def releaseResources(self) -> None: ...
    def render(self, state: 'QSGRenderNode.RenderState') -> None: ...
    def changedStates(self) -> 'QSGRenderNode.StateFlags': ...


class QSGSimpleRectNode(QSGGeometryNode):

    @typing.overload
    def __init__(self, rect: QtCore.QRectF, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...

    def color(self) -> QtGui.QColor: ...
    def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def rect(self) -> QtCore.QRectF: ...
    @typing.overload
    def setRect(self, rect: QtCore.QRectF) -> None: ...
    @typing.overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...


class QSGSimpleTextureNode(QSGGeometryNode):

    class TextureCoordinatesTransformFlag(int): ...
    NoTransform = ... # type: 'QSGSimpleTextureNode.TextureCoordinatesTransformFlag'
    MirrorHorizontally = ... # type: 'QSGSimpleTextureNode.TextureCoordinatesTransformFlag'
    MirrorVertically = ... # type: 'QSGSimpleTextureNode.TextureCoordinatesTransformFlag'

    class TextureCoordinatesTransformMode(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QSGSimpleTextureNode.TextureCoordinatesTransformMode', 'QSGSimpleTextureNode.TextureCoordinatesTransformFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSGSimpleTextureNode.TextureCoordinatesTransformMode') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QSGSimpleTextureNode.TextureCoordinatesTransformMode': ...
        def __int__(self) -> int: ...

    def __init__(self) -> None: ...

    def sourceRect(self) -> QtCore.QRectF: ...
    @typing.overload
    def setSourceRect(self, r: QtCore.QRectF) -> None: ...
    @typing.overload
    def setSourceRect(self, x: float, y: float, w: float, h: float) -> None: ...
    def ownsTexture(self) -> bool: ...
    def setOwnsTexture(self, owns: bool) -> None: ...
    def textureCoordinatesTransform(self) -> 'QSGSimpleTextureNode.TextureCoordinatesTransformMode': ...
    def setTextureCoordinatesTransform(self, mode: typing.Union['QSGSimpleTextureNode.TextureCoordinatesTransformMode', 'QSGSimpleTextureNode.TextureCoordinatesTransformFlag']) -> None: ...
    def filtering(self) -> 'QSGTexture.Filtering': ...
    def setFiltering(self, filtering: 'QSGTexture.Filtering') -> None: ...
    def texture(self) -> 'QSGTexture': ...
    def setTexture(self, texture: 'QSGTexture') -> None: ...
    def rect(self) -> QtCore.QRectF: ...
    @typing.overload
    def setRect(self, rect: QtCore.QRectF) -> None: ...
    @typing.overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...


class QSGTexture(QtCore.QObject):

    class AnisotropyLevel(int): ...
    AnisotropyNone = ... # type: 'QSGTexture.AnisotropyLevel'
    Anisotropy2x = ... # type: 'QSGTexture.AnisotropyLevel'
    Anisotropy4x = ... # type: 'QSGTexture.AnisotropyLevel'
    Anisotropy8x = ... # type: 'QSGTexture.AnisotropyLevel'
    Anisotropy16x = ... # type: 'QSGTexture.AnisotropyLevel'

    class Filtering(int): ...
    None = ... # type: 'QSGTexture.Filtering'
    Nearest = ... # type: 'QSGTexture.Filtering'
    Linear = ... # type: 'QSGTexture.Filtering'

    class WrapMode(int): ...
    Repeat = ... # type: 'QSGTexture.WrapMode'
    ClampToEdge = ... # type: 'QSGTexture.WrapMode'
    MirroredRepeat = ... # type: 'QSGTexture.WrapMode'

    def __init__(self) -> None: ...

    def anisotropyLevel(self) -> 'QSGTexture.AnisotropyLevel': ...
    def setAnisotropyLevel(self, level: 'QSGTexture.AnisotropyLevel') -> None: ...
    def convertToNormalizedSourceRect(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    def verticalWrapMode(self) -> 'QSGTexture.WrapMode': ...
    def setVerticalWrapMode(self, vwrap: 'QSGTexture.WrapMode') -> None: ...
    def horizontalWrapMode(self) -> 'QSGTexture.WrapMode': ...
    def setHorizontalWrapMode(self, hwrap: 'QSGTexture.WrapMode') -> None: ...
    def filtering(self) -> 'QSGTexture.Filtering': ...
    def setFiltering(self, filter: 'QSGTexture.Filtering') -> None: ...
    def mipmapFiltering(self) -> 'QSGTexture.Filtering': ...
    def setMipmapFiltering(self, filter: 'QSGTexture.Filtering') -> None: ...
    def updateBindOptions(self, force: bool = ...) -> None: ...
    def bind(self) -> None: ...
    def removedFromAtlas(self) -> 'QSGTexture': ...
    def isAtlasTexture(self) -> bool: ...
    def normalizedTextureSubRect(self) -> QtCore.QRectF: ...
    def hasMipmaps(self) -> bool: ...
    def hasAlphaChannel(self) -> bool: ...
    def textureSize(self) -> QtCore.QSize: ...
    def textureId(self) -> int: ...


class QSGDynamicTexture(QSGTexture):

    def __init__(self) -> None: ...

    def updateTexture(self) -> bool: ...


class QSGOpaqueTextureMaterial(QSGMaterial):

    def __init__(self) -> None: ...

    def anisotropyLevel(self) -> QSGTexture.AnisotropyLevel: ...
    def setAnisotropyLevel(self, level: QSGTexture.AnisotropyLevel) -> None: ...
    def verticalWrapMode(self) -> QSGTexture.WrapMode: ...
    def setVerticalWrapMode(self, mode: QSGTexture.WrapMode) -> None: ...
    def horizontalWrapMode(self) -> QSGTexture.WrapMode: ...
    def setHorizontalWrapMode(self, mode: QSGTexture.WrapMode) -> None: ...
    def filtering(self) -> QSGTexture.Filtering: ...
    def setFiltering(self, filtering: QSGTexture.Filtering) -> None: ...
    def mipmapFiltering(self) -> QSGTexture.Filtering: ...
    def setMipmapFiltering(self, filtering: QSGTexture.Filtering) -> None: ...
    def texture(self) -> QSGTexture: ...
    def setTexture(self, texture: QSGTexture) -> None: ...
    def compare(self, other: QSGMaterial) -> int: ...
    def createShader(self) -> QSGMaterialShader: ...
    def type(self) -> QSGMaterialType: ...


class QSGTextureMaterial(QSGOpaqueTextureMaterial):

    def __init__(self) -> None: ...

    def createShader(self) -> QSGMaterialShader: ...
    def type(self) -> QSGMaterialType: ...


class QSGTextureProvider(QtCore.QObject):

    def __init__(self) -> None: ...

    def textureChanged(self) -> None: ...
    def texture(self) -> QSGTexture: ...


class QSGVertexColorMaterial(QSGMaterial):

    def __init__(self) -> None: ...

    def createShader(self) -> QSGMaterialShader: ...
    def type(self) -> QSGMaterialType: ...
    def compare(self, other: QSGMaterial) -> int: ...
