/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import javax.mail.search.HeaderTerm;

public class MailboxURLConnection
extends URLConnection {
    protected Store store;
    protected Folder folder;
    protected Message message;
    protected Map headers;
    private List headerKeys;

    public MailboxURLConnection(URL url) {
        super(url);
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        try {
            Session session = Session.getDefaultInstance(System.getProperties());
            URLName urlName = MailboxURLConnection.asURLName(this.url);
            this.store = session.getStore(urlName);
            this.folder = this.store.getDefaultFolder();
            String path = this.url.getPath();
            if ("/".equals(path)) {
                this.folder = this.folder.getFolder("INBOX");
            } else {
                if (path.charAt(0) == '/') {
                    path = path.substring(1);
                }
                int si = path.indexOf(47);
                while (si != -1 && path.length() > 0) {
                    String comp = path.substring(0, si);
                    path = path.substring(si + 1);
                    this.folder = this.folder.getFolder(comp);
                }
            }
            if (!this.folder.exists()) {
                throw new FileNotFoundException(path);
            }
            this.folder.open(1);
            String ref = this.url.getRef();
            if (ref != null) {
                HeaderTerm term = new HeaderTerm("Message-Id", ref);
                Message[] messages = this.folder.search(term);
                if (messages.length <= 0) {
                    throw new FileNotFoundException(ref);
                }
                this.message = messages[0];
                this.headers = new HashMap();
                this.headerKeys = new ArrayList();
                if (this.message instanceof MimeMessage) {
                    MimeMessage mm = (MimeMessage)this.message;
                    Enumeration e = mm.getAllHeaderLines();
                    while (e.hasMoreElements()) {
                        Header header = (Header)e.nextElement();
                        this.headerKeys.add(header.getName());
                        this.headers.put(header.getName(), header.getValue());
                    }
                }
            } else {
                this.headers = Collections.EMPTY_MAP;
                this.headerKeys = Collections.EMPTY_LIST;
            }
        }
        catch (MessagingException e) {
            Exception e2 = e.getNextException();
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            throw new IOException(e.getMessage());
        }
        this.connected = true;
    }

    @Override
    public String getHeaderField(int index) {
        return this.getHeaderField(this.getHeaderFieldKey(index));
    }

    @Override
    public String getHeaderFieldKey(int index) {
        return (String)this.headerKeys.get(index);
    }

    @Override
    public String getHeaderField(String name) {
        return (String)this.headers.get(name);
    }

    public Map getHeaderFields() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public Object getContent() throws IOException {
        if (this.message != null) {
            return this.message;
        }
        return this.folder;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        PipedOutputStream pos = new PipedOutputStream();
        Runnable writer = this.message == null ? new FolderWriter(this.folder, pos) : new MessageWriter(this.message, pos);
        Thread thread = new Thread(writer, "MailboxURLConnection.getInputStream");
        thread.start();
        return new PipedInputStream(pos);
    }

    protected static URLName asURLName(URL url) {
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        String userInfo = url.getUserInfo();
        String username = null;
        String password = null;
        String path = url.getPath();
        if (userInfo != null) {
            int ci = userInfo.indexOf(58);
            username = ci != -1 ? userInfo.substring(0, ci) : userInfo;
            password = ci != -1 ? userInfo.substring(ci + 1) : null;
        }
        return new URLName(protocol, host, port, path, username, password);
    }

    static class FolderWriter
    implements Runnable {
        Folder folder;
        OutputStream out;

        FolderWriter(Folder folder, OutputStream out) {
            this.folder = folder;
            this.out = out;
        }

        @Override
        public void run() {
        }
    }

    static class MessageWriter
    implements Runnable {
        Message message;
        OutputStream out;

        MessageWriter(Message message, OutputStream out) {
            this.message = message;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                if (this.message instanceof MimeMessage) {
                    ((MimeMessage)this.message).writeTo(this.out);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

