### Select pane

Allows you to select pane with `bind-key + 0`.
Requires [`ftpane()` function](https://github.com/junegunn/fzf/wiki/Examples#tmux).

```
# Index starts from 1
set-option -g base-index 1

# select-pane (@george-b)
bind-key 0 run "tmux split-window -p 40 'bash -ci ftpane'"
```

### Search entire file system (ALT-`)

ALT-` key will split the current window and start fzf for the entire list of files. The selected files will be pasted on to the original window.

```
# fzf-locate
bind-key -n 'M-`' run "tmux split-window -p 40 'tmux send-keys -t #{pane_id} \"$(locate / | fzf -m | paste -sd\\  -)\"'"
```