/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.babel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.gui.WholeNumberField;
import tim.prune.load.babel.AddFilterDialog;
import tim.prune.load.babel.FilterDefinition;

public class DiscardFilter
extends FilterDefinition {
    private WholeNumberField _hdopField = null;
    private WholeNumberField _vdopField = null;
    private JComboBox<String> _combineDopsCombo = null;
    private WholeNumberField _numSatsField = null;
    private JCheckBox _noFixCheckbox = null;
    private JCheckBox _unknownFixCheckbox = null;

    public DiscardFilter(AddFilterDialog addFilterDialog) {
        super(addFilterDialog);
        this.makePanelContents();
    }

    protected String getFilterName() {
        return "discard";
    }

    protected void makePanelContents() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.gpsbabel.filter.discard.intro"));
        jLabel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(9));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        jPanel3.setLayout(new GridLayout(0, 3, 4, 2));
        jPanel3.add(new JLabel(I18nManager.getText("dialog.gpsbabel.filter.discard.hdop"), 4));
        this._hdopField = new WholeNumberField(2);
        this._hdopField.addKeyListener(this._paramChangeListener);
        jPanel3.add(this._hdopField);
        this._combineDopsCombo = new JComboBox<String>(new String[]{I18nManager.getText("logic.and"), I18nManager.getText("logic.or")});
        jPanel3.add(this._combineDopsCombo);
        jPanel3.add(new JLabel(I18nManager.getText("dialog.gpsbabel.filter.discard.vdop"), 4));
        this._vdopField = new WholeNumberField(2);
        this._vdopField.addKeyListener(this._paramChangeListener);
        jPanel3.add(this._vdopField);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(new JLabel(I18nManager.getText("dialog.gpsbabel.filter.discard.numsats")));
        this._numSatsField = new WholeNumberField(2);
        this._numSatsField.addKeyListener(this._paramChangeListener);
        jPanel4.add(this._numSatsField);
        jPanel2.add(jPanel4);
        this._noFixCheckbox = new JCheckBox(I18nManager.getText("dialog.gpsbabel.filter.discard.nofix"));
        jPanel2.add(this._noFixCheckbox);
        this._unknownFixCheckbox = new JCheckBox(I18nManager.getText("dialog.gpsbabel.filter.discard.unknownfix"));
        jPanel2.add(this._unknownFixCheckbox);
        jPanel2.add(Box.createVerticalStrut(9));
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        this.add((Component)jPanel, "North");
    }

    public boolean isFilterValid() {
        if (this._hdopField.getText() != null && this._hdopField.getText().length() > 0 && this._hdopField.getValue() <= 0) {
            return false;
        }
        if (this._vdopField.getText() != null && this._vdopField.getText().length() > 0 && this._vdopField.getValue() <= 0) {
            return false;
        }
        if (this._numSatsField.getText() != null && this._numSatsField.getText().length() > 0 && this._numSatsField.getValue() <= 0) {
            return false;
        }
        return this._hdopField.getValue() > 0 || this._vdopField.getValue() > 0 || this._numSatsField.getValue() > 0;
    }

    protected String getParameters() {
        int n;
        int n2;
        if (!this.isFilterValid()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = this._hdopField.getValue();
        if (n3 > 0) {
            stringBuilder.append(",hdop=").append(n3);
        }
        if ((n2 = this._vdopField.getValue()) > 0) {
            stringBuilder.append(",vdop=").append(n2);
            if (n3 > 0 && this._combineDopsCombo.getSelectedIndex() == 0) {
                stringBuilder.append(",hdopandvdop");
            }
        }
        if ((n = this._numSatsField.getValue()) > 0) {
            stringBuilder.append(",sat=").append(n);
        }
        if (this._noFixCheckbox.isSelected()) {
            stringBuilder.append(",fixnone");
        }
        if (this._unknownFixCheckbox.isSelected()) {
            stringBuilder.append(",fixunknown");
        }
        return stringBuilder.toString();
    }
}

