/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmServerBackreferenceReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadReferrersTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private Exception lastException;
    private OsmServerReader reader;
    private final OsmDataLayer targetLayer;
    private final Map<Long, OsmPrimitiveType> children;
    private final DataSet parents;

    public DownloadReferrersTask(OsmDataLayer targetLayer, Collection<OsmPrimitive> children) {
        super("Download referrers", false);
        CheckParameterUtil.ensureParameterNotNull(targetLayer, "targetLayer");
        if (!targetLayer.isDownloadable()) {
            throw new IllegalArgumentException("Non-downloadable layer: " + targetLayer);
        }
        this.canceled = false;
        this.children = new HashMap<Long, OsmPrimitiveType>();
        if (children != null) {
            for (OsmPrimitive p : children) {
                if (p.isNew()) continue;
                this.children.put(p.getId(), OsmPrimitiveType.from(p));
            }
        }
        this.targetLayer = targetLayer;
        this.parents = new DataSet();
    }

    public DownloadReferrersTask(OsmDataLayer targetLayer, PrimitiveId primitiveId, ProgressMonitor progressMonitor) {
        super("Download referrers", progressMonitor, false);
        CheckParameterUtil.ensureParameterNotNull(targetLayer, "targetLayer");
        if (primitiveId.isNew()) {
            throw new IllegalArgumentException(MessageFormat.format("Cannot download referrers for new primitives (ID {0})", primitiveId.getUniqueId()));
        }
        this.canceled = false;
        this.children = new HashMap<Long, OsmPrimitiveType>();
        this.children.put(primitiveId.getUniqueId(), primitiveId.getType());
        this.targetLayer = targetLayer;
        this.parents = new DataSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        DownloadReferrersTask downloadReferrersTask = this;
        synchronized (downloadReferrersTask) {
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionUtil.explainException(this.lastException);
            return;
        }
        DataSetMerger visitor = new DataSetMerger(this.targetLayer.getDataSet(), this.parents);
        visitor.merge();
        SwingUtilities.invokeLater(this.targetLayer::onPostDownloadFromServer);
        if (visitor.getConflicts().isEmpty()) {
            return;
        }
        this.targetLayer.getConflicts().add(visitor.getConflicts());
        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.trn("There was {0} conflict during import.", "There were {0} conflicts during import.", visitor.getConflicts().size(), visitor.getConflicts().size()), I18n.trn("Conflict during download", "Conflicts during download", visitor.getConflicts().size(), new Object[0]), 2);
        MapFrame map = MainApplication.getMap();
        map.conflictDialog.unfurlDialog();
        map.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadParents(long id, OsmPrimitiveType type, ProgressMonitor progressMonitor) throws OsmTransferException {
        this.reader = new OsmServerBackreferenceReader(id, type);
        DataSet ds = this.reader.parseOsm(progressMonitor.createSubTaskMonitor(1, false));
        DownloadReferrersTask downloadReferrersTask = this;
        synchronized (downloadReferrersTask) {
            this.reader = null;
        }
        Collection<Way> ways = ds.getWays();
        if (!ways.isEmpty()) {
            Set nodes = ways.stream().flatMap(w -> w.getNodes().stream()).collect(Collectors.toSet());
            nodes.removeAll(this.targetLayer.data.getNodes());
            if (!nodes.isEmpty()) {
                this.reader = MultiFetchServerObjectReader.create();
                ((MultiFetchServerObjectReader)this.reader).append(nodes);
                DataSet wayNodes = this.reader.parseOsm(progressMonitor.createSubTaskMonitor(1, false));
                DownloadReferrersTask downloadReferrersTask2 = this;
                synchronized (downloadReferrersTask2) {
                    this.reader = null;
                }
                new DataSetMerger(ds, wayNodes).merge();
            }
        }
        new DataSetMerger(this.parents, ds).merge();
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            this.progressMonitor.setTicksCount(this.children.size());
            int i = 1;
            for (Map.Entry<Long, OsmPrimitiveType> entry : this.children.entrySet()) {
                String msg;
                if (this.canceled) {
                    return;
                }
                switch (entry.getValue()) {
                    case NODE: {
                        msg = I18n.tr("({0}/{1}) Loading parents of node {2}", i + 1, this.children.size(), entry.getKey());
                        break;
                    }
                    case WAY: {
                        msg = I18n.tr("({0}/{1}) Loading parents of way {2}", i + 1, this.children.size(), entry.getKey());
                        break;
                    }
                    case RELATION: {
                        msg = I18n.tr("({0}/{1}) Loading parents of relation {2}", i + 1, this.children.size(), entry.getKey());
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                this.progressMonitor.subTask(msg);
                this.downloadParents(entry.getKey(), entry.getValue(), this.progressMonitor);
                ++i;
            }
        }
        catch (OsmTransferException e) {
            if (this.canceled) {
                return;
            }
            this.lastException = e;
        }
    }
}

