import ps= require("./actualParse")
import ts = require("../src/typesystem")
import chai = require("chai");
const assert = chai.assert;
import nm=require("../src/nominals")

describe("Simple validation testing",function() {
    it("basic example access", function () {
        var tp = ps.parseJSONTypeCollection({

            types:{
                XX:{
                    type:"object",
                    properties:{
                        c:"string",
                        y:"boolean"
                    },
                    example:{
                        c:"A",
                        vv:3
                    }
                }
            }
        });
        var t=tp.getType("XX");
        var p=t.exampleObject();
        assert.deepEqual(p,{"c":"A",vv:3})

    });
    it("basic example access 2", function () {
        var tp = ps.parseJSONTypeCollection({

            types:{
                XX:{
                    type:"object",
                    properties:{
                        c: {type:"string",example:"dd"},
                        y:"boolean"
                    },

                }
            }
        });
        var t=tp.getType("XX");
        var p=t.exampleObject();
        assert.deepEqual(p,{"c":"dd",y:true})
    });
    it("basic example access 3", function () {
        var tp = ps.parseJSONTypeCollection({

            types:{
                XX:{
                    type:"object",
                    properties:{
                        c: {type:"string",default:"dd"},
                        y:"boolean"
                    },

                }
            }
        });
        var t=tp.getType("XX");
        var p=t.exampleObject();
        assert.deepEqual(p,{"c":"dd",y:true})
    });
    it("basic example access 4 examples", function () {
        var tp = ps.parseJSONTypeCollection({

            types:{
                XX:{
                    type:"object",
                    properties:{
                        c:"string",
                        y:"boolean"
                    },
                    examples:{
                        R: {
                            value: {
                                c: "A",
                                vv: 3
                            }
                        }
                    }
                }
            }
        });
        var t=tp.getType("XX");
        var p=t.exampleObject();
        assert.deepEqual(p,{"c":"A",vv:3})

    });
    it("basic example access 5 superTypes", function () {
        var tp = ps.parseJSONTypeCollection({

            types:{
                XX:{
                    type:"object",
                    properties:{
                        c:"string",
                        vv:"number"
                    },
                    examples:{
                        R: {
                            value: {
                                c: "A",
                                vv: 3
                            }
                        }
                    }
                },
                XX2:{
                    type:"XX",
                    properties:{
                        c2:{ type: "string",example:"Hee"}

                    },

                }
            }
        });
        var t=tp.getType("XX2");
        var p=t.exampleObject();
        assert.deepEqual(p,{"c":"A",vv:3,"c2":"Hee"})

    });
    it("basic example access from nominal", function () {
        var tp = ps.parseJSONTypeCollection({

            types:{
                XX:{
                    type:"object",
                    properties:{
                        c:"string",
                        vv:"number"
                    },
                    examples:{
                        R: {
                            value: {
                                c: "A",
                                vv: 3
                            }
                        }
                    }
                },
                XX2:{
                    type:"XX",
                    properties:{
                        c2:{ type: "string",example:"Hee"}

                    },

                },
                XX3:{
                    type:"XX",
                    properties:{
                        c2:{ type: "string",example:"Hee"}

                    },
                    example:"A"
                }
            }
        });
        var t=tp.getType("XX2");
        var nt=nm.toNominal(t,x=>null);
        var p=nt.examples()[0];
        assert.deepEqual(p.expandAsJSON(),{"c":"A",vv:3,"c2":"Hee"})
        var t=tp.getType("XX");
        var nt=nm.toNominal(t,x=>null);
        var p=nt.examples()[0];
        assert.deepEqual(p.asJSON(),{"c":"A",vv:3})
        var t=tp.getType("XX3");
        var nt=nm.toNominal(t,x=>null);
        var p=nt.examples()[0];
        assert.deepEqual(p.asJSON(),"A")
    });
    it("basic example access array", function () {
        var tp = ps.parseJSONTypeCollection({

            types:{
                XX:{
                    type:"object",
                    properties:{
                        c:"string",
                        vv:"number"
                    },
                    examples:{
                        R: {
                            value: {
                                c: "A",
                                vv: 3
                            }
                        }
                    }
                },
                XX2:"XX[]"

            }
        });
        var t=tp.getType("XX2");
        var nt=nm.toNominal(t,x=>null);
        var p=nt.examples()[0];
        assert.deepEqual(p.expandAsJSON(),[{"c":"A",vv:3}]);

    });
    it("example object as string ", function () {
        var tp = ps.parseJSONTypeCollection({

            types:{
                XX:{
                    type:"string",
                    example:"AA"
                }
            }
        });
        var t=tp.getType("XX");
        var nt=nm.toNominal(t,x=>null);
        var p=nt.examples()[0];
        assert.deepEqual(p.asString(),"AA");

    });
    it("example object as json string ", function () {
        var tp = ps.parseJSONTypeCollection({

            types:{
                XX:{
                    type:"string",
                    example:"AA"
                }
            }
        });
        var t=tp.getType("XX");
        var nt=nm.toNominal(t,x=>null);
        var p=nt.examples()[0];
        assert.deepEqual(p.expandAsString(),'"AA"');
    });
    it("example object as json string ", function () {
        var tp = ps.parseJSONTypeCollection({

            types:{
                XX:{
                    type:"string",
                    example:"AA"
                }
            }
        });
        var t=tp.getType("XX");
        var nt=nm.toNominal(t,x=>null);
        var p=nt.examples()[0];
        assert.deepEqual(p.expandAsJSON(),"AA");
    });
    it("example object as  string ", function () {
        var tp = ps.parseJSONTypeCollection({

            types:{
                XX:{
                    type:"string",
                    example:4
                }
            }
        });
        var t=tp.getType("XX");
        var nt=nm.toNominal(t,x=>null);
        var p=nt.examples()[0];
        assert.deepEqual(p.asString(),"4");
    });
    it("example object union ", function () {
        var tp = ps.parseJSONTypeCollection({

            types:{
                XX:{
                    type:"string",
                    example:4
                },
                XX2: " XX | number"
            }
        });
        var t=tp.getType("XX2");
        var nt=nm.toNominal(t,x=>null);
        var p=nt.examples()[0];
        assert.isTrue(p.isEmpty());
        assert.deepEqual(p.expandAsJSON(),4);
    });
    it("example object ", function () {
        var tp = ps.parseJSONTypeCollection({

            types:{
                XX:{
                    type:"object",
                    properties:
                    {
                        name: {
                            type: "string",
                            example: "Pavel"
                        },
                        fr:"XX"
                    }
                }
            }
        });
        var t=tp.getType("XX");
        var nt=nm.toNominal(t,x=>null);
        var p=nt.examples()[0];
        assert.isTrue(p.isEmpty())
        assert.deepEqual(p.expandAsJSON(),{ name: "Pavel",fr: null});
    });
})