/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.script.GeneralScriptException;
import org.elasticsearch.script.expression.ReplaceableConstDoubleValueSource;

class ExpressionAggregationScript
implements AggregationScript.LeafFactory {
    final Expression exprScript;
    final SimpleBindings bindings;
    final DoubleValuesSource source;
    final ReplaceableConstDoubleValueSource specialValue;

    ExpressionAggregationScript(Expression e, SimpleBindings b, ReplaceableConstDoubleValueSource v) {
        this.exprScript = e;
        this.bindings = b;
        this.source = this.exprScript.getDoubleValuesSource((Bindings)this.bindings);
        this.specialValue = v;
    }

    public AggregationScript newInstance(final LeafReaderContext leaf) throws IOException {
        return new AggregationScript(){
            DoubleValues values;
            {
                this.values = ExpressionAggregationScript.this.source.getValues(leaf, null);
            }

            public Object execute() {
                try {
                    return this.values.doubleValue();
                }
                catch (Exception exception) {
                    throw new GeneralScriptException("Error evaluating " + ExpressionAggregationScript.this.exprScript, (Throwable)exception);
                }
            }

            public void setDocument(int d) {
                try {
                    this.values.advanceExact(d);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't advance to doc using " + ExpressionAggregationScript.this.exprScript, e);
                }
            }

            public void setNextAggregationValue(Object value) {
                if (ExpressionAggregationScript.this.specialValue != null) {
                    if (value instanceof Number) {
                        ExpressionAggregationScript.this.specialValue.setValue(((Number)value).doubleValue());
                    } else {
                        throw new GeneralScriptException("Cannot use expression with text variable using " + ExpressionAggregationScript.this.exprScript);
                    }
                }
            }
        };
    }

    public boolean needs_score() {
        return false;
    }
}

