/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.geo.geometry.Circle;
import org.elasticsearch.geo.geometry.Geometry;
import org.elasticsearch.geo.geometry.GeometryCollection;
import org.elasticsearch.geo.geometry.GeometryVisitor;
import org.elasticsearch.geo.geometry.Line;
import org.elasticsearch.geo.geometry.LinearRing;
import org.elasticsearch.geo.geometry.MultiLine;
import org.elasticsearch.geo.geometry.MultiPoint;
import org.elasticsearch.geo.geometry.MultiPolygon;
import org.elasticsearch.geo.geometry.Point;
import org.elasticsearch.geo.geometry.Rectangle;
import org.elasticsearch.index.mapper.BaseGeoShapeFieldMapper;
import org.elasticsearch.index.mapper.GeoShapeFieldMapper;
import org.elasticsearch.index.mapper.LegacyGeoShapeFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public class GeoShapeQueryBuilder
extends AbstractQueryBuilder<GeoShapeQueryBuilder> {
    public static final String NAME = "geo_shape";
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(GeoShapeQueryBuilder.class));
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Types are deprecated in [geo_shape] queries. The type should no longer be specified in the [indexed_shape] section.";
    public static final String DEFAULT_SHAPE_INDEX_NAME = "shapes";
    public static final String DEFAULT_SHAPE_FIELD_NAME = "shape";
    public static final ShapeRelation DEFAULT_SHAPE_RELATION = ShapeRelation.INTERSECTS;
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField SHAPE_FIELD = new ParseField("shape", new String[0]);
    private static final ParseField STRATEGY_FIELD = new ParseField("strategy", new String[0]);
    private static final ParseField RELATION_FIELD = new ParseField("relation", new String[0]);
    private static final ParseField INDEXED_SHAPE_FIELD = new ParseField("indexed_shape", new String[0]);
    private static final ParseField SHAPE_ID_FIELD = new ParseField("id", new String[0]);
    private static final ParseField SHAPE_TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ParseField SHAPE_INDEX_FIELD = new ParseField("index", new String[0]);
    private static final ParseField SHAPE_PATH_FIELD = new ParseField("path", new String[0]);
    private static final ParseField SHAPE_ROUTING_FIELD = new ParseField("routing", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String fieldName;
    private final ShapeBuilder shape;
    private final Supplier<ShapeBuilder> supplier;
    private SpatialStrategy strategy;
    private final String indexedShapeId;
    private final String indexedShapeType;
    private String indexedShapeIndex = "shapes";
    private String indexedShapePath = "shape";
    private String indexedShapeRouting;
    private ShapeRelation relation = DEFAULT_SHAPE_RELATION;
    private boolean ignoreUnmapped = false;

    public GeoShapeQueryBuilder(String fieldName, ShapeBuilder shape) {
        this(fieldName, shape, null, null);
    }

    public GeoShapeQueryBuilder(String fieldName, String indexedShapeId) {
        this(fieldName, (ShapeBuilder)null, indexedShapeId, null);
    }

    @Deprecated
    public GeoShapeQueryBuilder(String fieldName, String indexedShapeId, String indexedShapeType) {
        this(fieldName, (ShapeBuilder)null, indexedShapeId, indexedShapeType);
    }

    private GeoShapeQueryBuilder(String fieldName, ShapeBuilder shape, String indexedShapeId, @Nullable String indexedShapeType) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is required");
        }
        if (shape == null && indexedShapeId == null) {
            throw new IllegalArgumentException("either shape or indexedShapeId is required");
        }
        this.fieldName = fieldName;
        this.shape = shape;
        this.indexedShapeId = indexedShapeId;
        this.indexedShapeType = indexedShapeType;
        this.supplier = null;
    }

    private GeoShapeQueryBuilder(String fieldName, Supplier<ShapeBuilder> supplier, String indexedShapeId, @Nullable String indexedShapeType) {
        this.fieldName = fieldName;
        this.shape = null;
        this.supplier = supplier;
        this.indexedShapeId = indexedShapeId;
        this.indexedShapeType = indexedShapeType;
    }

    public GeoShapeQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        if (in.readBoolean()) {
            this.shape = in.readNamedWriteable(ShapeBuilder.class);
            this.indexedShapeId = null;
            this.indexedShapeType = null;
        } else {
            this.shape = null;
            this.indexedShapeId = in.readOptionalString();
            this.indexedShapeType = in.readOptionalString();
            this.indexedShapeIndex = in.readOptionalString();
            this.indexedShapePath = in.readOptionalString();
            this.indexedShapeRouting = in.getVersion().onOrAfter(Version.V_6_4_0) ? in.readOptionalString() : null;
        }
        this.relation = ShapeRelation.readFromStream(in);
        this.strategy = in.readOptionalWriteable(SpatialStrategy::readFromStream);
        this.ignoreUnmapped = in.readBoolean();
        this.supplier = null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.supplier != null) {
            throw new IllegalStateException("supplier must be null, can't serialize suppliers, missing a rewriteAndFetch?");
        }
        out.writeString(this.fieldName);
        boolean hasShape = this.shape != null;
        out.writeBoolean(hasShape);
        if (hasShape) {
            out.writeNamedWriteable(this.shape);
        } else {
            out.writeOptionalString(this.indexedShapeId);
            out.writeOptionalString(this.indexedShapeType);
            out.writeOptionalString(this.indexedShapeIndex);
            out.writeOptionalString(this.indexedShapePath);
            if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
                out.writeOptionalString(this.indexedShapeRouting);
            } else if (this.indexedShapeRouting != null) {
                throw new IllegalStateException("indexed shape routing cannot be serialized to older nodes");
            }
        }
        this.relation.writeTo(out);
        out.writeOptionalWriteable(this.strategy);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public ShapeBuilder shape() {
        return this.shape;
    }

    public String indexedShapeId() {
        return this.indexedShapeId;
    }

    @Deprecated
    public String indexedShapeType() {
        return this.indexedShapeType;
    }

    public GeoShapeQueryBuilder strategy(SpatialStrategy strategy) {
        if (strategy != null && strategy == SpatialStrategy.TERM && this.relation != ShapeRelation.INTERSECTS) {
            throw new IllegalArgumentException("strategy [" + strategy.getStrategyName() + "] only supports relation [" + ShapeRelation.INTERSECTS.getRelationName() + "] found relation [" + this.relation.getRelationName() + "]");
        }
        this.strategy = strategy;
        return this;
    }

    public SpatialStrategy strategy() {
        return this.strategy;
    }

    public GeoShapeQueryBuilder indexedShapeIndex(String indexedShapeIndex) {
        this.indexedShapeIndex = indexedShapeIndex;
        return this;
    }

    public String indexedShapeIndex() {
        return this.indexedShapeIndex;
    }

    public GeoShapeQueryBuilder indexedShapePath(String indexedShapePath) {
        this.indexedShapePath = indexedShapePath;
        return this;
    }

    public String indexedShapePath() {
        return this.indexedShapePath;
    }

    public GeoShapeQueryBuilder indexedShapeRouting(String indexedShapeRouting) {
        this.indexedShapeRouting = indexedShapeRouting;
        return this;
    }

    public String indexedShapeRouting() {
        return this.indexedShapeRouting;
    }

    public GeoShapeQueryBuilder relation(ShapeRelation relation) {
        if (relation == null) {
            throw new IllegalArgumentException("No Shape Relation defined");
        }
        if (SpatialStrategy.TERM.equals(this.strategy) && relation != ShapeRelation.INTERSECTS) {
            throw new IllegalArgumentException("current strategy [" + this.strategy.getStrategyName() + "] only supports relation [" + ShapeRelation.INTERSECTS.getRelationName() + "] found relation [" + relation.getRelationName() + "]");
        }
        this.relation = relation;
        return this;
    }

    public ShapeRelation relation() {
        return this.relation;
    }

    public GeoShapeQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) {
        ConstantScoreQuery query;
        if (this.shape == null || this.supplier != null) {
            throw new UnsupportedOperationException("query must be rewritten first");
        }
        ShapeBuilder shapeToQuery = this.shape;
        MappedFieldType fieldType = context.fieldMapper(this.fieldName);
        if (fieldType == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context, "failed to find geo_shape field [" + this.fieldName + "]", new Object[0]);
        }
        if (!fieldType.typeName().equals(NAME)) {
            throw new QueryShardException(context, "Field [" + this.fieldName + "] is not of type [geo_shape] but of type [" + fieldType.typeName() + "]", new Object[0]);
        }
        BaseGeoShapeFieldMapper.BaseGeoShapeFieldType ft = (BaseGeoShapeFieldMapper.BaseGeoShapeFieldType)fieldType;
        if (this.strategy != null || ft instanceof LegacyGeoShapeFieldMapper.GeoShapeFieldType) {
            PrefixTreeStrategy prefixTreeStrategy;
            LegacyGeoShapeFieldMapper.GeoShapeFieldType shapeFieldType = (LegacyGeoShapeFieldMapper.GeoShapeFieldType)ft;
            SpatialStrategy spatialStrategy = shapeFieldType.strategy();
            if (this.strategy != null) {
                spatialStrategy = this.strategy;
            }
            if ((prefixTreeStrategy = shapeFieldType.resolvePrefixTreeStrategy(spatialStrategy)) instanceof RecursivePrefixTreeStrategy && this.relation == ShapeRelation.DISJOINT) {
                BooleanQuery.Builder bool = new BooleanQuery.Builder();
                Query exists = ExistsQueryBuilder.newFilter(context, this.fieldName);
                Query intersects = prefixTreeStrategy.makeQuery(GeoShapeQueryBuilder.getArgs(shapeToQuery, ShapeRelation.INTERSECTS));
                bool.add(exists, BooleanClause.Occur.MUST);
                bool.add(intersects, BooleanClause.Occur.MUST_NOT);
                query = new ConstantScoreQuery((Query)bool.build());
            } else {
                query = new ConstantScoreQuery(prefixTreeStrategy.makeQuery(GeoShapeQueryBuilder.getArgs(shapeToQuery, this.relation)));
            }
        } else {
            query = new ConstantScoreQuery(this.getVectorQuery(context, shapeToQuery));
        }
        return query;
    }

    private Query getVectorQuery(QueryShardContext context, ShapeBuilder queryShapeBuilder) {
        if (this.relation == ShapeRelation.CONTAINS) {
            throw new QueryShardException(context, ShapeRelation.CONTAINS + " query relation not supported for Field [" + this.fieldName + "]", new Object[0]);
        }
        return this.getVectorQueryFromShape(context, (Geometry)queryShapeBuilder.buildGeometry());
    }

    private Query getVectorQueryFromShape(final QueryShardContext context, Geometry queryShape) {
        return (Query)queryShape.visit((GeometryVisitor)new GeometryVisitor<Query, RuntimeException>(){

            public Query visit(Circle circle) {
                throw new QueryShardException(context, "Field [" + GeoShapeQueryBuilder.this.fieldName + "] found and unknown shape Circle", new Object[0]);
            }

            public Query visit(GeometryCollection<?> collection) {
                BooleanQuery.Builder bqb = new BooleanQuery.Builder();
                this.visit(bqb, collection);
                return bqb.build();
            }

            private void visit(BooleanQuery.Builder bqb, GeometryCollection<?> collection) {
                for (Geometry shape : collection) {
                    if (shape instanceof MultiPoint) {
                        this.visit(bqb, (GeometryCollection)shape);
                        continue;
                    }
                    bqb.add((Query)shape.visit((GeometryVisitor)this), BooleanClause.Occur.SHOULD);
                }
            }

            public Query visit(Line line) {
                return LatLonShape.newLineQuery((String)GeoShapeQueryBuilder.this.fieldName(), (LatLonShape.QueryRelation)GeoShapeQueryBuilder.this.relation.getLuceneRelation(), (org.apache.lucene.geo.Line[])new org.apache.lucene.geo.Line[]{new org.apache.lucene.geo.Line(line.getLats(), line.getLons())});
            }

            public Query visit(LinearRing ring) {
                throw new QueryShardException(context, "Field [" + GeoShapeQueryBuilder.this.fieldName + "] found and unsupported shape LinearRing", new Object[0]);
            }

            public Query visit(MultiLine multiLine) {
                org.apache.lucene.geo.Line[] lines = new org.apache.lucene.geo.Line[multiLine.size()];
                for (int i = 0; i < multiLine.size(); ++i) {
                    lines[i] = new org.apache.lucene.geo.Line(((Line)multiLine.get(i)).getLats(), ((Line)multiLine.get(i)).getLons());
                }
                return LatLonShape.newLineQuery((String)GeoShapeQueryBuilder.this.fieldName(), (LatLonShape.QueryRelation)GeoShapeQueryBuilder.this.relation.getLuceneRelation(), (org.apache.lucene.geo.Line[])lines);
            }

            public Query visit(MultiPoint multiPoint) {
                throw new QueryShardException(context, "Field [" + GeoShapeQueryBuilder.this.fieldName + "] does not support " + (Object)((Object)GeoShapeType.MULTIPOINT) + " queries", new Object[0]);
            }

            public Query visit(MultiPolygon multiPolygon) {
                Polygon[] polygons = new Polygon[multiPolygon.size()];
                for (int i = 0; i < multiPolygon.size(); ++i) {
                    polygons[i] = GeoShapeFieldMapper.toLucenePolygon((org.elasticsearch.geo.geometry.Polygon)multiPolygon.get(i));
                }
                return LatLonShape.newPolygonQuery((String)GeoShapeQueryBuilder.this.fieldName(), (LatLonShape.QueryRelation)GeoShapeQueryBuilder.this.relation.getLuceneRelation(), (Polygon[])polygons);
            }

            public Query visit(Point point) {
                return LatLonShape.newBoxQuery((String)GeoShapeQueryBuilder.this.fieldName, (LatLonShape.QueryRelation)GeoShapeQueryBuilder.this.relation.getLuceneRelation(), (double)point.getLat(), (double)point.getLat(), (double)point.getLon(), (double)point.getLon());
            }

            public Query visit(org.elasticsearch.geo.geometry.Polygon polygon) {
                return LatLonShape.newPolygonQuery((String)GeoShapeQueryBuilder.this.fieldName(), (LatLonShape.QueryRelation)GeoShapeQueryBuilder.this.relation.getLuceneRelation(), (Polygon[])new Polygon[]{GeoShapeFieldMapper.toLucenePolygon(polygon)});
            }

            public Query visit(Rectangle r) {
                return LatLonShape.newBoxQuery((String)GeoShapeQueryBuilder.this.fieldName(), (LatLonShape.QueryRelation)GeoShapeQueryBuilder.this.relation.getLuceneRelation(), (double)r.getMinLat(), (double)r.getMaxLat(), (double)r.getMinLon(), (double)r.getMaxLon());
            }
        });
    }

    private void fetch(Client client, final GetRequest getRequest, final String path, final ActionListener<ShapeBuilder> listener) {
        getRequest.preference("_local");
        client.get(getRequest, new ActionListener<GetResponse>(){

            @Override
            public void onResponse(GetResponse response) {
                try {
                    if (!response.isExists()) {
                        throw new IllegalArgumentException("Shape with ID [" + getRequest.id() + "] in type [" + getRequest.type() + "] not found");
                    }
                    if (response.isSourceEmpty()) {
                        throw new IllegalArgumentException("Shape with ID [" + getRequest.id() + "] in type [" + getRequest.type() + "] source disabled");
                    }
                    String[] pathElements = path.split("\\.");
                    int currentPathSlot = 0;
                    try (XContentParser parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, response.getSourceAsBytesRef());){
                        XContentParser.Token currentToken;
                        while ((currentToken = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (currentToken != XContentParser.Token.FIELD_NAME) continue;
                            if (pathElements[currentPathSlot].equals(parser.currentName())) {
                                parser.nextToken();
                                if (++currentPathSlot != pathElements.length) continue;
                                listener.onResponse(ShapeParser.parse(parser));
                                return;
                            }
                            parser.nextToken();
                            parser.skipChildren();
                        }
                        throw new IllegalStateException("Shape with name [" + getRequest.id() + "] found but missing " + path + " field");
                    }
                }
                catch (Exception e) {
                    this.onFailure(e);
                    return;
                }
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    public static SpatialArgs getArgs(ShapeBuilder shape, ShapeRelation relation) {
        switch (relation) {
            case DISJOINT: {
                return new SpatialArgs(SpatialOperation.IsDisjointTo, shape.buildS4J());
            }
            case INTERSECTS: {
                return new SpatialArgs(SpatialOperation.Intersects, shape.buildS4J());
            }
            case WITHIN: {
                return new SpatialArgs(SpatialOperation.IsWithin, shape.buildS4J());
            }
            case CONTAINS: {
                return new SpatialArgs(SpatialOperation.Contains, shape.buildS4J());
            }
        }
        throw new IllegalArgumentException("invalid relation [" + relation + "]");
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        if (this.strategy != null) {
            builder.field(STRATEGY_FIELD.getPreferredName(), this.strategy.getStrategyName());
        }
        if (this.shape != null) {
            builder.field(SHAPE_FIELD.getPreferredName());
            this.shape.toXContent(builder, params);
        } else {
            builder.startObject(INDEXED_SHAPE_FIELD.getPreferredName()).field(SHAPE_ID_FIELD.getPreferredName(), this.indexedShapeId);
            if (this.indexedShapeType != null) {
                builder.field(SHAPE_TYPE_FIELD.getPreferredName(), this.indexedShapeType);
            }
            if (this.indexedShapeIndex != null) {
                builder.field(SHAPE_INDEX_FIELD.getPreferredName(), this.indexedShapeIndex);
            }
            if (this.indexedShapePath != null) {
                builder.field(SHAPE_PATH_FIELD.getPreferredName(), this.indexedShapePath);
            }
            if (this.indexedShapeRouting != null) {
                builder.field(SHAPE_ROUTING_FIELD.getPreferredName(), this.indexedShapeRouting);
            }
            builder.endObject();
        }
        if (this.relation != null) {
            builder.field(RELATION_FIELD.getPreferredName(), this.relation.getRelationName());
        }
        builder.endObject();
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static GeoShapeQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        ShapeRelation shapeRelation = null;
        SpatialStrategy strategy = null;
        ShapeBuilder shape = null;
        String id = null;
        String type = null;
        String index = null;
        String shapePath = null;
        String shapeRouting = null;
        String currentFieldName = null;
        float boost = 1.0f;
        String queryName = null;
        boolean ignoreUnmapped = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (fieldName != null) {
                    throw new ParsingException(parser.getTokenLocation(), "[geo_shape] point specified twice. [" + currentFieldName + "]", new Object[0]);
                }
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token != XContentParser.Token.FIELD_NAME) continue;
                    currentFieldName = parser.currentName();
                    token = parser.nextToken();
                    if (SHAPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        shape = ShapeParser.parse(parser);
                        continue;
                    }
                    if (STRATEGY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        String strategyName = parser.text();
                        strategy = SpatialStrategy.fromString(strategyName);
                        if (strategy != null) continue;
                        throw new ParsingException(parser.getTokenLocation(), "Unknown strategy [" + strategyName + " ]", new Object[0]);
                    }
                    if (RELATION_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        shapeRelation = ShapeRelation.getRelationByName(parser.text());
                        if (shapeRelation != null) continue;
                        throw new ParsingException(parser.getTokenLocation(), "Unknown shape operation [" + parser.text() + " ]", new Object[0]);
                    }
                    if (INDEXED_SHAPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token.isValue()) {
                                if (SHAPE_ID_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                    id = parser.text();
                                    continue;
                                }
                                if (SHAPE_TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                    type = parser.text();
                                    continue;
                                }
                                if (SHAPE_INDEX_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                    index = parser.text();
                                    continue;
                                }
                                if (SHAPE_PATH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                    shapePath = parser.text();
                                    continue;
                                }
                                if (!SHAPE_ROUTING_FIELD.match(currentFieldName, parser.getDeprecationHandler())) continue;
                                shapeRouting = parser.text();
                                continue;
                            }
                            throw new ParsingException(parser.getTokenLocation(), "[geo_shape] unknown token [" + token + "] after [" + currentFieldName + "]", new Object[0]);
                        }
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[geo_shape] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[geo_shape] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (type != null) {
            deprecationLogger.deprecatedAndMaybeLog("geo_share_query_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        GeoShapeQueryBuilder builder = shape != null ? new GeoShapeQueryBuilder(fieldName, shape) : new GeoShapeQueryBuilder(fieldName, id, type);
        if (index != null) {
            builder.indexedShapeIndex(index);
        }
        if (shapePath != null) {
            builder.indexedShapePath(shapePath);
        }
        if (shapeRouting != null) {
            builder.indexedShapeRouting(shapeRouting);
        }
        if (shapeRelation != null) {
            builder.relation(shapeRelation);
        }
        if (strategy != null) {
            builder.strategy(strategy);
        }
        if (queryName != null) {
            builder.queryName(queryName);
        }
        builder.boost(boost);
        builder.ignoreUnmapped(ignoreUnmapped);
        return builder;
    }

    @Override
    protected boolean doEquals(GeoShapeQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.indexedShapeId, other.indexedShapeId) && Objects.equals(this.indexedShapeIndex, other.indexedShapeIndex) && Objects.equals(this.indexedShapePath, other.indexedShapePath) && Objects.equals(this.indexedShapeType, other.indexedShapeType) && Objects.equals(this.indexedShapeRouting, other.indexedShapeRouting) && Objects.equals(this.relation, other.relation) && Objects.equals(this.shape, other.shape) && Objects.equals(this.supplier, other.supplier) && Objects.equals(this.strategy, other.strategy) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.indexedShapeId, this.indexedShapeIndex, this.indexedShapePath, this.indexedShapeType, this.indexedShapeRouting, this.relation, this.shape, this.strategy, this.ignoreUnmapped, this.supplier);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        if (this.supplier != null) {
            return this.supplier.get() == null ? this : new GeoShapeQueryBuilder(this.fieldName, this.supplier.get()).relation(this.relation).strategy(this.strategy);
        }
        if (this.shape == null) {
            SetOnce supplier = new SetOnce();
            queryRewriteContext.registerAsyncAction((client, listener) -> {
                GetRequest getRequest = this.indexedShapeType == null ? new GetRequest(this.indexedShapeIndex, this.indexedShapeId) : new GetRequest(this.indexedShapeIndex, this.indexedShapeType, this.indexedShapeId);
                getRequest.routing(this.indexedShapeRouting);
                this.fetch((Client)client, getRequest, this.indexedShapePath, ActionListener.wrap(builder -> {
                    supplier.set(builder);
                    listener.onResponse(null);
                }, listener::onFailure));
            });
            return new GeoShapeQueryBuilder(this.fieldName, () -> ((SetOnce)supplier).get(), this.indexedShapeId, this.indexedShapeType).relation(this.relation).strategy(this.strategy);
        }
        return this;
    }
}

