/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.path.PathHierarchyTokenizer;
import org.apache.lucene.analysis.path.ReversePathHierarchyTokenizer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;

public class PathHierarchyTokenizerFactory
extends AbstractTokenizerFactory {
    private final int bufferSize;
    private final char delimiter;
    private final char replacement;
    private final int skip;
    private final boolean reverse;

    PathHierarchyTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, settings);
        this.bufferSize = settings.getAsInt("buffer_size", Integer.valueOf(1024));
        String delimiter = settings.get("delimiter");
        if (delimiter == null) {
            this.delimiter = (char)47;
        } else {
            if (delimiter.length() != 1) {
                throw new IllegalArgumentException("delimiter must be a one char value");
            }
            this.delimiter = delimiter.charAt(0);
        }
        String replacement = settings.get("replacement");
        if (replacement == null) {
            this.replacement = this.delimiter;
        } else {
            if (replacement.length() != 1) {
                throw new IllegalArgumentException("replacement must be a one char value");
            }
            this.replacement = replacement.charAt(0);
        }
        this.skip = settings.getAsInt("skip", Integer.valueOf(0));
        this.reverse = settings.getAsBoolean("reverse", Boolean.valueOf(false));
    }

    public Tokenizer create() {
        if (this.reverse) {
            return new ReversePathHierarchyTokenizer(this.bufferSize, this.delimiter, this.replacement, this.skip);
        }
        return new PathHierarchyTokenizer(this.bufferSize, this.delimiter, this.replacement, this.skip);
    }
}

