/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.AbstractCompoundRule;

public abstract class AbstractCompoundRuleTest {
    protected JLanguageTool lt;
    protected AbstractCompoundRule rule;

    public void check(int expectedErrors, String text) throws IOException {
        this.check(expectedErrors, text, null);
    }

    public void check(int expectedErrors, String text, String[] expSuggestions) throws IOException {
        Assert.assertNotNull((String)"Please initialize langTool!", (Object)this.lt);
        Assert.assertNotNull((String)"Please initialize 'rule'!", (Object)this.rule);
        Object[] ruleMatches = this.rule.match(this.lt.getAnalyzedSentence(text));
        Assert.assertEquals((String)("Expected " + expectedErrors + " error(s), but got: " + Arrays.toString(ruleMatches)), (long)expectedErrors, (long)ruleMatches.length);
        if (expSuggestions != null && expectedErrors != 1) {
            throw new RuntimeException("Sorry, test case can only check suggestion if there's one rule match");
        }
        if (expSuggestions != null) {
            Object ruleMatch = ruleMatches[0];
            String errorMessage = String.format("Got these suggestions: %s, expected %s ", ruleMatch.getSuggestedReplacements(), Arrays.toString(expSuggestions));
            Assert.assertEquals((String)errorMessage, (long)expSuggestions.length, (long)ruleMatch.getSuggestedReplacements().size());
            int i = 0;
            for (Object element : ruleMatch.getSuggestedReplacements()) {
                String suggestion = (String)element;
                Assert.assertEquals((Object)expSuggestions[i], (Object)suggestion);
                ++i;
            }
        }
    }
}

