/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.Table;

public class BaseTable
implements Table {
    private final DirectoryEntry _de;
    private final int _version;
    private final int _horizAxisOffset;
    private final int _vertAxisOffset;
    private Axis _horizAxis;
    private Axis _vertAxis;
    private byte[] _buf;

    protected BaseTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._buf = new byte[directoryEntry.getLength()];
        dataInput.readFully(this._buf);
        DataInput dataInput2 = this.getDataInputForOffset(0);
        this._version = dataInput2.readInt();
        this._horizAxisOffset = dataInput2.readUnsignedShort();
        this._vertAxisOffset = dataInput2.readUnsignedShort();
        if (this._horizAxisOffset != 0) {
            this._horizAxis = new Axis(this._horizAxisOffset);
        }
        if (this._vertAxisOffset != 0) {
            this._vertAxis = new Axis(this._vertAxisOffset);
        }
        this._buf = null;
    }

    private DataInput getDataInputForOffset(int n) {
        return new DataInputStream(new ByteArrayInputStream(this._buf, n, this._de.getLength() - n));
    }

    protected static String tagAsString(int n) {
        char[] cArray = new char[]{(char)(n >> 24 & 0xFF), (char)(n >> 16 & 0xFF), (char)(n >> 8 & 0xFF), (char)(n & 0xFF)};
        return String.valueOf(cArray);
    }

    @Override
    public int getType() {
        return 1111577413;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("; 'BASE' Table - Baseline\n;-------------------------------------\n\n").append("BASEHeader BASEHeaderT").append(Integer.toHexString(0)).append("\n").append(Integer.toHexString(this._version)).append("\nAxisT").append(Integer.toHexString(this._horizAxisOffset)).append("\nAxisT").append(Integer.toHexString(this._vertAxisOffset));
        if (this._horizAxis != null) {
            stringBuilder.append("\n").append(this._horizAxis.toString());
        }
        if (this._vertAxis != null) {
            stringBuilder.append("\n").append(this._vertAxis.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }

    class Axis {
        private final int _thisOffset;
        private final int _baseTagListOffset;
        private final int _baseScriptListOffset;
        private BaseTagList _baseTagList;
        private BaseScriptList _baseScriptList;

        protected Axis(int n) throws IOException {
            this._thisOffset = n;
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n);
            this._baseTagListOffset = dataInput.readUnsignedShort();
            this._baseScriptListOffset = dataInput.readUnsignedShort();
            if (this._baseTagListOffset != 0) {
                this._baseTagList = new BaseTagList(n + this._baseTagListOffset);
            }
            if (this._baseScriptListOffset != 0) {
                this._baseScriptList = new BaseScriptList(n + this._baseScriptListOffset);
            }
        }

        public String toString() {
            return "\nAxis AxisT" + Integer.toHexString(this._thisOffset) + "\nBaseTagListT" + Integer.toHexString(this._thisOffset + this._baseTagListOffset) + "\nBaseScriptListT" + Integer.toHexString(this._thisOffset + this._baseScriptListOffset) + "\n" + this._baseTagList + "\n" + this._baseScriptList;
        }
    }

    abstract class BaseCoord {
        BaseCoord() {
        }

        abstract int getBaseCoordFormat();

        abstract short getCoordinate();
    }

    class BaseCoordFormat1
    extends BaseCoord {
        private final short _coordinate;

        protected BaseCoordFormat1(DataInput dataInput) throws IOException {
            this._coordinate = dataInput.readShort();
        }

        @Override
        int getBaseCoordFormat() {
            return 1;
        }

        @Override
        short getCoordinate() {
            return this._coordinate;
        }
    }

    class BaseCoordFormat2
    extends BaseCoord {
        private final short _coordinate;

        protected BaseCoordFormat2(DataInput dataInput) throws IOException {
            this._coordinate = dataInput.readShort();
            dataInput.readUnsignedShort();
            dataInput.readUnsignedShort();
        }

        @Override
        int getBaseCoordFormat() {
            return 2;
        }

        @Override
        short getCoordinate() {
            return this._coordinate;
        }
    }

    class BaseCoordFormat3
    extends BaseCoord {
        private final short _coordinate;

        protected BaseCoordFormat3(DataInput dataInput) throws IOException {
            this._coordinate = dataInput.readShort();
            dataInput.readUnsignedShort();
        }

        @Override
        int getBaseCoordFormat() {
            return 2;
        }

        @Override
        short getCoordinate() {
            return this._coordinate;
        }
    }

    static class BaseLangSysRecord {
        private final int _minMaxOffset;

        protected BaseLangSysRecord(DataInput dataInput) throws IOException {
            dataInput.readInt();
            this._minMaxOffset = dataInput.readUnsignedShort();
        }

        int getMinMaxOffset() {
            return this._minMaxOffset;
        }
    }

    class BaseScript {
        private final int _thisOffset;
        private final int _baseValuesOffset;
        private final int _defaultMinMaxOffset;
        private final int _baseLangSysCount;
        private final BaseLangSysRecord[] _baseLangSysRecord;
        private BaseValues _baseValues;
        private MinMax[] _minMax;

        protected BaseScript(int n) throws IOException {
            int n2;
            this._thisOffset = n;
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n);
            this._baseValuesOffset = dataInput.readUnsignedShort();
            this._defaultMinMaxOffset = dataInput.readUnsignedShort();
            this._baseLangSysCount = dataInput.readUnsignedShort();
            this._baseLangSysRecord = new BaseLangSysRecord[this._baseLangSysCount];
            for (n2 = 0; n2 < this._baseLangSysCount; ++n2) {
                this._baseLangSysRecord[n2] = new BaseLangSysRecord(dataInput);
            }
            if (this._baseValuesOffset > 0) {
                this._baseValues = new BaseValues(n + this._baseValuesOffset);
            }
            for (n2 = 0; n2 < this._baseLangSysCount; ++n2) {
                this._minMax[n2] = new MinMax(n + this._baseLangSysRecord[n2].getMinMaxOffset());
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("\nBaseScript BaseScriptT").append(Integer.toHexString(this._thisOffset)).append("\nBaseValuesT").append(Integer.toHexString(this._thisOffset + this._baseValuesOffset)).append("\nMinMaxT").append(Integer.toHexString(this._thisOffset + this._defaultMinMaxOffset)).append("\n").append(Integer.toHexString(this._baseLangSysCount));
            if (this._baseValues != null) {
                stringBuilder.append("\n").append(this._baseValues.toString());
            }
            return stringBuilder.toString();
        }
    }

    class BaseScriptList {
        private final int _thisOffset;
        private final int _baseScriptCount;
        private final BaseScriptRecord[] _baseScriptRecord;
        private final BaseScript[] _baseScripts;

        protected BaseScriptList(int n) throws IOException {
            int n2;
            this._thisOffset = n;
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n);
            this._baseScriptCount = dataInput.readUnsignedShort();
            this._baseScriptRecord = new BaseScriptRecord[this._baseScriptCount];
            for (n2 = 0; n2 < this._baseScriptCount; ++n2) {
                this._baseScriptRecord[n2] = new BaseScriptRecord(dataInput);
            }
            this._baseScripts = new BaseScript[this._baseScriptCount];
            for (n2 = 0; n2 < this._baseScriptCount; ++n2) {
                this._baseScripts[n2] = new BaseScript(n + this._baseScriptRecord[n2].getBaseScriptOffset());
            }
        }

        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder().append("\nBaseScriptList BaseScriptListT").append(Integer.toHexString(this._thisOffset)).append("\n").append(Integer.toHexString(this._baseScriptCount));
            for (n = 0; n < this._baseScriptCount; ++n) {
                stringBuilder.append("\n                          ; BaseScriptRecord[").append(n);
                stringBuilder.append("]\n'").append(BaseTable.tagAsString(this._baseScriptRecord[n].getBaseScriptTag())).append("'");
                stringBuilder.append("\nBaseScriptT").append(Integer.toHexString(this._thisOffset + this._baseScriptRecord[n].getBaseScriptOffset()));
            }
            for (n = 0; n < this._baseScriptCount; ++n) {
                stringBuilder.append("\n").append(this._baseScripts[n].toString());
            }
            return stringBuilder.toString();
        }
    }

    static class BaseScriptRecord {
        private final int _baseScriptTag;
        private final int _baseScriptOffset;

        protected BaseScriptRecord(DataInput dataInput) throws IOException {
            this._baseScriptTag = dataInput.readInt();
            this._baseScriptOffset = dataInput.readUnsignedShort();
        }

        int getBaseScriptTag() {
            return this._baseScriptTag;
        }

        int getBaseScriptOffset() {
            return this._baseScriptOffset;
        }
    }

    class BaseTagList {
        private final int _thisOffset;
        private final int _baseTagCount;
        private final int[] _baselineTag;

        protected BaseTagList(int n) throws IOException {
            this._thisOffset = n;
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n);
            this._baseTagCount = dataInput.readUnsignedShort();
            this._baselineTag = new int[this._baseTagCount];
            for (int i = 0; i < this._baseTagCount; ++i) {
                this._baselineTag[i] = dataInput.readInt();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("\nBaseTagList BaseTagListT").append(Integer.toHexString(this._thisOffset)).append("\n").append(Integer.toHexString(this._baseTagCount));
            for (int i = 0; i < this._baseTagCount; ++i) {
                stringBuilder.append("\n'").append(BaseTable.tagAsString(this._baselineTag[i])).append("'");
            }
            return stringBuilder.toString();
        }
    }

    class BaseValues {
        private final int _baseCoordCount;
        private final int[] _baseCoordOffset;
        private final BaseCoord[] _baseCoords;

        protected BaseValues(int n) throws IOException {
            int n2;
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n);
            dataInput.readUnsignedShort();
            this._baseCoordCount = dataInput.readUnsignedShort();
            this._baseCoordOffset = new int[this._baseCoordCount];
            for (n2 = 0; n2 < this._baseCoordCount; ++n2) {
                this._baseCoordOffset[n2] = dataInput.readUnsignedShort();
            }
            this._baseCoords = new BaseCoord[this._baseCoordCount];
            block6: for (n2 = 0; n2 < this._baseCoordCount; ++n2) {
                int n3 = dataInput.readUnsignedShort();
                switch (n3) {
                    case 1: {
                        this._baseCoords[n2] = new BaseCoordFormat1(dataInput);
                        continue block6;
                    }
                    case 2: {
                        this._baseCoords[n2] = new BaseCoordFormat2(dataInput);
                        continue block6;
                    }
                    case 3: {
                        this._baseCoords[n2] = new BaseCoordFormat3(dataInput);
                    }
                }
            }
        }
    }

    static class FeatMinMaxRecord {
        protected FeatMinMaxRecord(DataInput dataInput) throws IOException {
            dataInput.readInt();
            dataInput.readUnsignedShort();
            dataInput.readUnsignedShort();
        }
    }

    class MinMax {
        private final int _featMinMaxCount;
        private final FeatMinMaxRecord[] _featMinMaxRecord;

        protected MinMax(int n) throws IOException {
            DataInput dataInput = BaseTable.this.getDataInputForOffset(n);
            dataInput.readUnsignedShort();
            dataInput.readUnsignedShort();
            this._featMinMaxCount = dataInput.readUnsignedShort();
            this._featMinMaxRecord = new FeatMinMaxRecord[this._featMinMaxCount];
            for (int i = 0; i < this._featMinMaxCount; ++i) {
                this._featMinMaxRecord[i] = new FeatMinMaxRecord(dataInput);
            }
        }
    }
}

