/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.controlpanel.CachePane;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.ScreenFinder;
import net.sourceforge.jnlp.util.logging.JavaConsole;
import net.sourceforge.jnlp.util.logging.OutputController;

public class BasicExceptionDialog {
    private static final AtomicInteger dialogInstancess = new AtomicInteger();

    public static void show(Exception exception) {
        String detailsText = OutputController.exceptionToString(exception);
        final JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JOptionPane optionPane = new JOptionPane(mainPanel, 0);
        final JDialog errorDialog = optionPane.createDialog(Translator.R("Error"));
        errorDialog.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        JPanel quickInfoPanelAll = new JPanel();
        JPanel quickInfoPanelMessage = new JPanel();
        JPanel quickInfoPanelButtons = new JPanel();
        BoxLayout layoutAll = new BoxLayout(quickInfoPanelAll, 1);
        BoxLayout layoutMessage = new BoxLayout(quickInfoPanelMessage, 0);
        BoxLayout layoutButtons = new BoxLayout(quickInfoPanelButtons, 0);
        quickInfoPanelAll.setLayout(layoutAll);
        quickInfoPanelMessage.setLayout(layoutMessage);
        quickInfoPanelButtons.setLayout(layoutButtons);
        mainPanel.add((Component)quickInfoPanelAll, "First");
        quickInfoPanelAll.add(quickInfoPanelMessage);
        quickInfoPanelAll.add(quickInfoPanelButtons);
        JLabel errorLabel = new JLabel(exception.getMessage());
        errorLabel.setAlignmentY(0.0f);
        quickInfoPanelMessage.add(errorLabel);
        final JButton viewDetails = new JButton(Translator.R("ButShowDetails"));
        viewDetails.setAlignmentY(0.0f);
        viewDetails.setActionCommand("show");
        quickInfoPanelButtons.add(viewDetails);
        JButton cacheButton = BasicExceptionDialog.getClearCacheButton(errorDialog);
        cacheButton.setAlignmentY(0.0f);
        quickInfoPanelButtons.add(cacheButton);
        JButton consoleButton = BasicExceptionDialog.getShowButton(errorDialog);
        consoleButton.setAlignmentY(0.0f);
        quickInfoPanelButtons.add(consoleButton);
        JPanel fillRest = new JPanel();
        fillRest.setAlignmentY(0.0f);
        quickInfoPanelButtons.add(fillRest);
        JTextArea textArea = new JTextArea();
        textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        textArea.setEditable(false);
        textArea.setText(detailsText);
        final JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(100, 200));
        viewDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (viewDetails.getActionCommand().equals("show")) {
                    mainPanel.add((Component)scrollPane, "Center");
                    viewDetails.setActionCommand("hide");
                    viewDetails.setText(Translator.R("ButHideDetails"));
                    errorDialog.pack();
                } else {
                    mainPanel.remove(scrollPane);
                    viewDetails.setActionCommand("show");
                    viewDetails.setText(Translator.R("ButShowDetails"));
                    errorDialog.pack();
                }
            }
        });
        errorDialog.pack();
        errorDialog.setResizable(true);
        ScreenFinder.centerWindowsToCurrentScreen(errorDialog);
        errorDialog.setVisible(true);
        errorDialog.dispose();
        BasicExceptionDialog.willBeHidden();
    }

    public static JButton getShowButton(final Component parent) {
        JButton consoleButton = new JButton();
        consoleButton.setText(Translator.R("DPJavaConsole"));
        consoleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    JavaConsole.getConsole().showConsoleLater(true);
                }
                catch (Exception ex) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
                    JOptionPane.showConfirmDialog(parent, ex);
                }
            }
        });
        if (!JavaConsole.isEnabled()) {
            consoleButton.setEnabled(false);
            consoleButton.setToolTipText(Translator.R("DPJavaConsoleDisabledHint"));
        }
        return consoleButton;
    }

    public static JButton getClearCacheButton(final Component parent) {
        JButton clearAllButton = new JButton();
        clearAllButton.setText(Translator.R("CVCPCleanCache"));
        clearAllButton.setToolTipText(Translator.R("CVCPCleanCacheTip"));
        clearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CachePane.visualCleanCache(parent);
                        }
                        catch (Exception ex) {
                            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, ex);
                        }
                    }
                });
            }
        });
        return clearAllButton;
    }

    private static synchronized int willBeHidden() {
        return dialogInstancess.decrementAndGet();
    }

    public static synchronized int willBeShown() {
        return dialogInstancess.incrementAndGet();
    }

    public static synchronized boolean areShown() {
        return dialogInstancess.intValue() > 0;
    }
}

