/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.AttributeValueExp;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class MatchQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -7156603696948215014L;
    private AttributeValueExp exp;
    private String pattern;

    public MatchQueryExp() {
    }

    public MatchQueryExp(AttributeValueExp a, StringValueExp s) {
        this.exp = a;
        this.pattern = s.getValue();
    }

    public AttributeValueExp getAttribute() {
        return this.exp;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp val = this.exp.apply(name);
        if (!(val instanceof StringValueExp)) {
            return false;
        }
        return MatchQueryExp.wildmatch(((StringValueExp)val).getValue(), this.pattern);
    }

    public String toString() {
        return this.exp + " like " + new StringValueExp(this.pattern);
    }

    private static boolean wildmatch(String s, String p) {
        int si = 0;
        int pi = 0;
        int slen = s.length();
        int plen = p.length();
        while (pi < plen) {
            char c;
            if ((c = p.charAt(pi++)) == '?') {
                if (++si <= slen) continue;
                return false;
            }
            if (c == '[') {
                if (si >= slen) {
                    return false;
                }
                boolean wantit = true;
                boolean seenit = false;
                if (p.charAt(pi) == '!') {
                    wantit = false;
                    ++pi;
                }
                while ((c = p.charAt(pi)) != ']' && ++pi < plen) {
                    if (p.charAt(pi) == '-' && pi + 1 < plen && p.charAt(pi + 1) != ']') {
                        if (s.charAt(si) >= p.charAt(pi - 1) && s.charAt(si) <= p.charAt(pi + 1)) {
                            seenit = true;
                        }
                        ++pi;
                        continue;
                    }
                    if (c != s.charAt(si)) continue;
                    seenit = true;
                }
                if (pi >= plen || wantit != seenit) {
                    return false;
                }
                ++pi;
                ++si;
                continue;
            }
            if (c == '*') {
                if (pi >= plen) {
                    return true;
                }
                do {
                    if (!MatchQueryExp.wildmatch(s.substring(si), p.substring(pi))) continue;
                    return true;
                } while (++si < slen);
                return false;
            }
            if (!(c == '\\' ? pi >= plen || si >= slen || p.charAt(pi++) != s.charAt(si++) : si >= slen || c != s.charAt(si++))) continue;
            return false;
        }
        return si == slen;
    }
}

