/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import sun.font.AttributeMap;
import sun.font.AttributeValues;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.FontRunIterator;
import sun.font.FontStrikeDesc;
import sun.font.FontUtilities;
import sun.font.NativeFont;
import sun.font.PhysicalFont;
import sun.font.ScriptRun;
import sun.font.StandardGlyphVector;
import sun.font.SunLayoutEngine;
import sun.font.TextRecord;

public final class GlyphLayout {
    private GVData _gvdata = new GVData();
    private static volatile GlyphLayout cache;
    private LayoutEngineFactory _lef;
    private TextRecord _textRecord = new TextRecord();
    private ScriptRun _scriptRuns = new ScriptRun();
    private FontRunIterator _fontRuns = new FontRunIterator();
    private int _ercount;
    private ArrayList _erecords = new ArrayList(10);
    private Point2D.Float _pt = new Point2D.Float();
    private FontStrikeDesc _sd = new FontStrikeDesc();
    private float[] _mat = new float[4];
    private int _typo_flags;
    private int _offset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlyphLayout get(LayoutEngineFactory lef) {
        if (lef == null) {
            lef = SunLayoutEngine.instance();
        }
        GlyphLayout result = null;
        Class<GlyphLayout> clazz = GlyphLayout.class;
        synchronized (GlyphLayout.class) {
            if (cache != null) {
                result = cache;
                cache = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (result == null) {
                result = new GlyphLayout();
            }
            result._lef = lef;
            return result;
        }
    }

    public static void done(GlyphLayout gl) {
        gl._lef = null;
        cache = gl;
    }

    public StandardGlyphVector layout(Font font, FontRenderContext frc, char[] text, int offset, int count, int flags, StandardGlyphVector result) {
        StandardGlyphVector gv;
        int script;
        int limit;
        if (text == null || offset < 0 || count < 0 || count > text.length - offset) {
            throw new IllegalArgumentException();
        }
        this.init(count);
        if (font.hasLayoutAttributes()) {
            AttributeValues values = ((AttributeMap)font.getAttributes()).getValues();
            if (values.getKerning() != 0) {
                this._typo_flags |= 1;
            }
            if (values.getLigatures() != 0) {
                this._typo_flags |= 2;
            }
        }
        this._offset = offset;
        SDCache txinfo = SDCache.get(font, frc);
        this._mat[0] = (float)txinfo.gtx.getScaleX();
        this._mat[1] = (float)txinfo.gtx.getShearY();
        this._mat[2] = (float)txinfo.gtx.getShearX();
        this._mat[3] = (float)txinfo.gtx.getScaleY();
        this._pt.setLocation(txinfo.delta);
        int lim = offset + count;
        int min = 0;
        int max = text.length;
        if (flags != 0) {
            if ((flags & 1) != 0) {
                this._typo_flags |= Integer.MIN_VALUE;
            }
            if ((flags & 2) != 0) {
                min = offset;
            }
            if ((flags & 4) != 0) {
                max = lim;
            }
        }
        int lang = -1;
        Font2D font2D = FontUtilities.getFont2D(font);
        this._textRecord.init(text, offset, lim, min, max);
        int start = offset;
        if (font2D instanceof CompositeFont) {
            this._scriptRuns.init(text, offset, count);
            this._fontRuns.init((CompositeFont)font2D, text, offset, lim);
            while (this._scriptRuns.next()) {
                limit = this._scriptRuns.getScriptLimit();
                script = this._scriptRuns.getScriptCode();
                while (this._fontRuns.next(script, limit)) {
                    PhysicalFont pfont = this._fontRuns.getFont();
                    if (pfont instanceof NativeFont) {
                        pfont = ((NativeFont)pfont).getDelegateFont();
                    }
                    int gmask = this._fontRuns.getGlyphMask();
                    int pos = this._fontRuns.getPos();
                    this.nextEngineRecord(start, pos, script, lang, pfont, gmask);
                    start = pos;
                }
            }
        } else {
            this._scriptRuns.init(text, offset, count);
            while (this._scriptRuns.next()) {
                limit = this._scriptRuns.getScriptLimit();
                script = this._scriptRuns.getScriptCode();
                this.nextEngineRecord(start, limit, script, lang, font2D, 0);
                start = limit;
            }
        }
        int ix = 0;
        int stop = this._ercount;
        int dir = 1;
        if (this._typo_flags < 0) {
            ix = stop - 1;
            stop = -1;
            dir = -1;
        }
        this._sd = txinfo.sd;
        while (ix != stop) {
            EngineRecord er = (EngineRecord)this._erecords.get(ix);
            while (true) {
                try {
                    er.layout();
                }
                catch (IndexOutOfBoundsException e) {
                    if (this._gvdata._count < 0) continue;
                    this._gvdata.grow();
                    continue;
                }
                break;
            }
            if (this._gvdata._count < 0) break;
            ix += dir;
        }
        if (this._gvdata._count < 0) {
            gv = new StandardGlyphVector(font, text, offset, count, frc);
            if (FontUtilities.debugFonts()) {
                FontUtilities.getLogger().warning("OpenType layout failed on font: " + font);
            }
        } else {
            gv = this._gvdata.createGlyphVector(font, frc, result);
        }
        return gv;
    }

    private GlyphLayout() {
    }

    private void init(int capacity) {
        this._typo_flags = 0;
        this._ercount = 0;
        this._gvdata.init(capacity);
    }

    private void nextEngineRecord(int start, int limit, int script, int lang, Font2D font, int gmask) {
        EngineRecord er = null;
        if (this._ercount == this._erecords.size()) {
            er = new EngineRecord();
            this._erecords.add(er);
        } else {
            er = (EngineRecord)this._erecords.get(this._ercount);
        }
        er.init(start, limit, font, script, lang, gmask);
        ++this._ercount;
    }

    private final class EngineRecord {
        private int start;
        private int limit;
        private int gmask;
        private int eflags;
        private LayoutEngineKey key = new LayoutEngineKey();
        private LayoutEngine engine;

        EngineRecord() {
        }

        void init(int start, int limit, Font2D font, int script, int lang, int gmask) {
            this.start = start;
            this.limit = limit;
            this.gmask = gmask;
            this.key.init(font, script, lang);
            this.eflags = 0;
            for (int i = start; i < limit; ++i) {
                int gc;
                int ch = ((GlyphLayout)GlyphLayout.this)._textRecord.text[i];
                if (Character.isHighSurrogate((char)ch) && i < limit - 1 && Character.isLowSurrogate(((GlyphLayout)GlyphLayout.this)._textRecord.text[i + 1])) {
                    ch = Character.toCodePoint((char)ch, ((GlyphLayout)GlyphLayout.this)._textRecord.text[++i]);
                }
                if ((gc = Character.getType(ch)) != 6 && gc != 7 && gc != 8) continue;
                this.eflags = 4;
                break;
            }
            this.engine = GlyphLayout.this._lef.getEngine(this.key);
        }

        void layout() {
            ((GlyphLayout)GlyphLayout.this)._textRecord.start = this.start;
            ((GlyphLayout)GlyphLayout.this)._textRecord.limit = this.limit;
            this.engine.layout(GlyphLayout.this._sd, GlyphLayout.this._mat, this.gmask, this.start - GlyphLayout.this._offset, GlyphLayout.this._textRecord, GlyphLayout.this._typo_flags | this.eflags, GlyphLayout.this._pt, GlyphLayout.this._gvdata);
        }
    }

    public static final class GVData {
        public int _count;
        public int _flags;
        public int[] _glyphs;
        public float[] _positions;
        public int[] _indices;
        private static final int UNINITIALIZED_FLAGS = -1;

        public void init(int size) {
            this._count = 0;
            this._flags = -1;
            if (this._glyphs == null || this._glyphs.length < size) {
                if (size < 20) {
                    size = 20;
                }
                this._glyphs = new int[size];
                this._positions = new float[size * 2 + 2];
                this._indices = new int[size];
            }
        }

        public void grow() {
            this.grow(this._glyphs.length / 4);
        }

        public void grow(int delta) {
            int size = this._glyphs.length + delta;
            int[] nglyphs = new int[size];
            System.arraycopy(this._glyphs, 0, nglyphs, 0, this._count);
            this._glyphs = nglyphs;
            float[] npositions = new float[size * 2 + 2];
            System.arraycopy(this._positions, 0, npositions, 0, this._count * 2 + 2);
            this._positions = npositions;
            int[] nindices = new int[size];
            System.arraycopy(this._indices, 0, nindices, 0, this._count);
            this._indices = nindices;
        }

        public void adjustPositions(AffineTransform invdtx) {
            invdtx.transform(this._positions, 0, this._positions, 0, this._count);
        }

        public StandardGlyphVector createGlyphVector(Font font, FontRenderContext frc, StandardGlyphVector result) {
            if (this._flags == -1) {
                this._flags = 0;
                if (this._count > 1) {
                    boolean ltr = true;
                    boolean rtl = true;
                    int rtlix = this._count;
                    for (int i = 0; i < this._count && (ltr || rtl); ++i) {
                        int cx = this._indices[i];
                        ltr = ltr && cx == i;
                        rtl = rtl && cx == --rtlix;
                    }
                    if (rtl) {
                        this._flags |= 4;
                    }
                    if (!rtl && !ltr) {
                        this._flags |= 8;
                    }
                }
                this._flags |= 2;
            }
            int[] glyphs = new int[this._count];
            System.arraycopy(this._glyphs, 0, glyphs, 0, this._count);
            float[] positions = null;
            if ((this._flags & 2) != 0) {
                positions = new float[this._count * 2 + 2];
                System.arraycopy(this._positions, 0, positions, 0, positions.length);
            }
            int[] indices = null;
            if ((this._flags & 8) != 0) {
                indices = new int[this._count];
                System.arraycopy(this._indices, 0, indices, 0, this._count);
            }
            if (result == null) {
                result = new StandardGlyphVector(font, frc, glyphs, positions, indices, this._flags);
            } else {
                result.initGlyphVector(font, frc, glyphs, positions, indices, this._flags);
            }
            return result;
        }
    }

    private static final class SDCache {
        public Font key_font;
        public FontRenderContext key_frc;
        public AffineTransform dtx;
        public AffineTransform invdtx;
        public AffineTransform gtx;
        public Point2D.Float delta;
        public FontStrikeDesc sd;
        private static final Point2D.Float ZERO_DELTA = new Point2D.Float();
        private static SoftReference<ConcurrentHashMap<SDKey, SDCache>> cacheRef;

        private SDCache(Font font, FontRenderContext frc) {
            this.key_font = font;
            this.key_frc = frc;
            this.dtx = frc.getTransform();
            this.dtx.setTransform(this.dtx.getScaleX(), this.dtx.getShearY(), this.dtx.getShearX(), this.dtx.getScaleY(), 0.0, 0.0);
            if (!this.dtx.isIdentity()) {
                try {
                    this.invdtx = this.dtx.createInverse();
                }
                catch (NoninvertibleTransformException e) {
                    throw new InternalError();
                }
            }
            float ptSize = font.getSize2D();
            if (font.isTransformed()) {
                this.gtx = font.getTransform();
                this.gtx.scale(ptSize, ptSize);
                this.delta = new Point2D.Float((float)this.gtx.getTranslateX(), (float)this.gtx.getTranslateY());
                this.gtx.setTransform(this.gtx.getScaleX(), this.gtx.getShearY(), this.gtx.getShearX(), this.gtx.getScaleY(), 0.0, 0.0);
                this.gtx.preConcatenate(this.dtx);
            } else {
                this.delta = ZERO_DELTA;
                this.gtx = new AffineTransform(this.dtx);
                this.gtx.scale(ptSize, ptSize);
            }
            int aa = FontStrikeDesc.getAAHintIntVal(frc.getAntiAliasingHint(), FontUtilities.getFont2D(font), (int)Math.abs(ptSize));
            int fm = FontStrikeDesc.getFMHintIntVal(frc.getFractionalMetricsHint());
            this.sd = new FontStrikeDesc(this.dtx, this.gtx, font.getStyle(), aa, fm);
        }

        public static SDCache get(Font font, FontRenderContext frc) {
            AffineTransform transform;
            if (frc.isTransformed() && ((transform = frc.getTransform()).getTranslateX() != 0.0 || transform.getTranslateY() != 0.0)) {
                transform = new AffineTransform(transform.getScaleX(), transform.getShearY(), transform.getShearX(), transform.getScaleY(), 0.0, 0.0);
                frc = new FontRenderContext(transform, frc.getAntiAliasingHint(), frc.getFractionalMetricsHint());
            }
            SDKey key = new SDKey(font, frc);
            ConcurrentHashMap<SDKey, SDCache> cache = null;
            SDCache res = null;
            if (cacheRef != null && (cache = cacheRef.get()) != null) {
                res = cache.get(key);
            }
            if (res == null) {
                res = new SDCache(font, frc);
                if (cache == null) {
                    cache = new ConcurrentHashMap(10);
                    cacheRef = new SoftReference<ConcurrentHashMap<SDKey, SDCache>>(cache);
                } else if (cache.size() >= 512) {
                    cache.clear();
                }
                cache.put(key, res);
            }
            return res;
        }

        private static final class SDKey {
            private final Font font;
            private final FontRenderContext frc;
            private final int hash;

            SDKey(Font font, FontRenderContext frc) {
                this.font = font;
                this.frc = frc;
                this.hash = font.hashCode() ^ frc.hashCode();
            }

            public int hashCode() {
                return this.hash;
            }

            public boolean equals(Object o) {
                try {
                    SDKey rhs = (SDKey)o;
                    return this.hash == rhs.hash && this.font.equals(rhs.font) && this.frc.equals(rhs.frc);
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
            }
        }
    }

    public static interface LayoutEngine {
        public void layout(FontStrikeDesc var1, float[] var2, int var3, int var4, TextRecord var5, int var6, Point2D.Float var7, GVData var8);
    }

    public static interface LayoutEngineFactory {
        public LayoutEngine getEngine(Font2D var1, int var2, int var3);

        public LayoutEngine getEngine(LayoutEngineKey var1);
    }

    public static final class LayoutEngineKey {
        private Font2D font;
        private int script;
        private int lang;

        LayoutEngineKey() {
        }

        LayoutEngineKey(Font2D font, int script, int lang) {
            this.init(font, script, lang);
        }

        void init(Font2D font, int script, int lang) {
            this.font = font;
            this.script = script;
            this.lang = lang;
        }

        LayoutEngineKey copy() {
            return new LayoutEngineKey(this.font, this.script, this.lang);
        }

        Font2D font() {
            return this.font;
        }

        int script() {
            return this.script;
        }

        int lang() {
            return this.lang;
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            if (rhs == null) {
                return false;
            }
            try {
                LayoutEngineKey that = (LayoutEngineKey)rhs;
                return this.script == that.script && this.lang == that.lang && this.font.equals(that.font);
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            return this.script ^ this.lang ^ this.font.hashCode();
        }
    }
}

