/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.pkcs11.P11DHKeyFactory;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.util.KeyUtil;

final class P11KeyAgreement
extends KeyAgreementSpi {
    private final Token token;
    private final String algorithm;
    private final long mechanism;
    private P11Key privateKey;
    private BigInteger publicValue;
    private int secretLen;
    private KeyAgreement multiPartyAgreement;

    P11KeyAgreement(Token token, String algorithm, long mechanism) {
        this.token = token;
        this.algorithm = algorithm;
        this.mechanism = mechanism;
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Key must be instance of PrivateKey");
        }
        this.privateKey = P11KeyFactory.convertKey(this.token, key, this.algorithm);
        this.publicValue = null;
        this.multiPartyAgreement = null;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.engineInit(key, random);
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        BigInteger g;
        BigInteger p;
        DHParameterSpec params;
        BigInteger y;
        Key dhKey;
        if (this.privateKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.publicValue != null) {
            throw new IllegalStateException("Phase already executed");
        }
        if (this.multiPartyAgreement != null || !lastPhase) {
            if (this.multiPartyAgreement == null) {
                try {
                    this.multiPartyAgreement = KeyAgreement.getInstance("DH", P11Util.getSunJceProvider());
                    this.multiPartyAgreement.init(this.privateKey);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new InvalidKeyException("Could not initialize multi party agreement", e);
                }
            }
            return this.multiPartyAgreement.doPhase(key, lastPhase);
        }
        if (!(key instanceof PublicKey) || !key.getAlgorithm().equals(this.algorithm)) {
            throw new InvalidKeyException("Key must be a PublicKey with algorithm DH");
        }
        if (key instanceof DHPublicKey) {
            dhKey = (DHPublicKey)key;
            KeyUtil.validate(dhKey);
            y = dhKey.getY();
            params = dhKey.getParams();
            p = params.getP();
            g = params.getG();
        } else {
            P11DHKeyFactory kf = new P11DHKeyFactory(this.token, "DH");
            try {
                DHPublicKeySpec spec = kf.engineGetKeySpec(key, DHPublicKeySpec.class);
                KeyUtil.validate(spec);
                y = spec.getY();
                p = spec.getP();
                g = spec.getG();
            }
            catch (InvalidKeySpecException e) {
                throw new InvalidKeyException("Could not obtain key values", e);
            }
        }
        if (!(!(this.privateKey instanceof DHPrivateKey) || p.equals((params = (dhKey = (DHPrivateKey)((Object)this.privateKey)).getParams()).getP()) && g.equals(params.getG()))) {
            throw new InvalidKeyException("PublicKey DH parameters must match PrivateKey DH parameters");
        }
        this.publicValue = y;
        this.secretLen = p.bitLength() + 7 >> 3;
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.multiPartyAgreement != null) {
            byte[] val = this.multiPartyAgreement.generateSecret();
            this.multiPartyAgreement = null;
            return val;
        }
        if (this.privateKey == null || this.publicValue == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        Session session = null;
        try {
            session = this.token.getOpSession();
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(256L, 16L)};
            attributes = this.token.getAttributes("generate", 4L, 16L, attributes);
            long keyID = this.token.p11.C_DeriveKey(session.id(), new CK_MECHANISM(this.mechanism, this.publicValue), this.privateKey.keyID, attributes);
            attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
            this.token.p11.C_GetAttributeValue(session.id(), keyID, attributes);
            byte[] secret = attributes[0].getByteArray();
            this.token.p11.C_DestroyObject(session.id(), keyID);
            if (secret.length == this.secretLen) {
                byte[] byArray = secret;
                return byArray;
            }
            if (secret.length > this.secretLen) {
                throw new ProviderException("generated secret is out-of-range");
            }
            byte[] newSecret = new byte[this.secretLen];
            System.arraycopy(secret, 0, newSecret, this.secretLen - secret.length, secret.length);
            byte[] byArray = newSecret;
            return byArray;
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("Could not derive key", e);
        }
        finally {
            this.publicValue = null;
            this.token.releaseSession(session);
        }
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (this.multiPartyAgreement != null) {
            int n = this.multiPartyAgreement.generateSecret(sharedSecret, offset);
            this.multiPartyAgreement = null;
            return n;
        }
        if (offset + this.secretLen > sharedSecret.length) {
            throw new ShortBufferException("Need " + this.secretLen + " bytes, only " + (sharedSecret.length - offset) + " available");
        }
        byte[] secret = this.engineGenerateSecret();
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        return secret.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        int keyLen;
        if (this.multiPartyAgreement != null) {
            SecretKey key = this.multiPartyAgreement.generateSecret(algorithm);
            this.multiPartyAgreement = null;
            return key;
        }
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        if (algorithm.equals("TlsPremasterSecret")) {
            return this.nativeGenerateSecret(algorithm);
        }
        if (!algorithm.equalsIgnoreCase("TlsPremasterSecret") && !AllowKDF.VALUE) {
            throw new NoSuchAlgorithmException("Unsupported secret key algorithm: " + algorithm);
        }
        byte[] secret = this.engineGenerateSecret();
        if (algorithm.equalsIgnoreCase("DES")) {
            keyLen = 8;
        } else if (algorithm.equalsIgnoreCase("DESede")) {
            keyLen = 24;
        } else if (algorithm.equalsIgnoreCase("Blowfish")) {
            keyLen = Math.min(56, secret.length);
        } else if (algorithm.equalsIgnoreCase("TlsPremasterSecret")) {
            keyLen = secret.length;
        } else {
            throw new NoSuchAlgorithmException("Unknown algorithm " + algorithm);
        }
        if (secret.length < keyLen) {
            throw new InvalidKeyException("Secret too short");
        }
        if (algorithm.equalsIgnoreCase("DES") || algorithm.equalsIgnoreCase("DESede")) {
            for (int i = 0; i < keyLen; i += 8) {
                P11SecretKeyFactory.fixDESParity(secret, i);
            }
        }
        return new SecretKeySpec(secret, 0, keyLen, algorithm);
    }

    private SecretKey nativeGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (this.privateKey == null || this.publicValue == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        long keyType = 16L;
        Session session = null;
        try {
            byte[] newBytes;
            byte[] keyBytes;
            session = this.token.getObjSession();
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(256L, keyType)};
            attributes = this.token.getAttributes("generate", 4L, keyType, attributes);
            long keyID = this.token.p11.C_DeriveKey(session.id(), new CK_MECHANISM(this.mechanism, this.publicValue), this.privateKey.keyID, attributes);
            CK_ATTRIBUTE[] lenAttributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(353L)};
            this.token.p11.C_GetAttributeValue(session.id(), keyID, lenAttributes);
            int keyLen = (int)lenAttributes[0].getLong();
            SecretKey key = P11Key.secretKey(session, keyID, algorithm, keyLen << 3, attributes);
            if ("RAW".equals(key.getFormat()) && (keyBytes = key.getEncoded()) != (newBytes = KeyUtil.trimZeroes(keyBytes))) {
                key = new SecretKeySpec(newBytes, algorithm);
            }
            SecretKey secretKey = key;
            return secretKey;
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not derive key", e);
        }
        finally {
            this.publicValue = null;
            this.token.releaseSession(session);
        }
    }

    private static class AllowKDF {
        private static final boolean VALUE = AllowKDF.getValue();

        private AllowKDF() {
        }

        private static boolean getValue() {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Boolean.getBoolean("jdk.crypto.KeyAgreement.legacyKDF");
                }
            });
        }
    }
}

