/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.image;

import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.image.TeXGraphicsFillAttributes;
import com.dickimawbooks.texparserlib.image.TeXGraphicsGroup;
import com.dickimawbooks.texparserlib.image.TeXGraphicsStrokeAttributes;
import com.dickimawbooks.texparserlib.image.TeXGraphicsTextAttributes;
import com.dickimawbooks.texparserlib.image.TeXGraphicsTransformAttributes;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class TeXGraphicsShape {
    private GeneralPath currentPath = null;
    private TeXParser parser;
    private TeXGraphicsStrokeAttributes strokeAttributes;
    private TeXGraphicsFillAttributes fillAttributes;
    private TeXGraphicsTextAttributes textAttributes;
    private TeXGraphicsTransformAttributes transformAttributes;

    private TeXGraphicsShape() {
    }

    public TeXGraphicsShape(TeXGraphicsGroup teXGraphicsGroup) {
        this.parser = teXGraphicsGroup.getParser();
        this.strokeAttributes = (TeXGraphicsStrokeAttributes)teXGraphicsGroup.getStrokeAttributes().clone();
        this.fillAttributes = (TeXGraphicsFillAttributes)teXGraphicsGroup.getFillAttributes().clone();
        this.textAttributes = (TeXGraphicsTextAttributes)teXGraphicsGroup.getTextAttributes().clone();
        this.transformAttributes = (TeXGraphicsTransformAttributes)teXGraphicsGroup.getTransformAttributes().clone();
        this.currentPath = new GeneralPath(this.fillAttributes.getWindingRule());
    }

    public TeXParser getParser() {
        return this.parser;
    }

    public void moveTo(TeXDimension teXDimension, TeXDimension teXDimension2) throws TeXSyntaxException {
        this.currentPath.moveTo(this.toBp(teXDimension), this.toBp(teXDimension2));
    }

    public void moveTo(float f, float f2) throws TeXSyntaxException {
        this.currentPath.moveTo(this.toX(f), this.toY(f2));
    }

    public void lineTo(TeXDimension teXDimension, TeXDimension teXDimension2) throws TeXSyntaxException {
        this.currentPath.lineTo(this.toBp(teXDimension), this.toBp(teXDimension2));
    }

    public void lineTo(float f, float f2) throws TeXSyntaxException {
        this.currentPath.lineTo(this.toX(f), this.toY(f2));
    }

    public void quadTo(TeXDimension teXDimension, TeXDimension teXDimension2, TeXDimension teXDimension3, TeXDimension teXDimension4) throws TeXSyntaxException {
        this.currentPath.quadTo(this.toBp(teXDimension), this.toBp(teXDimension2), this.toBp(teXDimension3), this.toBp(teXDimension4));
    }

    public void quadTo(float f, float f2, float f3, float f4) throws TeXSyntaxException {
        this.currentPath.quadTo(this.toX(f), this.toY(f2), this.toX(f3), this.toY(f4));
    }

    public void curveTo(TeXDimension teXDimension, TeXDimension teXDimension2, TeXDimension teXDimension3, TeXDimension teXDimension4, TeXDimension teXDimension5, TeXDimension teXDimension6) throws TeXSyntaxException {
        this.currentPath.curveTo(this.toBp(teXDimension), this.toBp(teXDimension2), this.toBp(teXDimension3), this.toBp(teXDimension4), this.toBp(teXDimension5), this.toBp(teXDimension6));
    }

    public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) throws TeXSyntaxException {
        this.currentPath.curveTo(this.toX(f), this.toY(f2), this.toX(f3), this.toY(f4), this.toX(f5), this.toY(f6));
    }

    public void arcTo(int n, float f, float f2, float f3, float f4) throws TeXSyntaxException {
        float f5 = 0.0f;
        float f6 = 0.0f;
        Point2D point2D = this.currentPath.getCurrentPoint();
        if (point2D == null) {
            this.currentPath.moveTo(f5, f6);
        } else {
            f5 = (float)point2D.getX();
            f6 = (float)point2D.getY();
        }
        Arc2D.Float float_ = new Arc2D.Float(f5, f6, 2.0f * this.toX(f), 2.0f * this.toY(f2), f3, f4 - f3, n);
        this.currentPath.append(float_.getPathIterator(null), true);
    }

    public void arcTo(int n, TeXDimension teXDimension, TeXDimension teXDimension2, float f, float f2) throws TeXSyntaxException {
        float f3 = 0.0f;
        float f4 = 0.0f;
        Point2D point2D = this.currentPath.getCurrentPoint();
        if (point2D == null) {
            this.currentPath.moveTo(f3, f4);
        } else {
            f3 = (float)point2D.getX();
            f4 = (float)point2D.getY();
        }
        Arc2D.Float float_ = new Arc2D.Float(f3, f4, 2.0f * this.toBp(teXDimension), 2.0f * this.toBp(teXDimension2), f, f2 - f, n);
        this.currentPath.append(float_.getPathIterator(null), true);
    }

    public void rectTo(float f, float f2) throws TeXSyntaxException {
        float f3 = 0.0f;
        float f4 = 0.0f;
        Point2D point2D = this.currentPath.getCurrentPoint();
        if (point2D == null) {
            this.currentPath.moveTo(f3, f4);
        } else {
            f3 = (float)point2D.getX();
            f4 = (float)point2D.getY();
        }
        float f5 = this.toX(f);
        float f6 = this.toY(f2);
        float f7 = f5 - f3;
        float f8 = f6 - f4;
        if (f7 < 0.0f) {
            f3 = f5;
            f7 = -f7;
        }
        if (f8 < 0.0f) {
            f4 = f6;
            f8 = -f8;
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(f3, f4, f7, f8);
        this.currentPath.append(float_.getPathIterator(null), true);
        this.currentPath.moveTo(f, f2);
    }

    public void rectTo(TeXDimension teXDimension, TeXDimension teXDimension2) throws TeXSyntaxException {
        float f = 0.0f;
        float f2 = 0.0f;
        Point2D point2D = this.currentPath.getCurrentPoint();
        if (point2D == null) {
            this.currentPath.moveTo(f, f2);
        } else {
            f = (float)point2D.getX();
            f2 = (float)point2D.getY();
        }
        float f3 = this.toBp(teXDimension);
        float f4 = this.toBp(teXDimension2);
        float f5 = f3 - f;
        float f6 = f4 - f2;
        if (f5 < 0.0f) {
            f = f3;
            f5 = -f5;
        }
        if (f6 < 0.0f) {
            f2 = f4;
            f6 = -f6;
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f5, f6);
        this.currentPath.append(float_.getPathIterator(null), true);
        this.currentPath.moveTo(this.toBp(teXDimension), this.toBp(teXDimension2));
    }

    public void ellipse(float f, float f2, float f3) throws TeXSyntaxException {
        float f4 = 0.0f;
        float f5 = 0.0f;
        Point2D point2D = this.currentPath.getCurrentPoint();
        if (point2D == null) {
            this.currentPath.moveTo(f4, f5);
        } else {
            f4 = (float)point2D.getX();
            f5 = (float)point2D.getY();
        }
        float f6 = this.toX(f);
        float f7 = this.toY(f2);
        Ellipse2D.Float float_ = new Ellipse2D.Float(f4 - f6, f5 - f7, f4 + f6, f5 + f7);
        AffineTransform affineTransform = null;
        if (f3 != 0.0f) {
            affineTransform = AffineTransform.getRotateInstance(f3, f4, f5);
        }
        this.currentPath.append(float_.getPathIterator(affineTransform), true);
        this.currentPath.moveTo(f4, f5);
    }

    public void ellipse(TeXDimension teXDimension, TeXDimension teXDimension2, float f) throws TeXSyntaxException {
        float f2 = 0.0f;
        float f3 = 0.0f;
        Point2D point2D = this.currentPath.getCurrentPoint();
        if (point2D == null) {
            this.currentPath.moveTo(f2, f3);
        } else {
            f2 = (float)point2D.getX();
            f3 = (float)point2D.getY();
        }
        float f4 = this.toBp(teXDimension);
        float f5 = this.toBp(teXDimension2);
        Ellipse2D.Float float_ = new Ellipse2D.Float(f2 - f4, f3 - f5, f2 + f4, f3 + f5);
        AffineTransform affineTransform = null;
        if (f != 0.0f) {
            affineTransform = AffineTransform.getRotateInstance(f, f2, f3);
        }
        this.currentPath.append(float_.getPathIterator(affineTransform), true);
        this.currentPath.moveTo(f2, f3);
    }

    public void circle(float f) throws TeXSyntaxException {
        float f2 = 0.0f;
        float f3 = 0.0f;
        Point2D point2D = this.currentPath.getCurrentPoint();
        if (point2D == null) {
            this.currentPath.moveTo(f2, f3);
        } else {
            f2 = (float)point2D.getX();
            f3 = (float)point2D.getY();
        }
        float f4 = this.toX(f);
        float f5 = this.toY(f);
        Ellipse2D.Float float_ = new Ellipse2D.Float(f2 - f4, f3 - f5, f2 + f4, f3 + f5);
        this.currentPath.append(float_.getPathIterator(null), true);
        this.currentPath.moveTo(f2, f3);
    }

    public void circle(TeXDimension teXDimension) throws TeXSyntaxException {
        float f = 0.0f;
        float f2 = 0.0f;
        Point2D point2D = this.currentPath.getCurrentPoint();
        if (point2D == null) {
            this.currentPath.moveTo(f, f2);
        } else {
            f = (float)point2D.getX();
            f2 = (float)point2D.getY();
        }
        float f3 = this.toBp(teXDimension);
        float f4 = this.toBp(teXDimension);
        Ellipse2D.Float float_ = new Ellipse2D.Float(f - f3, f2 - f4, f + f3, f2 + f4);
        this.currentPath.append(float_.getPathIterator(null), true);
        this.currentPath.moveTo(f, f2);
    }

    public void roundedRectTo(float f, float f2, float f3, float f4) throws TeXSyntaxException {
        float f5 = 0.0f;
        float f6 = 0.0f;
        Point2D point2D = this.currentPath.getCurrentPoint();
        if (point2D == null) {
            this.currentPath.moveTo(f5, f6);
        } else {
            f5 = (float)point2D.getX();
            f6 = (float)point2D.getY();
        }
        float f7 = this.toX(f);
        float f8 = this.toY(f2);
        float f9 = this.toX(f3);
        float f10 = this.toY(f4);
        float f11 = f7 - f5;
        float f12 = f8 - f6;
        if (f11 < 0.0f) {
            f5 = f7;
            f11 = -f11;
        }
        if (f12 < 0.0f) {
            f6 = f8;
            f12 = -f12;
        }
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(f5, f6, f11, f12, f9, f10);
        this.currentPath.append(float_.getPathIterator(null), true);
        this.currentPath.moveTo(f, f2);
    }

    public void roundedRectTo(TeXDimension teXDimension, TeXDimension teXDimension2, TeXDimension teXDimension3, TeXDimension teXDimension4) throws TeXSyntaxException {
        float f = 0.0f;
        float f2 = 0.0f;
        Point2D point2D = this.currentPath.getCurrentPoint();
        if (point2D == null) {
            this.currentPath.moveTo(f, f2);
        } else {
            f = (float)point2D.getX();
            f2 = (float)point2D.getY();
        }
        float f3 = this.toBp(teXDimension);
        float f4 = this.toBp(teXDimension2);
        float f5 = this.toBp(teXDimension3);
        float f6 = this.toBp(teXDimension4);
        float f7 = f3 - f;
        float f8 = f4 - f2;
        if (f7 < 0.0f) {
            f = f3;
            f7 = -f7;
        }
        if (f8 < 0.0f) {
            f2 = f4;
            f8 = -f8;
        }
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(f, f2, f7, f8, f5, f6);
        this.currentPath.append(float_.getPathIterator(null), true);
        this.currentPath.moveTo(this.toBp(teXDimension), this.toBp(teXDimension2));
    }

    public void closePath() {
        this.currentPath.closePath();
    }

    private float toX(float f) throws TeXSyntaxException {
        return this.transformAttributes.toBpX(this.parser, f);
    }

    private float toY(float f) throws TeXSyntaxException {
        return this.transformAttributes.toBpY(this.parser, f);
    }

    private float toBp(TeXDimension teXDimension) throws TeXSyntaxException {
        return teXDimension.getUnit().fromUnit(this.parser, teXDimension.getValue(), TeXUnit.BP) * teXDimension.getValue();
    }

    public Object clone() {
        TeXGraphicsShape teXGraphicsShape = new TeXGraphicsShape();
        teXGraphicsShape.parser = this.parser;
        teXGraphicsShape.strokeAttributes = (TeXGraphicsStrokeAttributes)this.strokeAttributes.clone();
        teXGraphicsShape.fillAttributes = (TeXGraphicsFillAttributes)this.fillAttributes.clone();
        teXGraphicsShape.textAttributes = (TeXGraphicsTextAttributes)this.textAttributes.clone();
        teXGraphicsShape.transformAttributes = (TeXGraphicsTransformAttributes)this.transformAttributes.clone();
        teXGraphicsShape.currentPath = new GeneralPath(this.currentPath);
        return teXGraphicsShape;
    }

    public Rectangle2D computeBounds() {
        return this.createTransformedShape().getBounds2D();
    }

    public Rectangle2D computeStrokedBounds() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(this.createTransformedShape().getBounds2D().getPathIterator(null, 0.0), false);
        Stroke stroke = this.strokeAttributes.getStroke();
        return stroke.createStrokedShape(generalPath).getBounds2D();
    }

    public Shape createTransformedShape() {
        return this.transformAttributes.getTransform().createTransformedShape(this.currentPath);
    }

    public TeXGraphicsStrokeAttributes getStrokeAttributes() {
        return this.strokeAttributes;
    }

    public TeXGraphicsFillAttributes getFillAttributes() {
        return this.fillAttributes;
    }

    public TeXGraphicsTransformAttributes getTransformAttributes() {
        return this.transformAttributes;
    }

    public void setColor(Color color) {
        this.strokeAttributes.setLineColor(color);
        this.fillAttributes.setFillColor(color);
        this.textAttributes.setTextColor(color);
    }

    public TeXGraphicsTextAttributes getTextAttributes() {
        return this.textAttributes;
    }
}

