/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.tree.TreeNode;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.FilterSortSupport;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;

public abstract class PrestimeCPUCCTNode
extends CCTNode
implements Cloneable {
    private static final String SELF_TIME_STRING;
    protected static final char MASK_SELF_TIME_NODE = '\u0001';
    protected static final char MASK_CONTEXT_CALLS_NODE = '\u0002';
    protected static final char MASK_THREAD_NODE = '\u0004';
    public static final int SORT_BY_NAME = 1;
    public static final int SORT_BY_TIME_0 = 2;
    public static final int SORT_BY_TIME_1 = 3;
    public static final int SORT_BY_INVOCATIONS = 4;
    public static final PrestimeCPUCCTNode EMPTY;
    protected CPUCCTContainer container;
    protected PrestimeCPUCCTNode parent;
    protected PrestimeCPUCCTNode[] children;
    protected char flags;
    private String nodeName;
    protected int methodId;
    protected int nCalls;
    protected long sleepTime0;
    protected long totalTime0;
    protected long totalTime1;
    protected long waitTime0;

    protected PrestimeCPUCCTNode() {
    }

    protected PrestimeCPUCCTNode(CPUCCTContainer cPUCCTContainer, PrestimeCPUCCTNode prestimeCPUCCTNode, int n) {
        this.container = cPUCCTContainer;
        this.parent = prestimeCPUCCTNode;
        this.methodId = n;
    }

    PrestimeCPUCCTNode createCopy() {
        throw new UnsupportedOperationException("Cannot be called directly on " + this.getClass().getName());
    }

    void setupCopy(PrestimeCPUCCTNode prestimeCPUCCTNode) {
        prestimeCPUCCTNode.container = this.container;
        prestimeCPUCCTNode.parent = this.parent;
        prestimeCPUCCTNode.children = this.children;
        prestimeCPUCCTNode.flags = this.flags;
        prestimeCPUCCTNode.nodeName = this.nodeName;
        prestimeCPUCCTNode.methodId = this.methodId;
        prestimeCPUCCTNode.nCalls = this.nCalls;
        prestimeCPUCCTNode.sleepTime0 = this.sleepTime0;
        prestimeCPUCCTNode.totalTime0 = this.totalTime0;
        prestimeCPUCCTNode.totalTime1 = this.totalTime1;
        prestimeCPUCCTNode.waitTime0 = this.waitTime0;
    }

    protected void setupFilteredNode(PrestimeCPUCCTNode prestimeCPUCCTNode) {
        this.setupCopy(prestimeCPUCCTNode);
        prestimeCPUCCTNode.setFilteredNode();
        prestimeCPUCCTNode.nodeName = null;
        prestimeCPUCCTNode.methodId = -1;
        Collection<PrestimeCPUCCTNode> collection = PrestimeCPUCCTNode.resolveChildren(this);
        prestimeCPUCCTNode.children = collection.toArray(new PrestimeCPUCCTNode[0]);
    }

    @Override
    public void merge(CCTNode cCTNode) {
        if (cCTNode instanceof PrestimeCPUCCTNode) {
            PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray;
            PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)cCTNode;
            this.addNCalls(prestimeCPUCCTNode.getNCalls());
            this.addSleepTime0(prestimeCPUCCTNode.getSleepTime0());
            this.addTotalTime0(prestimeCPUCCTNode.getTotalTime0());
            this.addTotalTime1(prestimeCPUCCTNode.getTotalTime1());
            this.addWaitTime0(prestimeCPUCCTNode.getWaitTime0());
            ArrayList<PrestimeCPUCCTNode> arrayList = new ArrayList<PrestimeCPUCCTNode>();
            PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray2 = (PrestimeCPUCCTNode[])this.getChildren();
            if (prestimeCPUCCTNodeArray2 != null) {
                prestimeCPUCCTNodeArray = prestimeCPUCCTNodeArray2;
                int n = prestimeCPUCCTNodeArray.length;
                for (int i = 0; i < n; ++i) {
                    PrestimeCPUCCTNode prestimeCPUCCTNode2 = prestimeCPUCCTNodeArray[i];
                    arrayList.add(prestimeCPUCCTNode2.createCopy());
                }
            }
            if ((prestimeCPUCCTNodeArray = (PrestimeCPUCCTNode[])cCTNode.getChildren()) != null) {
                for (PrestimeCPUCCTNode prestimeCPUCCTNode3 : prestimeCPUCCTNodeArray) {
                    if (prestimeCPUCCTNode3 == null || prestimeCPUCCTNode3.isSelfTimeNode()) continue;
                    int n = arrayList.indexOf(prestimeCPUCCTNode3);
                    if (n == -1) {
                        arrayList.add(prestimeCPUCCTNode3.createCopy());
                        continue;
                    }
                    ((CCTNode)arrayList.get(n)).merge(prestimeCPUCCTNode3);
                }
            }
            this.children = arrayList.toArray(new PrestimeCPUCCTNode[0]);
        }
    }

    protected static Collection<PrestimeCPUCCTNode> resolveChildren(PrestimeCPUCCTNode prestimeCPUCCTNode) {
        ArrayList<PrestimeCPUCCTNode> arrayList = new ArrayList<PrestimeCPUCCTNode>();
        PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray = (PrestimeCPUCCTNode[])prestimeCPUCCTNode.getChildren();
        if (prestimeCPUCCTNodeArray != null) {
            for (PrestimeCPUCCTNode prestimeCPUCCTNode2 : prestimeCPUCCTNodeArray) {
                if (prestimeCPUCCTNode2.isSelfTimeNode()) continue;
                arrayList.add(prestimeCPUCCTNode2);
            }
        }
        return arrayList;
    }

    @Override
    public CCTNode getChild(int n) {
        return this.children[n];
    }

    @Override
    public CCTNode[] getChildren() {
        return this.children;
    }

    @Override
    public int getNChildren() {
        return this.children != null ? this.children.length : 0;
    }

    public CPUCCTContainer getContainer() {
        return this.container;
    }

    public int getMethodId() {
        return this.methodId;
    }

    public int getNCalls() {
        return this.nCalls;
    }

    public long getSleepTime0() {
        return this.sleepTime0;
    }

    public int getThreadId() {
        return this.container.getThreadId();
    }

    public long getTotalTime0() {
        return this.totalTime0;
    }

    public long getTotalTime1() {
        return this.totalTime1;
    }

    public long getWaitTime0() {
        return this.waitTime0;
    }

    public void addNCalls(int n) {
        this.nCalls += n;
    }

    public void addSleepTime0(long l) {
        this.sleepTime0 += l;
    }

    public void addTotalTime0(long l) {
        this.totalTime0 += l;
    }

    public void addTotalTime1(long l) {
        this.totalTime1 += l;
    }

    public void addWaitTime0(long l) {
        this.waitTime0 += l;
    }

    public void setContextCallsNode() {
        this.flags = (char)2;
    }

    public boolean isContextCallsNode() {
        return (this.flags & 2) != 0;
    }

    public String[] getMethodClassNameAndSig() {
        if (!this.isThreadNode()) {
            return this.container.getMethodClassNameAndSig(this.getMethodId());
        }
        return new String[]{this.container.getThreadName(), "", ""};
    }

    protected void resetChildren() {
        if (this.children != null) {
            for (PrestimeCPUCCTNode prestimeCPUCCTNode : this.children) {
                prestimeCPUCCTNode.resetChildren();
            }
        }
    }

    public String getNodeName() {
        if (this.nodeName == null) {
            this.nodeName = this.computeNodeName();
        }
        return this.nodeName;
    }

    protected String computeNodeName() {
        if (this.isFiltered()) {
            return FilterSortSupport.FILTERED_OUT_LBL;
        }
        if (this.isSelfTimeNode()) {
            return SELF_TIME_STRING;
        }
        if (this.isThreadNode()) {
            return this.container.getThreadName();
        }
        int n = this.getMethodId();
        String[] stringArray = this.container.getMethodClassNameAndSig(n);
        return MethodNameFormatterFactory.getDefault().getFormatter().formatMethodName(stringArray[0], stringArray[1], stringArray[2]).toFormatted();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PrestimeCPUCCTNode)) {
            return false;
        }
        PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)object;
        if (this.parent == null) {
            return prestimeCPUCCTNode.parent == null;
        }
        if (this.isThreadNode()) {
            return this.container.getThreadId() == prestimeCPUCCTNode.container.getThreadId();
        }
        if (this.isSelfTimeNode()) {
            return prestimeCPUCCTNode.isSelfTimeNode();
        }
        if (this.isFiltered()) {
            return prestimeCPUCCTNode.isFiltered();
        }
        if (this.isContextCallsNode()) {
            return this.getMethodId() == prestimeCPUCCTNode.getMethodId();
        }
        return this.getMethodId() == prestimeCPUCCTNode.getMethodId();
    }

    public int hashCode() {
        if (this.parent == null) {
            return 1;
        }
        if (this.isThreadNode()) {
            return this.container.getThreadId();
        }
        if (this.isSelfTimeNode()) {
            return -1;
        }
        if (this.isFiltered()) {
            return -10;
        }
        if (this.isContextCallsNode()) {
            return Integer.MIN_VALUE + this.getMethodId();
        }
        return this.getMethodId();
    }

    @Override
    public CCTNode getParent() {
        return this.parent;
    }

    public void setSelfTimeNode() {
        this.flags = (char)(this.flags | '\u0001');
    }

    public boolean isSelfTimeNode() {
        return (this.flags & '\u0001') != 0;
    }

    public void setThreadNode() {
        this.flags = (char)(this.flags | 4);
    }

    public boolean isThreadNode() {
        return (this.flags & 4) != 0;
    }

    public abstract float getTotalTime0InPerCent();

    public abstract float getTotalTime1InPerCent();

    @Override
    public int getIndexOfChild(Object object) {
        if (this.getNChildren() == 0) {
            return -1;
        }
        for (int i = 0; i < this.children.length; ++i) {
            if ((PrestimeCPUCCTNode)object != this.children[i]) continue;
            return i;
        }
        return -1;
    }

    public void sortChildren(int n, boolean bl) {
    }

    public String toString() {
        return this.getNodeName();
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.cpu.Bundle");
        SELF_TIME_STRING = resourceBundle.getString("PrestimeCPUCCTNode_SelfTimeString");
        EMPTY = new PrestimeCPUCCTNode(){

            @Override
            PrestimeCPUCCTNode createCopy() {
                return null;
            }

            @Override
            public PrestimeCPUCCTNode getChild(int n) {
                return null;
            }

            public PrestimeCPUCCTNode[] getChildren() {
                return new PrestimeCPUCCTNode[0];
            }

            @Override
            public int getIndexOfChild(Object object) {
                return -1;
            }

            @Override
            public int getNChildren() {
                return 0;
            }

            @Override
            public String getNodeName() {
                return "";
            }

            public long getTime() {
                return 0L;
            }

            public double getTimeInPerCent() {
                return 0.0;
            }

            public long getWaits() {
                return 0L;
            }

            @Override
            public int getMethodId() {
                return -1;
            }

            @Override
            public int getNCalls() {
                return -1;
            }

            @Override
            public long getSleepTime0() {
                return -1L;
            }

            @Override
            public int getThreadId() {
                return -1;
            }

            @Override
            public long getTotalTime0() {
                return -1L;
            }

            @Override
            public float getTotalTime0InPerCent() {
                return -1.0f;
            }

            @Override
            public long getTotalTime1() {
                return -1L;
            }

            @Override
            public float getTotalTime1InPerCent() {
                return -1.0f;
            }

            @Override
            public long getWaitTime0() {
                return -1L;
            }

            @Override
            public void sortChildren(int n, boolean bl) {
            }

            @Override
            public TreeNode getChildAt(int n) {
                return null;
            }

            @Override
            public int getChildCount() {
                return 0;
            }

            @Override
            public CCTNode getParent() {
                return null;
            }

            @Override
            public int getIndex(TreeNode treeNode) {
                return -1;
            }

            @Override
            public boolean getAllowsChildren() {
                return false;
            }

            @Override
            public boolean isLeaf() {
                return true;
            }

            public Enumeration children() {
                return null;
            }
        };
    }
}

