/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.remote;

import com.sun.star.lib.uno.environments.remote.IThreadPool;
import com.sun.star.lib.uno.environments.remote.JavaThreadPool;
import com.sun.star.lib.uno.environments.remote.JobQueue;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import java.util.Collection;
import java.util.HashMap;
import java.util.WeakHashMap;

final class JavaThreadPoolFactory {
    private static final WeakHashMap<Thread, ThreadId> threadIdMap = new WeakHashMap();
    private final HashMap<ThreadId, JobQueue> jobQueues = new HashMap();

    JavaThreadPoolFactory() {
    }

    public IThreadPool createThreadPool() {
        return new JavaThreadPool(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobQueue(JobQueue jobQueue) {
        HashMap<ThreadId, JobQueue> hashMap = this.jobQueues;
        synchronized (hashMap) {
            this.jobQueues.put(jobQueue.getThreadId(), jobQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobQueue(JobQueue jobQueue) {
        HashMap<ThreadId, JobQueue> hashMap = this.jobQueues;
        synchronized (hashMap) {
            this.jobQueues.remove(jobQueue.getThreadId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobQueue getJobQueue(ThreadId threadId) {
        HashMap<ThreadId, JobQueue> hashMap = this.jobQueues;
        synchronized (hashMap) {
            return this.jobQueues.get(threadId);
        }
    }

    public JobQueue getAsyncJobQueue(ThreadId threadId) {
        JobQueue q = this.getJobQueue(threadId);
        return q == null ? null : q._async_jobQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(Object disposeId, Throwable throwable) {
        JobQueue[] qs;
        HashMap<ThreadId, JobQueue> hashMap = this.jobQueues;
        synchronized (hashMap) {
            Collection<JobQueue> c = this.jobQueues.values();
            qs = c.toArray(new JobQueue[c.size()]);
        }
        for (int i = 0; i < qs.length; ++i) {
            qs[i].dispose(disposeId, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadId getThreadId() {
        ThreadId id;
        Thread t = Thread.currentThread();
        if (t instanceof JobQueue.JobDispatcher) {
            return ((JobQueue.JobDispatcher)t).getThreadId();
        }
        WeakHashMap<Thread, ThreadId> weakHashMap = threadIdMap;
        synchronized (weakHashMap) {
            id = threadIdMap.get(t);
            if (id == null) {
                id = ThreadId.createFresh();
                threadIdMap.put(t, id);
            }
        }
        return id;
    }
}

