/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.beans;

import io.micronaut.context.DefaultApplicationContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.env.DefaultEnvironment;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.spring.beans.MicronautSpringBeanFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class MicronautBeanProcessor
implements BeanFactoryPostProcessor,
DisposableBean,
EnvironmentAware {
    private static final String MICRONAUT_BEAN_TYPE_PROPERTY_NAME = "micronautBeanType";
    private static final String MICRONAUT_CONTEXT_PROPERTY_NAME = "micronautContext";
    private static final String MICRONAUT_SINGLETON_PROPERTY_NAME = "micronautSingleton";
    protected DefaultBeanContext micronautContext;
    protected final List<Class<?>> micronautBeanQualifierTypes;
    private Environment environment;

    public MicronautBeanProcessor(Class<?> ... qualifierTypes) {
        this.micronautBeanQualifierTypes = Arrays.asList(qualifierTypes);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.micronautContext = this.environment != null ? new DefaultApplicationContext(this.environment.getActiveProfiles()){
            DefaultEnvironment env;
            {
                this.env = new DefaultEnvironment(MicronautBeanProcessor.this.environment.getActiveProfiles()){

                    public io.micronaut.context.env.Environment start() {
                        return this;
                    }

                    public io.micronaut.context.env.Environment stop() {
                        return this;
                    }

                    public boolean containsProperty(@Nullable String name) {
                        return MicronautBeanProcessor.this.environment.containsProperty(name);
                    }

                    public boolean containsProperties(@Nullable String name) {
                        return MicronautBeanProcessor.this.environment.containsProperty(name);
                    }

                    public <T> Optional<T> getProperty(@Nullable String name, ArgumentConversionContext<T> conversionContext) {
                        return Optional.ofNullable(MicronautBeanProcessor.this.environment.getProperty(name, conversionContext.getArgument().getType()));
                    }
                };
            }

            public io.micronaut.context.env.Environment getEnvironment() {
                return this.env;
            }
        } : new DefaultApplicationContext(new String[0]);
        this.micronautContext.start();
        this.micronautBeanQualifierTypes.stream().forEach(micronautBeanQualifierType -> {
            Qualifier micronautBeanQualifier = micronautBeanQualifierType.isAnnotation() ? Qualifiers.byStereotype((Class)micronautBeanQualifierType) : Qualifiers.byType((Class[])new Class[]{micronautBeanQualifierType});
            this.micronautContext.getBeanDefinitions(micronautBeanQualifier).stream().forEach(definition -> {
                BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)MicronautSpringBeanFactory.class.getName());
                beanDefinitionBuilder.addPropertyValue(MICRONAUT_BEAN_TYPE_PROPERTY_NAME, (Object)definition.getBeanType());
                beanDefinitionBuilder.addPropertyValue(MICRONAUT_CONTEXT_PROPERTY_NAME, (Object)this.micronautContext);
                beanDefinitionBuilder.addPropertyValue(MICRONAUT_SINGLETON_PROPERTY_NAME, (Object)definition.isSingleton());
                ((DefaultListableBeanFactory)beanFactory).registerBeanDefinition(definition.getName(), (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
            });
        });
    }

    public void destroy() throws Exception {
        if (this.micronautContext != null) {
            this.micronautContext.close();
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

