/*
 * Decompiled with CFR 0.152.
 */
package pmdefaults;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import jportmidi.JPortMidi;
import jportmidi.JPortMidiApi;
import jportmidi.JPortMidiException;

public class PmDefaultsFrame
extends JFrame
implements ActionListener,
ComponentListener {
    private JLabel inputLabel;
    private JComboBox inputSelection;
    private ArrayList<Integer> inputIds;
    private ActivityLight inputActivity;
    private JLabel outputLabel;
    private JComboBox outputSelection;
    private ArrayList<Integer> outputIds;
    private JButton testButton;
    private JButton refreshButton;
    private JButton updateButton;
    private JButton closeButton;
    private JLabel logo;
    private JPM jpm;
    private Timer timer;

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        System.out.println(componentEvent);
        if (componentEvent.getComponent() == this) {
            Insets insets = this.getInsets();
            Dimension dimension = this.getSize();
            this.layoutComponents(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        System.out.println(componentEvent);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        System.out.println(componentEvent);
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        System.out.println(componentEvent);
    }

    PmDefaultsFrame(String string) {
        super(string);
        this.initComponents();
        System.out.println("initComponents returned\n");
        this.pack();
        this.layoutComponents(550, 300);
        System.out.println("after layout, pref " + this.getPreferredSize());
        Insets insets = this.getInsets();
        Dimension dimension = this.getPreferredSize();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        this.setSize(dimension);
        System.out.println("size" + this.getPreferredSize());
        this.addComponentListener(this);
        this.timer = new Timer(50, this);
        this.timer.addActionListener(this);
        try {
            this.jpm = new JPM(this.inputActivity, this);
            this.jpm.setTrace(true);
            this.loadDeviceChoices();
            this.timer.start();
        }
        catch (JPortMidiException jPortMidiException) {
            System.out.println(jPortMidiException);
        }
    }

    void openInputSelection() {
        int n = this.inputSelection.getSelectedIndex();
        if (n < 0) {
            return;
        }
        n = this.inputIds.get(n);
        try {
            this.jpm.openInput(n, 100);
        }
        catch (JPortMidiException jPortMidiException) {
            System.out.println(jPortMidiException);
        }
    }

    String makePrefName(int n) {
        String string = this.jpm.getDeviceName(n);
        String string2 = this.jpm.getDeviceInterf(n);
        return string2 + ", " + string;
    }

    public void savePreferences() {
        String string;
        Preferences preferences = Preferences.userRoot().node("/PortMidi");
        int n = this.outputSelection.getSelectedIndex();
        if (n >= 0) {
            string = this.makePrefName(this.outputIds.get(n));
            System.out.println("output pref: " + string);
            preferences.put("PM_RECOMMENDED_OUTPUT_DEVICE", string);
        }
        if ((n = this.inputSelection.getSelectedIndex()) >= 0) {
            string = this.makePrefName(this.inputIds.get(n));
            System.out.println("input pref: " + string);
            preferences.put("PM_RECOMMENDED_INPUT_DEVICE", string);
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println(backingStoreException);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        try {
            if (object == this.timer) {
                this.jpm.poll(this.jpm.timeGet());
            } else if (object == this.refreshButton) {
                if (this.jpm.isOpenInput()) {
                    this.jpm.closeInput();
                }
                if (this.jpm.isOpenOutput()) {
                    this.jpm.closeOutput();
                }
                this.jpm.refreshDeviceLists();
                this.loadDeviceChoices();
            } else if (object == this.updateButton) {
                this.savePreferences();
            } else if (object == this.closeButton) {
                if (this.jpm.isOpenInput()) {
                    this.jpm.closeInput();
                }
                if (this.jpm.isOpenOutput()) {
                    this.jpm.closeOutput();
                }
            } else if (object == this.testButton) {
                this.sendTestMessages();
            } else if (object == this.inputSelection) {
                this.openInputSelection();
            } else if (object == this.outputSelection) {
                this.jpm.closeOutput();
            }
        }
        catch (JPortMidiException jPortMidiException) {
            System.out.println(jPortMidiException);
        }
    }

    private void layoutComponents(int n, int n2) {
        int n3 = 2;
        int n4 = 20;
        int n5 = n3;
        this.inputLabel.setLocation(0, n5);
        this.inputLabel.setSize(this.inputLabel.getPreferredSize());
        this.inputSelection.setLocation(n4, n5 += this.inputLabel.getHeight() + n3);
        Dimension dimension = this.inputSelection.getPreferredSize();
        Dimension dimension2 = this.testButton.getPreferredSize();
        dimension.height = dimension2.height = Math.max(dimension.height, dimension2.height);
        dimension.width = n - n4 - dimension2.width - n3;
        this.inputSelection.setSize(dimension);
        this.inputActivity.setLocation(n4 + dimension.width + n3, n5);
        this.inputActivity.setSize(dimension.height, dimension.height);
        this.outputLabel.setLocation(0, n5 += dimension.height + n3);
        this.outputLabel.setSize(this.outputLabel.getPreferredSize());
        this.outputSelection.setLocation(n4, n5 += this.outputLabel.getHeight() + n3);
        this.outputSelection.setSize(dimension);
        this.testButton.setLocation(n4 + dimension.width + n3, n5);
        this.testButton.setSize(dimension2);
        System.out.println("button " + dimension2 + " selection " + dimension);
        dimension = this.refreshButton.getPreferredSize();
        this.refreshButton.setLocation(n4, n5 += dimension.height + n3);
        this.refreshButton.setSize(dimension);
        int n6 = n4 + dimension.width + n3;
        this.updateButton.setLocation(n6, n5);
        dimension = this.updateButton.getPreferredSize();
        this.updateButton.setSize(dimension);
        this.closeButton.setLocation(n6 += dimension.width + n3, n5);
        dimension = this.closeButton.getPreferredSize();
        this.closeButton.setSize(dimension);
        n5 += dimension.height + n3;
        this.logo.setLocation((n - this.logo.getWidth()) / 2, n2 - n3 - this.logo.getHeight());
        System.out.println("computed best size " + n + ", " + (n5 += this.logo.getHeight() + n3));
        this.setPreferredSize(new Dimension(n, n5));
    }

    private void initComponents() {
        Container container = this.getContentPane();
        container.setLayout(null);
        this.setLayout(null);
        this.inputLabel = new JLabel();
        this.inputLabel.setText("Default Input");
        container.add(this.inputLabel);
        this.inputSelection = new JComboBox();
        this.inputSelection.addActionListener(this);
        this.inputSelection.setLocation(20, 30);
        this.inputSelection.setSize(this.inputSelection.getPreferredSize());
        System.out.println("Adding inputSelection to panel");
        container.add(this.inputSelection);
        this.inputIds = new ArrayList();
        this.inputActivity = new ActivityLight();
        container.add(this.inputActivity);
        this.outputLabel = new JLabel();
        this.outputLabel.setText("Default Output");
        container.add(this.outputLabel);
        this.outputSelection = new JComboBox();
        this.outputSelection.addActionListener(this);
        container.add(this.outputSelection);
        this.testButton = new JButton();
        this.testButton.setText("Test");
        this.testButton.addActionListener(this);
        container.add(this.testButton);
        this.outputIds = new ArrayList();
        this.refreshButton = new JButton();
        this.refreshButton.setText("Refresh Device Lists");
        System.out.println("refresh " + this.refreshButton.getPreferredSize());
        System.out.println(this.getLayout());
        this.refreshButton.addActionListener(this);
        container.add(this.refreshButton);
        this.updateButton = new JButton();
        this.updateButton.setText("Update Preferences");
        this.updateButton.setSize(this.refreshButton.getPreferredSize());
        this.updateButton.addActionListener(this);
        container.add(this.updateButton);
        this.closeButton = new JButton();
        this.closeButton.setText("Close/Release Ports");
        this.closeButton.setSize(this.refreshButton.getPreferredSize());
        this.closeButton.addActionListener(this);
        container.add(this.closeButton);
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource("portmusic_logo.png");
        ImageIcon imageIcon = uRL == null ? new ImageIcon("portmusic_logo.png") : new ImageIcon(uRL);
        this.logo = new JLabel(imageIcon);
        this.logo.setSize(this.logo.getPreferredSize());
        container.add(this.logo);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    void loadDeviceChoices() throws JPortMidiException {
        int n = this.jpm.countDevices();
        this.inputSelection.removeAllItems();
        this.inputIds.clear();
        this.outputSelection.removeAllItems();
        this.outputIds.clear();
        for (int i = 0; i < n; ++i) {
            String string = this.jpm.getDeviceInterf(i);
            String string2 = this.jpm.getDeviceName(i);
            System.out.println("name " + string2);
            String string3 = string2 + " [" + string + "]";
            if (this.jpm.getDeviceInput(i)) {
                this.inputIds.add(i);
                this.inputSelection.addItem(string3);
                continue;
            }
            this.outputIds.add(i);
            this.outputSelection.addItem(string3);
        }
    }

    void sendTestMessages() {
        try {
            if (!this.jpm.isOpenOutput()) {
                int n = this.outputSelection.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                n = this.outputIds.get(n);
                System.out.println("calling openOutput");
                this.jpm.openOutput(n, 10, 10);
            }
            this.jpm.midiNote(0, 67, 100);
            this.jpm.midiNote(0, 67, 0, this.jpm.timeGet() + 500);
        }
        catch (JPortMidiException jPortMidiException) {
            System.out.println(jPortMidiException);
        }
    }

    public class ActivityLight
    extends JPanel {
        Color color;
        final Color OFF_COLOR = Color.BLACK;
        final Color ON_COLOR = Color.GREEN;

        ActivityLight() {
            Dimension dimension = new Dimension(50, 25);
            this.setMaximumSize(dimension);
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
            this.color = this.OFF_COLOR;
            System.out.println("ActivityLight " + this.getSize());
        }

        public void setState(boolean bl) {
            this.color = bl ? this.ON_COLOR : this.OFF_COLOR;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(this.color);
            int n = this.getWidth() / 2 - 5;
            int n2 = this.getHeight() / 2 - 5;
            graphics.fillOval(n, n2, 10, 10);
            graphics.setColor(this.OFF_COLOR);
            graphics.drawOval(n, n2, 10, 10);
        }
    }

    public class JPM
    extends JPortMidi {
        ActivityLight light;
        PmDefaultsFrame frame;
        int lightTime;
        boolean lightState;
        int now;
        final int HALF_BLINK_PERIOD = 250;

        public JPM(ActivityLight activityLight, PmDefaultsFrame pmDefaultsFrame2) throws JPortMidiException {
            this.light = activityLight;
            this.frame = pmDefaultsFrame2;
            this.lightTime = 0;
            this.lightState = false;
            this.now = 0;
        }

        public void poll(int n) throws JPortMidiException {
            this.now = n;
            if (this.now > this.lightTime && this.lightState) {
                this.lightTime = this.now + 250;
                this.lightState = false;
                this.light.setState(false);
            }
            super.poll();
        }

        @Override
        public void handleMidiIn(JPortMidiApi.PmEvent pmEvent) {
            System.out.println("midi in: now " + this.now + " lightTime " + this.lightTime + " lightState " + this.lightState);
            if (this.now > this.lightTime && !this.lightState) {
                this.lightState = true;
                this.lightTime = this.now + 250;
                this.light.setState(true);
            }
        }
    }
}

