/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsDualEntry;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;

public class Bib2GlsDualAbbrevEntry
extends Bib2GlsDualEntry {
    public Bib2GlsDualAbbrevEntry(Bib2Gls bib2Gls) {
        this(bib2Gls, "dualabbreviationentry");
    }

    public Bib2GlsDualAbbrevEntry(Bib2Gls bib2Gls, String string) {
        super(bib2Gls, string);
    }

    @Override
    public HashMap<String, String> getMappings() {
        return this.getResource().getDualAbbrevEntryMap();
    }

    @Override
    public String getFirstMap() {
        return this.getResource().getFirstDualAbbrevEntryMap();
    }

    @Override
    public boolean backLink() {
        return this.getResource().backLinkFirstDualAbbrevEntryMap();
    }

    @Override
    protected Bib2GlsDualEntry createDualEntry() {
        return new Bib2GlsDualAbbrevEntry(this.bib2gls, this.getEntryType() + "secondary");
    }

    @Override
    public void checkRequiredFields() {
        if (this.getField("short") == null) {
            this.missingFieldWarning("short");
        }
        if (this.getField("long") == null) {
            this.missingFieldWarning("long");
        }
        if (this.getField("description") == null) {
            this.missingFieldWarning("description");
        }
    }

    @Override
    public String getFallbackValue(String string) {
        if (string.equals("sort")) {
            String string2;
            String string3 = string2 = this.isPrimary() ? this.resource.getAbbrevDefaultSortField() : "name";
            if (string2.equals("id")) {
                return this.getOriginalId();
            }
            String string4 = this.getFieldValue(string2);
            return string4 == null ? this.getFallbackValue(string2) : string4;
        }
        if (string.equals("name")) {
            String string5 = this.resource.getAbbrevDefaultNameField();
            String string6 = this.getFieldValue(string5);
            return string6 == null ? this.getFallbackValue(string5) : string6;
        }
        return super.getFallbackValue(string);
    }

    @Override
    public BibValueList getFallbackContents(String string) {
        if (string.equals("sort")) {
            String string2;
            String string3 = string2 = this.isPrimary() ? this.resource.getAbbrevDefaultSortField() : "name";
            if (string2.equals("sort")) {
                return this.getIdField();
            }
            BibValueList bibValueList = this.getField(string2);
            return bibValueList == null ? this.getFallbackContents(string2) : bibValueList;
        }
        if (string.equals("name")) {
            String string4 = this.resource.getAbbrevDefaultNameField();
            BibValueList bibValueList = this.getField(string4);
            return bibValueList == null ? this.getFallbackContents(string4) : bibValueList;
        }
        return super.getFallbackContents(string);
    }

    @Override
    public void writeBibEntry(PrintWriter printWriter) throws IOException {
        printWriter.format("\\%s{%s}%%%n{", this.getCsName(), this.getId());
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        Set<String> set = this.getFieldSet();
        for (String string5 : set) {
            if (string5.equals("short")) {
                string2 = this.getFieldValue(string5);
                continue;
            }
            if (string5.equals("long")) {
                string3 = this.getFieldValue(string5);
                continue;
            }
            if (string5.equals("description")) {
                string4 = this.getFieldValue(string5);
                continue;
            }
            if (this.bib2gls.isKnownField(string5)) {
                printWriter.format("%s", string);
                string = String.format(",%n", new Object[0]);
                printWriter.format("%s={%s}", string5, this.getFieldValue(string5));
                continue;
            }
            if (this.bib2gls.getDebugLevel() <= 0 || this.bib2gls.isInternalField(string5)) continue;
            this.bib2gls.debugMessage("warning.ignoring.unknown.field", string5);
        }
        printWriter.println(String.format("}%%%n{%s}{%s}%%%n{%s}", string2, string3, string4));
    }

    @Override
    public void writeCsDefinition(PrintWriter printWriter) throws IOException {
        printWriter.format("\\providecommand{\\%s}[5]{%%%n", this.getCsName());
        if (this.isPrimary()) {
            printWriter.println("  \\newabbreviation[#2]{#1}{#3}{#4}%");
        } else {
            printWriter.println("  \\longnewglossaryentry*{#1}{#2}{#5}%");
        }
        printWriter.println("}");
    }
}

