/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.color;

import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.TextBlockCommand;
import com.dickimawbooks.texparserlib.latex.color.ColorDeclaration;
import com.dickimawbooks.texparserlib.latex.color.DefineColor;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.io.IOException;
import java.util.HashMap;

public class ColorSty
extends LaTeXSty {
    private HashMap<String, Color> definedColors;
    public static final String UNSUPPORTED_COLOR = "color.unsupported";
    public static final String INVALID_SPECS = "color.invalid.specs";
    public static final String UNKNOWN = "color.unknown";

    public ColorSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        this(keyValList, "color", laTeXParserListener, bl);
    }

    public ColorSty(KeyValList keyValList, String string, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, string, laTeXParserListener, bl);
        this.initColors();
    }

    private void initColors() {
        this.definedColors = new HashMap();
        this.putColor("black", Color.BLACK);
        this.putColor("blue", Color.BLUE);
        this.putColor("cyan", Color.CYAN);
        this.putColor("gray", Color.GRAY);
        this.putColor("green", Color.GREEN);
        this.putColor("magenta", Color.MAGENTA);
        this.putColor("orange", Color.ORANGE);
        this.putColor("pink", Color.PINK);
        this.putColor("red", Color.RED);
        this.putColor("white", Color.WHITE);
        this.putColor("yellow", Color.YELLOW);
    }

    public void putColor(String string, Color color) {
        this.definedColors.put(string, color);
    }

    @Override
    public void addDefinitions() {
        this.addDeclaration(new ColorDeclaration(this), "textcolor");
        this.registerControlSequence(new ColorDeclaration(this, "pagecolor", false));
        this.registerControlSequence(new DefineColor(this));
    }

    protected void addDeclaration(Declaration declaration, String string) {
        this.registerControlSequence(declaration);
        this.registerControlSequence(new TextBlockCommand(string, declaration));
    }

    public Color getColor(TeXParser teXParser, String string, String string2) throws IOException {
        if (string.equals("named")) {
            Color color = this.definedColors.get(string2);
            if (color == null) {
                throw new LaTeXSyntaxException(teXParser, UNKNOWN, string2);
            }
            return color;
        }
        if (string.equals("rgb")) {
            String[] stringArray = string2.split(",", 3);
            if (stringArray.length != 3) {
                throw new LaTeXSyntaxException(teXParser, INVALID_SPECS, string2, string);
            }
            try {
                float f = Float.parseFloat(stringArray[0]);
                float f2 = Float.parseFloat(stringArray[1]);
                float f3 = Float.parseFloat(stringArray[2]);
                return new Color(f, f2, f3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new LaTeXSyntaxException((Throwable)numberFormatException, teXParser, INVALID_SPECS, string2, string);
            }
        }
        if (string.equals("gray")) {
            try {
                float f = Float.parseFloat(string2);
                return new Color(ColorSpace.getInstance(1003), new float[]{f}, 1.0f);
            }
            catch (NumberFormatException numberFormatException) {
                throw new LaTeXSyntaxException((Throwable)numberFormatException, teXParser, INVALID_SPECS, string2, string);
            }
        }
        throw new LaTeXSyntaxException(teXParser, UNSUPPORTED_COLOR, string, string2);
    }
}

