#ifndef _EFL_UI_ANCHOR_POPUP_EO_H_
#define _EFL_UI_ANCHOR_POPUP_EO_H_

#ifndef _EFL_UI_ANCHOR_POPUP_EO_CLASS_TYPE
#define _EFL_UI_ANCHOR_POPUP_EO_CLASS_TYPE

typedef Eo Efl_Ui_Anchor_Popup;

#endif

#ifndef _EFL_UI_ANCHOR_POPUP_EO_TYPES
#define _EFL_UI_ANCHOR_POPUP_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** EFL UI Anchor Popup class
 *
 * @ingroup Efl_Ui_Anchor_Popup
 */
#define EFL_UI_ANCHOR_POPUP_CLASS efl_ui_anchor_popup_class_get()

EWAPI const Efl_Class *efl_ui_anchor_popup_class_get(void);

/**
 * @brief Set anchor popup to follow an anchor object. If anchor object is
 * moved or parent window is resized, the anchor popup moves to the new
 * position. If anchor object is set to NULL, the anchor popup stops following
 * the anchor object. When the popup is moved by using gfx_position_set, anchor
 * is set NULL.
 *
 * @param[in] obj The object.
 * @param[in] anchor The object which popup is following.
 *
 * @ingroup Efl_Ui_Anchor_Popup
 */
EOAPI void efl_ui_anchor_popup_anchor_set(Eo *obj, Efl_Canvas_Object *anchor);

/**
 * @brief Returns the anchor object which the popup is following.
 *
 * @param[in] obj The object.
 *
 * @return The object which popup is following.
 *
 * @ingroup Efl_Ui_Anchor_Popup
 */
EOAPI Efl_Canvas_Object *efl_ui_anchor_popup_anchor_get(const Eo *obj);

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Set the align priority of a popup.
 *
 * @param[in] obj The object.
 * @param[in] first First align priority
 * @param[in] second Second align priority
 * @param[in] third Third align priority
 * @param[in] fourth Fourth align priority
 * @param[in] fifth Fifth align priority
 *
 * @ingroup Efl_Ui_Anchor_Popup
 */
EOAPI void efl_ui_anchor_popup_align_priority_set(Eo *obj, Efl_Ui_Popup_Align first, Efl_Ui_Popup_Align second, Efl_Ui_Popup_Align third, Efl_Ui_Popup_Align fourth, Efl_Ui_Popup_Align fifth);
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Get the align priority of a popup.
 *
 * @param[in] obj The object.
 * @param[out] first First align priority
 * @param[out] second Second align priority
 * @param[out] third Third align priority
 * @param[out] fourth Fourth align priority
 * @param[out] fifth Fifth align priority
 *
 * @ingroup Efl_Ui_Anchor_Popup
 */
EOAPI void efl_ui_anchor_popup_align_priority_get(const Eo *obj, Efl_Ui_Popup_Align *first, Efl_Ui_Popup_Align *second, Efl_Ui_Popup_Align *third, Efl_Ui_Popup_Align *fourth, Efl_Ui_Popup_Align *fifth);
#endif /* EFL_BETA_API_SUPPORT */
#endif /* EFL_BETA_API_SUPPORT */

#endif
