#ifndef _EFL_UI_DND_TYPES_EOT_H_
#define _EFL_UI_DND_TYPES_EOT_H_

#ifndef _EFL_UI_DND_TYPES_EOT_TYPES
#define _EFL_UI_DND_TYPES_EOT_TYPES

#ifdef EFL_BETA_API_SUPPORT
/** Function pointer for creating icon at the drag side.
 *
 * @ingroup Efl_Dnd
 */
typedef Efl_Canvas_Object * (*Efl_Dnd_Drag_Icon_Create)(void *data, Efl_Canvas_Object *win, Efl_Canvas_Object *drag_obj, Eina_Position2D *off);
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/** Function pointer for getting data and format at the drag side.
 *
 * @ingroup Efl_Dnd
 */
typedef void (*Efl_Dnd_Drag_Data_Get)(void *data, Efl_Canvas_Object *obj, Efl_Ui_Selection_Format *format, Eina_Rw_Slice *drag_data, Efl_Ui_Selection_Action *action);
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/** Function pointer to find out which item is under position (x, y)
 *
 * @ingroup Efl_Dnd
 */
typedef Efl_Object * (*Efl_Dnd_Item_Get)(void *data, Efl_Canvas_Object *obj, Eina_Position2D pos, Eina_Position2D *posret);
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/** Function pointer to create list of icons at the drag side. These icons are
 * used for animation on combining selection icons to one icon.
 *
 * @ingroup Efl_Dnd
 */
typedef Eina_List * (*Efl_Dnd_Drag_Icon_List_Create)(void *data, Efl_Canvas_Object *obj);
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
typedef struct _Efl_Dnd_Drag_Accept
{
  Eina_Bool accepted;
} Efl_Dnd_Drag_Accept;
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
typedef struct _Efl_Dnd_Drag_Pos
{
  Eina_Position2D pos; /**< Evas Coordinate */
  Efl_Ui_Selection_Action action; /**< The drag action */
  Efl_Ui_Selection_Format format; /**< The drag format */
  Efl_Canvas_Object *item; /**< The item object. It is only available for
                            * container object. */
} Efl_Dnd_Drag_Pos;
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
typedef struct _Efl_Dnd_Drag_Item_Container_Drop
{
  Efl_Canvas_Object *item; /**< The item object */
  Efl_Ui_Selection_Data data; /**< The selection data */
  Eina_Position2D pos; /**< Position relative to item (left (-1), middle (0),
                        * right (1) */
} Efl_Dnd_Drag_Item_Container_Drop;
#endif /* EFL_BETA_API_SUPPORT */


#endif

#endif
