/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.siunitx;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.siunitx.SIPrefixCs;
import com.dickimawbooks.texparserlib.latex.siunitx.SIUnitCs;
import com.dickimawbooks.texparserlib.latex.siunitx.SIunitxSty;
import java.io.IOException;

public class SiPower
extends ControlSequence {
    protected SIunitxSty sty;
    private int power;

    public SiPower(SIunitxSty sIunitxSty, String string, int n) {
        super(string);
        this.sty = sIunitxSty;
        this.power = n;
    }

    @Override
    public Object clone() {
        return new SiPower(this.sty, this.getName(), this.power);
    }

    public int getPower() {
        return this.power;
    }

    protected TeXObject getPowerObject(int n) {
        return new UserNumber(n);
    }

    protected void process(TeXParser teXParser, TeXObjectList teXObjectList, int n, TeXObject teXObject, TeXObject teXObject2) throws IOException {
        TeXObject teXObject3 = teXObjectList.peekStack();
        if (teXObject3 instanceof SIUnitCs) {
            teXObjectList.push(this.sty.createUnitSep(teXParser));
        }
        teXObjectList.push(this.getPowerObject(n));
        if (teXParser.isMathMode()) {
            teXObjectList.push(teXParser.getListener().createSpChar());
        } else {
            teXObjectList.push(new TeXCsRef("textsuperscript"));
        }
        teXObjectList.push(teXObject2);
        if (teXObject != null) {
            teXObjectList.push(teXObject);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObject teXObject = teXParser.popNextArg();
        int n = this.power;
        if (teXObject instanceof SiPower) {
            n *= ((SiPower)teXObject).getPower();
            teXObject = teXParser.popNextArg();
        }
        TeXObject teXObject2 = null;
        if (teXObject instanceof SIPrefixCs) {
            teXObject2 = teXObject;
            teXObject = teXParser.popNextArg();
        }
        this.process(teXParser, teXParser, n, teXObject2, teXObject);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = teXObjectList.popArg(teXParser);
        int n = this.power;
        if (teXObject instanceof SiPower) {
            n *= ((SiPower)teXObject).getPower();
            teXObject = teXObjectList.popArg(teXParser);
        }
        TeXObject teXObject2 = null;
        if (teXObject instanceof SIPrefixCs) {
            teXObject2 = teXObject;
            teXObject = teXObjectList.popArg(teXParser);
        }
        this.process(teXParser, teXObjectList, n, teXObject2, teXObject);
    }
}

