#ifndef _EFL_BOUNCE_INTERPOLATOR_EO_H_
#define _EFL_BOUNCE_INTERPOLATOR_EO_H_

#ifndef _EFL_BOUNCE_INTERPOLATOR_EO_CLASS_TYPE
#define _EFL_BOUNCE_INTERPOLATOR_EO_CLASS_TYPE

typedef Eo Efl_Bounce_Interpolator;

#endif

#ifndef _EFL_BOUNCE_INTERPOLATOR_EO_TYPES
#define _EFL_BOUNCE_INTERPOLATOR_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Efl bounce interpolator class
 *
 * @ingroup Efl_Bounce_Interpolator
 */
#define EFL_BOUNCE_INTERPOLATOR_CLASS efl_bounce_interpolator_class_get()

EWAPI const Efl_Class *efl_bounce_interpolator_class_get(void);

/**
 * @brief Factors property
 *
 * @param[in] obj The object.
 * @param[in] factor1 First factor of the interpolation function.
 * @param[in] factor2 Second factor of the interpolation function.
 *
 * @ingroup Efl_Bounce_Interpolator
 */
EOAPI void efl_bounce_interpolator_factors_set(Eo *obj, double factor1, double factor2);

/**
 * @brief Factors property
 *
 * @param[in] obj The object.
 * @param[out] factor1 First factor of the interpolation function.
 * @param[out] factor2 Second factor of the interpolation function.
 *
 * @ingroup Efl_Bounce_Interpolator
 */
EOAPI void efl_bounce_interpolator_factors_get(const Eo *obj, double *factor1, double *factor2);
#endif /* EFL_BETA_API_SUPPORT */

#endif
