#ifndef _EFL_GFX_IMAGE_LOAD_CONTROLLER_EO_H_
#define _EFL_GFX_IMAGE_LOAD_CONTROLLER_EO_H_

#ifndef _EFL_GFX_IMAGE_LOAD_CONTROLLER_EO_CLASS_TYPE
#define _EFL_GFX_IMAGE_LOAD_CONTROLLER_EO_CLASS_TYPE

typedef Eo Efl_Gfx_Image_Load_Controller;

#endif

#ifndef _EFL_GFX_IMAGE_LOAD_CONTROLLER_EO_TYPES
#define _EFL_GFX_IMAGE_LOAD_CONTROLLER_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Common APIs for all loadable 2D images.
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
#define EFL_GFX_IMAGE_LOAD_CONTROLLER_INTERFACE efl_gfx_image_load_controller_interface_get()

EWAPI const Efl_Class *efl_gfx_image_load_controller_interface_get(void);

/**
 * @brief Begin preloading an image object's image data in the background.
 *
 * Once the background task is complete the event @c load,done will be emitted.
 * @param[in] obj The object.
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
EOAPI void efl_gfx_image_load_controller_load_async_start(Eo *obj);

/**
 * @brief Cancel preloading an image object's image data in the background.
 *
 * The object should be left in a state where it has no image data. If cancel
 * is called too late, the image will be kept in memory.
 * @param[in] obj The object.
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
EOAPI void efl_gfx_image_load_controller_load_async_cancel(Eo *obj);

/**
 * @brief The load size of an image.
 *
 * The image will be loaded into memory as if it was the specified size instead
 * of its original size. This can save a lot of memory and is important for
 * scalable types like svg.
 *
 * By default, the load size is not specified, so it is 0x0.
 *
 * Requests the canvas to load the image at the given size.
 *
 * EFL will try to load an image of the requested size but does not guarantee
 * an exact match between the request and the loaded image dimensions.
 *
 * @param[in] obj The object.
 * @param[in] size The image load size.
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
EOAPI void efl_gfx_image_load_controller_load_size_set(Eo *obj, Eina_Size2D size);

/**
 * @brief The load size of an image.
 *
 * The image will be loaded into memory as if it was the specified size instead
 * of its original size. This can save a lot of memory and is important for
 * scalable types like svg.
 *
 * By default, the load size is not specified, so it is 0x0.
 *
 * Returns the requested load size.
 *
 * @param[in] obj The object.
 *
 * @return The image load size.
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
EOAPI Eina_Size2D efl_gfx_image_load_controller_load_size_get(const Eo *obj);

/**
 * @brief Set the DPI resolution of an image object's source image.
 *
 * This function sets the DPI resolution of a given loaded canvas image. Most
 * useful for the SVG image loader.
 *
 * @param[in] obj The object.
 * @param[in] dpi The DPI resolution.
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
EOAPI void efl_gfx_image_load_controller_load_dpi_set(Eo *obj, double dpi);

/**
 * @brief Get the DPI resolution of a loaded image object in the canvas.
 *
 * This function returns the DPI resolution of the given canvas image.
 *
 * @param[in] obj The object.
 *
 * @return The DPI resolution.
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
EOAPI double efl_gfx_image_load_controller_load_dpi_get(const Eo *obj);

/**
 * @brief Indicates whether the
 * @ref efl_gfx_image_load_controller_load_region_get property is supported for
 * the current file.
 *
 * @param[in] obj The object.
 *
 * @return @c true if region load of the image is supported, @c false otherwise
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
EOAPI Eina_Bool efl_gfx_image_load_controller_load_region_support_get(const Eo *obj);

/**
 * @brief Inform a given image object to load a selective region of its source
 * image.
 *
 * This function is useful when one is not showing all of an image's area on
 * its image object.
 *
 * @note The image loader for the image format in question has to support
 * selective region loading in order for this function to work.
 *
 * @param[in] obj The object.
 * @param[in] region A region of the image.
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
EOAPI void efl_gfx_image_load_controller_load_region_set(Eo *obj, Eina_Rect region);

/**
 * @brief Retrieve the coordinates of a given image object's selective (source
 * image) load region.
 *
 * @param[in] obj The object.
 *
 * @return A region of the image.
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
EOAPI Eina_Rect efl_gfx_image_load_controller_load_region_get(const Eo *obj);

/**
 * @brief Defines whether the orientation information in the image file should
 * be honored.
 *
 * The orientation can for instance be set in the EXIF tags of a JPEG image. If
 * this flag is @c false, then the orientation will be ignored at load time,
 * otherwise the image will be loaded with the proper orientation.
 *
 * @param[in] obj The object.
 * @param[in] enable @c true means that it should honor the orientation
 * information.
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
EOAPI void efl_gfx_image_load_controller_load_orientation_set(Eo *obj, Eina_Bool enable);

/**
 * @brief Defines whether the orientation information in the image file should
 * be honored.
 *
 * The orientation can for instance be set in the EXIF tags of a JPEG image. If
 * this flag is @c false, then the orientation will be ignored at load time,
 * otherwise the image will be loaded with the proper orientation.
 *
 * @param[in] obj The object.
 *
 * @return @c true means that it should honor the orientation information.
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
EOAPI Eina_Bool efl_gfx_image_load_controller_load_orientation_get(const Eo *obj);

/**
 * @brief The scale down factor is a divider on the original image size.
 *
 * Setting the scale down factor can reduce load time and memory usage at the
 * cost of having a scaled down image in memory.
 *
 * This function sets the scale down factor of a given canvas image. Most
 * useful for the SVG image loader but also applies to JPEG, PNG and BMP.
 *
 * Powers of two (2, 4, 8) are best supported (especially with JPEG)
 *
 * Requests the image loader to scale down by @c div times. Call this before
 * starting the actual image load.
 *
 * @param[in] obj The object.
 * @param[in] div The scale down dividing factor.
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
EOAPI void efl_gfx_image_load_controller_load_scale_down_set(Eo *obj, int div);

/**
 * @brief The scale down factor is a divider on the original image size.
 *
 * Setting the scale down factor can reduce load time and memory usage at the
 * cost of having a scaled down image in memory.
 *
 * This function sets the scale down factor of a given canvas image. Most
 * useful for the SVG image loader but also applies to JPEG, PNG and BMP.
 *
 * Powers of two (2, 4, 8) are best supported (especially with JPEG)
 *
 * @param[in] obj The object.
 *
 * @return The scale down dividing factor.
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
EOAPI int efl_gfx_image_load_controller_load_scale_down_get(const Eo *obj);

/**
 * @brief Initial load should skip header check and leave it all to data load
 *
 * If this is true, then future loads of images will defer header loading to a
 * preload stage and/or data load later on rather than at the start when the
 * load begins (e.g. when file is set).
 *
 * Set the skip header state for susbsequent loads of a file.
 *
 * @param[in] obj The object.
 * @param[in] skip Will be true if header is to be skipped.
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
EOAPI void efl_gfx_image_load_controller_load_skip_header_set(Eo *obj, Eina_Bool skip);

/**
 * @brief Initial load should skip header check and leave it all to data load
 *
 * If this is true, then future loads of images will defer header loading to a
 * preload stage and/or data load later on rather than at the start when the
 * load begins (e.g. when file is set).
 *
 * @param[in] obj The object.
 *
 * @return Will be true if header is to be skipped.
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
EOAPI Eina_Bool efl_gfx_image_load_controller_load_skip_header_get(const Eo *obj);

EWAPI extern const Efl_Event_Description _EFL_GFX_IMAGE_LOAD_CONTROLLER_EVENT_LOAD_DONE;

/** Called when he image was loaded
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
#define EFL_GFX_IMAGE_LOAD_CONTROLLER_EVENT_LOAD_DONE (&(_EFL_GFX_IMAGE_LOAD_CONTROLLER_EVENT_LOAD_DONE))

EWAPI extern const Efl_Event_Description _EFL_GFX_IMAGE_LOAD_CONTROLLER_EVENT_LOAD_ERROR;

/** Called when an error happened during image loading
 * @return Eina_Error
 *
 * @ingroup Efl_Gfx_Image_Load_Controller
 */
#define EFL_GFX_IMAGE_LOAD_CONTROLLER_EVENT_LOAD_ERROR (&(_EFL_GFX_IMAGE_LOAD_CONTROLLER_EVENT_LOAD_ERROR))
#endif /* EFL_BETA_API_SUPPORT */

#endif
