#ifndef _EFL_PACK_LAYOUT_EO_H_
#define _EFL_PACK_LAYOUT_EO_H_

#ifndef _EFL_PACK_LAYOUT_EO_CLASS_TYPE
#define _EFL_PACK_LAYOUT_EO_CLASS_TYPE

typedef Eo Efl_Pack_Layout;

#endif

#ifndef _EFL_PACK_LAYOUT_EO_TYPES
#define _EFL_PACK_LAYOUT_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Low-level APIs for object that can lay their children out.
 *
 * Used for containers (box, grid).
 *
 * @ingroup Efl_Pack_Layout
 */
#define EFL_PACK_LAYOUT_INTERFACE efl_pack_layout_interface_get()

EWAPI const Efl_Class *efl_pack_layout_interface_get(void);

/**
 * @brief Requests EFL to call the @ref efl_pack_layout_update method on this
 * object.
 *
 * This @ref efl_pack_layout_update may be called asynchronously.
 * @param[in] obj The object.
 *
 * @ingroup Efl_Pack_Layout
 */
EOAPI void efl_pack_layout_request(Eo *obj);

#ifdef EFL_PACK_LAYOUT_PROTECTED
/**
 * @brief Implementation of this container's layout algorithm.
 *
 * EFL will call this function whenever the contents of this container need to
 * be re-laid out on the canvas.
 *
 * This can be overriden to implement custom layout behaviors.
 * @param[in] obj The object.
 *
 * @ingroup Efl_Pack_Layout
 */
EOAPI void efl_pack_layout_update(Eo *obj);
#endif

EWAPI extern const Efl_Event_Description _EFL_PACK_EVENT_LAYOUT_UPDATED;

/** Sent after the layout was updated.
 *
 * @ingroup Efl_Pack_Layout
 */
#define EFL_PACK_EVENT_LAYOUT_UPDATED (&(_EFL_PACK_EVENT_LAYOUT_UPDATED))
#endif /* EFL_BETA_API_SUPPORT */

#endif
