/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs.remember;

import net.sourceforge.jnlp.runtime.Translator;

public enum ExecuteAppletAction {
    ALWAYS,
    NEVER,
    YES,
    NO;


    public String toChar() {
        switch (this) {
            case ALWAYS: {
                return "A";
            }
            case YES: {
                return "y";
            }
            case NEVER: {
                return "N";
            }
            case NO: {
                return "n";
            }
        }
        throw new RuntimeException("Unknown ExecuteUnsignedApplet");
    }

    public String toExplanation() {
        switch (this) {
            case ALWAYS: {
                return Translator.R("APPEXTSECunsignedAppletActionAlways");
            }
            case NEVER: {
                return Translator.R("APPEXTSECunsignedAppletActionNever");
            }
            case YES: {
                return Translator.R("APPEXTSECunsignedAppletActionYes");
            }
            case NO: {
                return Translator.R("APPEXTSECunsignedAppletActionNo");
            }
        }
        throw new RuntimeException("Unknown UnsignedAppletAction");
    }

    public static ExecuteAppletAction fromString(String s) {
        if (s.length() == 0) {
            throw new RuntimeException("Undefined zero-length ExecuteAppletAction String representatio");
        }
        return ExecuteAppletAction.fromChar(s.charAt(0));
    }

    public static ExecuteAppletAction fromChar(char s) {
        switch (s) {
            case 'A': {
                return ALWAYS;
            }
            case 'N': {
                return NEVER;
            }
            case 'y': {
                return YES;
            }
            case 'n': {
                return NO;
            }
        }
        throw new RuntimeException("Unknown ExecuteUnsignedApplet for " + s);
    }

    public String toString() {
        return this.toChar() + " - " + this.toExplanation();
    }
}

