/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.model;

import com.github.cereda.arara.model.FileTypeResource;
import com.github.cereda.arara.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang.SystemUtils;
import org.mvel2.templates.TemplateRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource {
    private List<String> paths;
    private List<FileTypeResource> filetypes;
    private String language;
    private long loops;
    private boolean verbose;
    private boolean logging;
    private String dbname;
    private String logname;
    private boolean header;
    private Map<String, String> preambles;
    private String laf;

    public List<String> getPaths() {
        if (this.paths != null) {
            final HashMap map = new HashMap();
            HashMap<String, String> user = new HashMap<String, String>();
            user.put("home", SystemUtils.USER_HOME);
            user.put("dir", SystemUtils.USER_DIR);
            user.put("name", SystemUtils.USER_NAME);
            map.put("user", user);
            Collection<String> result = CollectionUtils.collect(this.paths, new Transformer<String, String>(){

                @Override
                public String transform(String input) {
                    String path = CommonUtils.removeKeyword(input);
                    try {
                        path = (String)TemplateRuntime.eval(path, map);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    return path;
                }
            });
            this.paths = new ArrayList<String>(result);
        }
        return this.paths;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public List<FileTypeResource> getFiletypes() {
        return this.filetypes;
    }

    public void setFiletypes(List<FileTypeResource> filetypes) {
        this.filetypes = filetypes;
    }

    public String getLanguage() {
        return CommonUtils.removeKeyword(this.language);
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public long getLoops() {
        return this.loops;
    }

    public void setLoops(long loops) {
        this.loops = loops;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    public String getDbname() {
        return CommonUtils.removeKeyword(this.dbname);
    }

    public void setDbname(String dbname) {
        this.dbname = dbname;
    }

    public String getLogname() {
        return CommonUtils.removeKeyword(this.logname);
    }

    public void setLogname(String logname) {
        this.logname = logname;
    }

    public Map<String, String> getPreambles() {
        return this.preambles;
    }

    public void setPreambles(Map<String, String> preambles) {
        this.preambles = preambles;
    }

    public boolean isHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public String getLaf() {
        return CommonUtils.removeKeyword(this.laf);
    }

    public void setLaf(String laf) {
        this.laf = laf;
    }
}

