/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.math.ec.rfc8032.Ed25519;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;

public class BcTlsEd25519Signer
extends BcTlsSigner {
    protected final Ed25519PublicKeyParameters publicKey;

    public BcTlsEd25519Signer(BcTlsCrypto bcTlsCrypto, Ed25519PrivateKeyParameters ed25519PrivateKeyParameters, Ed25519PublicKeyParameters ed25519PublicKeyParameters) {
        super(bcTlsCrypto, (AsymmetricKeyParameter)ed25519PrivateKeyParameters);
        this.publicKey = ed25519PublicKeyParameters != null ? ed25519PublicKeyParameters : ed25519PrivateKeyParameters.generatePublicKey();
    }

    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (signatureAndHashAlgorithm == null || signatureAndHashAlgorithm.getSignature() != 7 || signatureAndHashAlgorithm.getHash() != 8) {
            throw new IllegalStateException();
        }
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        return new TlsStreamSigner(){

            public OutputStream getOutputStream() {
                return byteArrayOutputStream;
            }

            public byte[] getSignature() throws IOException {
                byte[] byArray = new byte[32];
                ((Ed25519PrivateKeyParameters)BcTlsEd25519Signer.this.privateKey).encode(byArray, 0);
                byte[] byArray2 = BcTlsEd25519Signer.this.publicKey.getEncoded();
                byte[] byArray3 = byteArrayOutputStream.toByteArray();
                byte[] byArray4 = new byte[64];
                Ed25519.sign((byte[])byArray, (int)0, (byte[])byArray2, (int)0, (byte[])byArray3, (int)0, (int)byArray3.length, (byte[])byArray4, (int)0);
                Arrays.fill(byArray, (byte)0);
                return byArray4;
            }
        };
    }
}

