/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedFieldDescriptor;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedVariableDescriptor;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.MoveCompanionObjectFieldsLowering;
import org.jetbrains.kotlin.backend.jvm.lower.MoveCompanionObjectFieldsLoweringKt;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrAnonymousInitializerImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFieldImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrAnonymousInitializerSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J$\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J6\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020\u000bH\u0002J\u001c\u0010 \u001a\u00020!*\u00020!2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/MoveCompanionObjectFieldsLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "createStaticBackingField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "oldField", "propertyParent", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "fieldParent", "handleClass", "", "irClass", "fieldReplacementMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "handleObject", "irObject", "lower", "moveAnonymousInitializerToStaticParent", "Lorg/jetbrains/kotlin/ir/declarations/IrAnonymousInitializer;", "oldInitializer", "oldParent", "newParent", "movePropertyFieldToStaticParent", "irProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "allFieldsAreJvmField", "", "transferToNewParent", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "backend.jvm"})
final class MoveCompanionObjectFieldsLowering
implements ClassLoweringPass {
    @NotNull
    private final CommonBackendContext context;

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull(irClass, "irClass");
        boolean bl = false;
        Map fieldReplacementMap = new LinkedHashMap();
        if (IrUtilsKt.isObject(irClass) && !irClass.isCompanion() && Intrinsics.areEqual(irClass.getVisibility(), Visibilities.LOCAL) ^ true) {
            this.handleObject(irClass, fieldReplacementMap);
        } else {
            this.handleClass(irClass, fieldReplacementMap);
        }
        MoveCompanionObjectFieldsLoweringKt.access$replaceFieldReferences(irClass, fieldReplacementMap);
    }

    private final void handleObject(IrClass irObject, Map<IrFieldSymbol, IrFieldSymbol> fieldReplacementMap) {
        irObject.getDeclarations().replaceAll(new UnaryOperator<E>(this, irObject, fieldReplacementMap){
            final /* synthetic */ MoveCompanionObjectFieldsLowering this$0;
            final /* synthetic */ IrClass $irObject;
            final /* synthetic */ Map $fieldReplacementMap;

            @NotNull
            public final IrDeclaration apply(@NotNull IrDeclaration it) {
                IrDeclaration irDeclaration;
                Intrinsics.checkParameterIsNotNull(it, "it");
                IrDeclaration irDeclaration2 = it;
                if (irDeclaration2 instanceof IrProperty) {
                    MoveCompanionObjectFieldsLowering.access$movePropertyFieldToStaticParent(this.this$0, (IrProperty)it, this.$irObject, this.$irObject, this.$fieldReplacementMap);
                    irDeclaration = it;
                } else {
                    irDeclaration = irDeclaration2 instanceof IrAnonymousInitializer ? (IrDeclaration)MoveCompanionObjectFieldsLowering.access$moveAnonymousInitializerToStaticParent(this.this$0, (IrAnonymousInitializer)it, this.$irObject, this.$irObject) : it;
                }
                return irDeclaration;
            }
            {
                this.this$0 = moveCompanionObjectFieldsLowering;
                this.$irObject = irClass;
                this.$fieldReplacementMap = map2;
            }
        });
    }

    private final void handleClass(IrClass irClass, Map<IrFieldSymbol, IrFieldSymbol> fieldReplacementMap) {
        Object v0;
        block5: {
            Iterable iterable = irClass.getDeclarations();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            Iterator iterator2 = iterable2.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                IrDeclaration it = (IrDeclaration)t;
                boolean bl3 = false;
                if (!(it instanceof IrClass && ((IrClass)it).isCompanion())) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        IrClass irClass2 = v0;
        if (irClass2 == null) {
            return;
        }
        IrClass companion = irClass2;
        if ((IrUtilsKt.isInterface(irClass) || IrUtilsKt.isAnnotationClass(irClass)) && !this.allFieldsAreJvmField(companion)) {
            return;
        }
        Iterable $this$forEach$iv = companion.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            IrDeclaration irDeclaration = it;
            if (irDeclaration instanceof IrProperty) {
                IrField newField = this.movePropertyFieldToStaticParent((IrProperty)it, companion, irClass, fieldReplacementMap);
                if (newField == null) continue;
                irClass.getDeclarations().add(newField);
                continue;
            }
            if (!(irDeclaration instanceof IrAnonymousInitializer)) continue;
            IrAnonymousInitializer newInitializer = this.moveAnonymousInitializerToStaticParent((IrAnonymousInitializer)it, companion, irClass);
            irClass.getDeclarations().add(newInitializer);
        }
        CollectionsKt.removeAll(companion.getDeclarations(), (Function1)handleClass.2.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean allFieldsAreJvmField(@NotNull IrClass $this$allFieldsAreJvmField) {
        boolean bl;
        block5: {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = $this$allFieldsAreJvmField.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrProperty)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IrField irField;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                IrProperty it = (IrProperty)element$iv$iv;
                boolean bl3 = false;
                if (it.getBackingField() == null) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                IrField it$iv$iv = irField;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$all$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    IrField it = (IrField)element$iv;
                    boolean bl7 = false;
                    IrAnnotationContainer irAnnotationContainer = it;
                    FqName fqName2 = JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME;
                    Intrinsics.checkExpressionValueIsNotNull(fqName2, "JVM_FIELD_ANNOTATION_FQ_NAME");
                    if (IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName2)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final IrField movePropertyFieldToStaticParent(IrProperty irProperty, IrClass propertyParent, IrClass fieldParent, Map<IrFieldSymbol, IrFieldSymbol> fieldReplacementMap) {
        if (Intrinsics.areEqual(irProperty.getOrigin(), IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE)) {
            return null;
        }
        IrField irField = irProperty.getBackingField();
        if (irField == null) {
            return null;
        }
        IrField oldField = irField;
        IrField newField = this.createStaticBackingField(oldField, propertyParent, fieldParent);
        irProperty.setBackingField(newField);
        newField.setCorrespondingPropertySymbol(irProperty.getSymbol());
        fieldReplacementMap.put((IrFieldSymbol)oldField.getSymbol(), (IrFieldSymbol)newField.getSymbol());
        return newField;
    }

    private final IrAnonymousInitializer moveAnonymousInitializerToStaticParent(IrAnonymousInitializer oldInitializer, IrClass oldParent, IrClass newParent) {
        boolean bl = false;
        boolean bl2 = false;
        IrAnonymousInitializer $this$with = oldInitializer;
        boolean bl3 = false;
        IrAnonymousInitializerImpl irAnonymousInitializerImpl = new IrAnonymousInitializerImpl($this$with.getStartOffset(), $this$with.getEndOffset(), $this$with.getOrigin(), new IrAnonymousInitializerSymbolImpl((IrClassSymbol)newParent.getSymbol()), true);
        boolean bl4 = false;
        boolean bl5 = false;
        IrAnonymousInitializerImpl $this$apply = irAnonymousInitializerImpl;
        boolean bl6 = false;
        $this$apply.setParent(newParent);
        $this$apply.setBody(this.transferToNewParent(oldInitializer.getBody(), oldParent, newParent));
        return irAnonymousInitializerImpl;
    }

    private final IrBlockBody transferToNewParent(@NotNull IrBlockBody $this$transferToNewParent, IrClass oldParent, IrClass newParent) {
        IrField objectInstanceField = this.context.getDeclarationFactory().getFieldForObjectInstance(oldParent);
        IrElementTransformer irElementTransformer = new IrElementTransformerVoid(oldParent, newParent, objectInstanceField){
            @NotNull
            private final Map<IrVariable, IrVariable> variableMap;
            final /* synthetic */ IrClass $oldParent;
            final /* synthetic */ IrClass $newParent;
            final /* synthetic */ IrField $objectInstanceField;

            @NotNull
            public final Map<IrVariable, IrVariable> getVariableMap() {
                return this.variableMap;
            }

            @NotNull
            public IrStatement visitVariable(@NotNull IrVariable declaration2) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                if (Intrinsics.areEqual(declaration2.getParent(), this.$oldParent)) {
                    Annotations annotations2 = declaration2.getDescriptor().getAnnotations();
                    SourceElement sourceElement = declaration2.getDescriptor().getSource();
                    Intrinsics.checkExpressionValueIsNotNull(sourceElement, "declaration.descriptor.source");
                    WrappedVariableDescriptor newDescriptor2 = new WrappedVariableDescriptor(annotations2, sourceElement);
                    IrVariableImpl irVariableImpl = new IrVariableImpl(declaration2.getStartOffset(), declaration2.getEndOffset(), declaration2.getOrigin(), new IrVariableSymbolImpl(newDescriptor2), declaration2.getName(), declaration2.getType(), declaration2.isVar(), declaration2.isConst(), declaration2.isLateinit());
                    boolean bl = false;
                    boolean bl2 = false;
                    IrVariableImpl $this$apply = irVariableImpl;
                    boolean bl3 = false;
                    newDescriptor2.bind((IrDeclaration)$this$apply);
                    $this$apply.setParent(this.$newParent);
                    $this$apply.setInitializer(declaration2.getInitializer());
                    $this$apply.getAnnotations().addAll((Collection<IrConstructorCall>)declaration2.getAnnotations());
                    IrVariableImpl newVariable = irVariableImpl;
                    this.variableMap.put(declaration2, newVariable);
                    return super.visitVariable(newVariable);
                }
                return super.visitVariable(declaration2);
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                if (Intrinsics.areEqual(expression2.getSymbol().getOwner(), this.$oldParent.getThisReceiver())) {
                    return new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), (IrFieldSymbol)this.$objectInstanceField.getSymbol(), expression2.getType(), null, null, 48, null);
                }
                Object object = this.variableMap;
                IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
                boolean bl = false;
                IrVariable irVariable2 = object.get(irValueDeclaration);
                if (irVariable2 != null) {
                    object = irVariable2;
                    boolean bl2 = false;
                    bl = false;
                    Object newVariable = object;
                    boolean bl3 = false;
                    return new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), (IrValueSymbol)newVariable.getSymbol(), expression2.getOrigin());
                }
                return super.visitGetValue(expression2);
            }
            {
                Map map2;
                this.$oldParent = $captured_local_variable$0;
                this.$newParent = $captured_local_variable$1;
                this.$objectInstanceField = $captured_local_variable$2;
                transferToNewParent.1 var5_4 = this;
                boolean bl = false;
                var5_4.variableMap = map2 = (Map)new LinkedHashMap<K, V>();
            }
        };
        Object d = null;
        IrBody irBody = $this$transferToNewParent.transform(irElementTransformer, d);
        if (irBody == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
        }
        return (IrBlockBody)irBody;
    }

    private final IrField createStaticBackingField(IrField oldField, IrClass propertyParent, IrClass fieldParent) {
        Annotations annotations2 = oldField.getDescriptor().getAnnotations();
        SourceElement sourceElement = oldField.getDescriptor().getSource();
        Intrinsics.checkExpressionValueIsNotNull(sourceElement, "oldField.descriptor.source");
        WrappedFieldDescriptor descriptor2 = new WrappedFieldDescriptor(annotations2, sourceElement);
        IrFieldImpl irFieldImpl = new IrFieldImpl(oldField.getStartOffset(), oldField.getEndOffset(), IrDeclarationOrigin.PROPERTY_BACKING_FIELD.INSTANCE, new IrFieldSymbolImpl(descriptor2), oldField.getName(), oldField.getType(), oldField.getVisibility(), oldField.isFinal(), oldField.isExternal(), true);
        boolean bl = false;
        boolean bl2 = false;
        IrFieldImpl $this$apply = irFieldImpl;
        boolean bl3 = false;
        descriptor2.bind((IrDeclaration)$this$apply);
        $this$apply.setParent(fieldParent);
        $this$apply.getAnnotations().addAll((Collection<IrConstructorCall>)oldField.getAnnotations());
        $this$apply.setMetadata(oldField.getMetadata());
        IrFieldImpl field2 = irFieldImpl;
        IrExpressionBody oldInitializer = oldField.getInitializer();
        if (oldInitializer != null) {
            IrBody irBody = oldInitializer;
            IrValueParameter irValueParameter = propertyParent.getThisReceiver();
            if (irValueParameter == null) {
                Intrinsics.throwNpe();
            }
            IrElement irElement = PatchDeclarationParentsKt.patchDeclarationParents((IrElement)LowerUtilsKt.replaceThisByStaticReference(irBody, this.context, propertyParent, irValueParameter), field2);
            if (irElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpressionBody");
            }
            field2.setInitializer((IrExpressionBody)irElement);
        }
        return field2;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public MoveCompanionObjectFieldsLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }

    public static final /* synthetic */ IrField access$movePropertyFieldToStaticParent(MoveCompanionObjectFieldsLowering $this, IrProperty irProperty, IrClass propertyParent, IrClass fieldParent, Map fieldReplacementMap) {
        return $this.movePropertyFieldToStaticParent(irProperty, propertyParent, fieldParent, fieldReplacementMap);
    }

    public static final /* synthetic */ IrAnonymousInitializer access$moveAnonymousInitializerToStaticParent(MoveCompanionObjectFieldsLowering $this, IrAnonymousInitializer oldInitializer, IrClass oldParent, IrClass newParent) {
        return $this.moveAnonymousInitializerToStaticParent(oldInitializer, oldParent, newParent);
    }
}

