/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import net.sourceforge.jnlp.security.KeyStores;
import net.sourceforge.jnlp.security.KeystorePasswordAttempter;
import net.sourceforge.jnlp.util.logging.OutputController;

public class SecurityUtil {
    public static String getTrustedCertsFilename() throws Exception {
        return KeyStores.getKeyStoreLocation(KeyStores.Level.USER, KeyStores.Type.CERTS).getFullPath();
    }

    public static String getCN(String principal) {
        int start = principal.indexOf("CN=");
        if (start == -1) {
            return principal;
        }
        StringBuilder commonName = new StringBuilder();
        boolean inQuotes = false;
        boolean escaped = false;
        char[] hexBits = null;
        block5: for (int i = start + 3; i < principal.length(); ++i) {
            char ch = principal.charAt(i);
            switch (ch) {
                case '\"': {
                    if (escaped) {
                        commonName.append(ch);
                        escaped = false;
                        continue block5;
                    }
                    inQuotes = !inQuotes;
                    continue block5;
                }
                case '\\': {
                    if (escaped) {
                        commonName.append(ch);
                        escaped = false;
                        continue block5;
                    }
                    escaped = true;
                    continue block5;
                }
                case '+': 
                case ',': 
                case ';': {
                    if (escaped || inQuotes) {
                        commonName.append(ch);
                        if (!escaped) continue block5;
                        escaped = false;
                        continue block5;
                    }
                    return commonName.toString();
                }
                default: {
                    if (escaped && SecurityUtil.isHexDigit(ch)) {
                        hexBits = new char[2];
                        hexBits[0] = ch;
                    } else if (hexBits != null) {
                        if (!SecurityUtil.isHexDigit(ch)) {
                            return "";
                        }
                        hexBits[1] = ch;
                        commonName.append((char)Integer.parseInt(new String(hexBits), 16));
                        hexBits = null;
                    } else {
                        commonName.append(ch);
                    }
                    escaped = false;
                }
            }
        }
        return commonName.toString();
    }

    private static boolean isHexDigit(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
    }

    public static boolean checkTrustedCertsFile() throws Exception {
        File certFile = new File(SecurityUtil.getTrustedCertsFilename());
        if (!certFile.isFile()) {
            File dir = certFile.getAbsoluteFile().getParentFile();
            boolean madeDir = false;
            if (!dir.isDirectory()) {
                madeDir = dir.mkdirs();
            }
            if (madeDir || dir.isDirectory()) {
                KeyStore ks = KeyStore.getInstance("JKS");
                SecurityUtil.loadKeyStore(ks, null);
                SecurityUtil.storeKeyStore(ks, certFile);
                return true;
            }
            return false;
        }
        return true;
    }

    public static KeyStore getUserKeyStore() throws Exception {
        KeyStore ks = null;
        FileInputStream fis = null;
        if (SecurityUtil.checkTrustedCertsFile()) {
            try {
                File file = new File(SecurityUtil.getTrustedCertsFilename());
                if (file.exists()) {
                    ks = KeyStore.getInstance("JKS");
                    SecurityUtil.loadKeyStore(ks, file);
                }
            }
            catch (Exception e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
                throw e;
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        return ks;
    }

    public static KeyStore getCacertsKeyStore() throws Exception {
        KeyStore caks = null;
        try (FileInputStream fis = null;){
            File file = new File(System.getProperty("java.home") + "/lib/security/cacerts");
            if (file.exists()) {
                fis = new FileInputStream(file);
                caks = KeyStore.getInstance("JKS");
                caks.load(fis, null);
            }
        }
        return caks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getSystemCertStore() throws Exception {
        KeyStore caks = null;
        try (FileInputStream fis = null;){
            File file = new File(System.getProperty("javax.net.ssl.trustStore"));
            String type = System.getProperty("javax.net.ssl.trustStoreType");
            char[] password = System.getProperty("javax.net.ssl.trustStorePassword").toCharArray();
            if (file.exists()) {
                fis = new FileInputStream(file);
                caks = KeyStore.getInstance(type);
                caks.load(fis, password);
            }
        }
        return caks;
    }

    public static void initKeyManagerFactory(KeyManagerFactory kmf, KeyStore ks) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            KeystorePasswordAttempter.INSTANCE.unlockKeystore(new KeystorePasswordAttempter.KeystoreOperation(kmf, ks){

                @Override
                String getId() {
                    return "'init keymanager-factory'";
                }

                @Override
                Key operateKeystore(char[] pass) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, CertificateException {
                    this.kmf.init(this.ks, pass);
                    return null;
                }
            });
        }
        catch (IOException | CertificateException ex) {
            throw SecurityUtil.unexpectedException(ex);
        }
    }

    public static void setKeyEntry(KeyStore ks, String alias, Key key, Certificate[] certChain) throws KeyStoreException {
        try {
            KeystorePasswordAttempter.INSTANCE.unlockKeystore(new KeystorePasswordAttempter.KeystoreOperation(ks, alias, key, certChain){

                @Override
                String getId() {
                    return "'set key entry'";
                }

                @Override
                Key operateKeystore(char[] pass) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, CertificateException {
                    this.ks.setKeyEntry(this.alias, this.key, pass, this.certChain);
                    return null;
                }
            });
        }
        catch (IOException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            throw SecurityUtil.unexpectedException(ex);
        }
    }

    public static Key getKey(KeyStore ks, String alias) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            return KeystorePasswordAttempter.INSTANCE.unlockKeystore(new KeystorePasswordAttempter.KeystoreOperation(ks, alias, null, null){

                @Override
                String getId() {
                    return "'get key'";
                }

                @Override
                Key operateKeystore(char[] pass) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, CertificateException {
                    return this.ks.getKey(this.alias, pass);
                }
            });
        }
        catch (IOException | CertificateException ex) {
            throw SecurityUtil.unexpectedException(ex);
        }
    }

    public static void loadKeyStore(KeyStore ks, File f) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            KeystorePasswordAttempter.INSTANCE.unlockKeystore(new KeystorePasswordAttempter.KeystoreOperation(ks, f){

                @Override
                String getId() {
                    return "'load keystore'";
                }

                @Override
                Key operateKeystore(char[] pass) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, CertificateException {
                    if (this.f == null) {
                        this.ks.load(null, pass);
                    } else {
                        try (FileInputStream fis = new FileInputStream(this.f);){
                            this.ks.load(fis, pass);
                        }
                    }
                    return null;
                }
            });
        }
        catch (KeyStoreException | UnrecoverableKeyException ex) {
            throw SecurityUtil.unexpectedException(ex);
        }
    }

    public static void storeKeyStore(KeyStore ks, File f) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        try {
            KeystorePasswordAttempter.INSTANCE.unlockKeystore(new KeystorePasswordAttempter.KeystoreOperation(ks, f){

                @Override
                String getId() {
                    return "'store keystore'";
                }

                @Override
                Key operateKeystore(char[] pass) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, CertificateException {
                    if (this.f == null) {
                        this.ks.store(null, pass);
                    } else {
                        try (FileOutputStream fos = new FileOutputStream(this.f);){
                            this.ks.store(fos, pass);
                        }
                    }
                    return null;
                }
            });
        }
        catch (UnrecoverableKeyException ex) {
            throw SecurityUtil.unexpectedException(ex);
        }
    }

    private static RuntimeException unexpectedException(Exception ex) {
        return new RuntimeException("This usage of KeystorePasswordAttempter shopuld not throw this kind of exception", ex);
    }
}

