/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin.dynamic;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.DirectedSubgraph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Subgraph;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalIntegerMap;
import org.gephi.graph.api.types.TimestampIntegerMap;
import org.gephi.statistics.plugin.ChartUtils;
import org.gephi.statistics.spi.DynamicStatistics;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DynamicDegree
implements DynamicStatistics,
LongTask {
    public static final String DYNAMIC_AVGDEGREE = "dynamic_avgdegree";
    public static final String DYNAMIC_INDEGREE = "dynamic_indegree";
    public static final String DYNAMIC_OUTDEGREE = "dynamic_outdegree";
    public static final String DYNAMIC_DEGREE = "dynamic_degree";
    private GraphModel graphModel;
    private double window;
    private double tick;
    private Interval bounds;
    private boolean isDirected;
    private boolean averageOnly;
    private boolean cancel = false;
    private Column dynamicInDegreeColumn;
    private Column dynamicOutDegreeColumn;
    private Column dynamicDegreeColumn;
    private Map<Double, Double> averages;

    public DynamicDegree() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getGraphModel() != null) {
            this.isDirected = graphController.getGraphModel().isDirected();
        }
    }

    public void execute(GraphModel graphModel) {
        this.graphModel = graphModel;
        this.isDirected = graphModel.isDirected();
        this.averages = new HashMap<Double, Double>();
        if (!this.averageOnly) {
            TimeRepresentation tr = graphModel.getConfiguration().getTimeRepresentation();
            Table nodeTable = graphModel.getNodeTable();
            this.dynamicInDegreeColumn = nodeTable.getColumn(DYNAMIC_INDEGREE);
            this.dynamicOutDegreeColumn = nodeTable.getColumn(DYNAMIC_OUTDEGREE);
            this.dynamicDegreeColumn = nodeTable.getColumn(DYNAMIC_DEGREE);
            if (this.isDirected) {
                if (this.dynamicInDegreeColumn == null) {
                    this.dynamicInDegreeColumn = nodeTable.addColumn(DYNAMIC_INDEGREE, NbBundle.getMessage(DynamicDegree.class, (String)"DynamicDegree.nodecolumn.InDegree"), tr.equals((Object)TimeRepresentation.INTERVAL) ? IntervalIntegerMap.class : TimestampIntegerMap.class, null);
                }
                if (this.dynamicOutDegreeColumn == null) {
                    this.dynamicOutDegreeColumn = nodeTable.addColumn(DYNAMIC_OUTDEGREE, NbBundle.getMessage(DynamicDegree.class, (String)"DynamicDegree.nodecolumn.OutDegree"), tr.equals((Object)TimeRepresentation.INTERVAL) ? IntervalIntegerMap.class : TimestampIntegerMap.class, null);
                }
            }
            if (this.dynamicDegreeColumn == null) {
                this.dynamicDegreeColumn = nodeTable.addColumn(DYNAMIC_DEGREE, NbBundle.getMessage(DynamicDegree.class, (String)"DynamicDegree.nodecolumn.Degree"), tr.equals((Object)TimeRepresentation.INTERVAL) ? IntervalIntegerMap.class : TimestampIntegerMap.class, null);
            }
        }
    }

    public String getReport() {
        XYSeries dSeries = ChartUtils.createXYSeries(this.averages, "Degree Time Series");
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(dSeries);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Degree Time Series", (String)"Time", (String)"Average Degree", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.removeLegend();
        ChartUtils.decorateChart(chart);
        ChartUtils.scaleChart(chart, dSeries, false);
        String degreeImageFile = ChartUtils.renderChart(chart, "degree-ts.png");
        DecimalFormat f = new DecimalFormat("#0.000000");
        String report = "<HTML> <BODY> <h1>Dynamic Degree Report </h1> <hr><br> Bounds: from " + f.format(this.bounds.getLow()) + " to " + f.format(this.bounds.getHigh()) + "<br> Window: " + this.window + "<br> Tick: " + this.tick + "<br><br><h2> Average degrees over time: </h2><br /><br />" + degreeImageFile;
        report = report + "<br /><br /></BODY></HTML>";
        return report;
    }

    public void loop(GraphView window, Interval interval) {
        Subgraph graph = this.graphModel.getGraph(window);
        DirectedSubgraph directedGraph = null;
        if (this.isDirected) {
            directedGraph = this.graphModel.getDirectedGraph(window);
        }
        TimeRepresentation tr = this.graphModel.getConfiguration().getTimeRepresentation();
        long sum = 0L;
        for (Node n : graph.getNodes().toArray()) {
            int degree = graph.getDegree(n);
            if (!this.averageOnly) {
                switch (tr) {
                    case INTERVAL: {
                        n.setAttribute(this.dynamicDegreeColumn, (Object)degree, new Interval(interval.getLow(), interval.getLow() + this.tick));
                        break;
                    }
                    case TIMESTAMP: {
                        n.setAttribute(this.dynamicDegreeColumn, (Object)degree, interval.getLow());
                        n.setAttribute(this.dynamicDegreeColumn, (Object)degree, interval.getHigh());
                    }
                }
                if (this.isDirected) {
                    int indegree = directedGraph.getInDegree(n);
                    int outdegree = directedGraph.getOutDegree(n);
                    switch (tr) {
                        case INTERVAL: {
                            n.setAttribute(this.dynamicInDegreeColumn, (Object)indegree, new Interval(interval.getLow(), interval.getLow() + this.tick));
                            n.setAttribute(this.dynamicOutDegreeColumn, (Object)outdegree, new Interval(interval.getLow(), interval.getLow() + this.tick));
                            break;
                        }
                        case TIMESTAMP: {
                            n.setAttribute(this.dynamicInDegreeColumn, (Object)indegree, interval.getLow());
                            n.setAttribute(this.dynamicInDegreeColumn, (Object)indegree, interval.getHigh());
                            n.setAttribute(this.dynamicOutDegreeColumn, (Object)outdegree, interval.getLow());
                            n.setAttribute(this.dynamicOutDegreeColumn, (Object)outdegree, interval.getHigh());
                        }
                    }
                }
            }
            sum += (long)degree;
            if (this.cancel) break;
        }
        double avg = (double)sum / (double)graph.getNodeCount();
        this.averages.put(interval.getLow(), avg);
        this.averages.put(interval.getHigh(), avg);
        this.graphModel.getGraphVisible().setAttribute(DYNAMIC_AVGDEGREE, (Object)avg, interval.getLow());
        this.graphModel.getGraphVisible().setAttribute(DYNAMIC_AVGDEGREE, (Object)avg, interval.getHigh());
    }

    public void end() {
    }

    public void setBounds(Interval bounds) {
        this.bounds = bounds;
    }

    public void setWindow(double window) {
        this.window = window;
    }

    public void setTick(double tick) {
        this.tick = tick;
    }

    public double getWindow() {
        return this.window;
    }

    public double getTick() {
        return this.tick;
    }

    public Interval getBounds() {
        return this.bounds;
    }

    public void setDirected(boolean isDirected) {
        this.isDirected = isDirected;
    }

    public boolean isDirected() {
        return this.isDirected;
    }

    public void setAverageOnly(boolean averageOnly) {
        this.averageOnly = averageOnly;
    }

    public boolean isAverageOnly() {
        return this.averageOnly;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
    }
}

