/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.tools.plugin;

import java.awt.Color;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.gephi.tools.plugin.DiffusionMethods;
import org.gephi.ui.components.JColorButton;
import org.openide.util.NbBundle;

public class BrushPanel
extends JPanel {
    private JButton colorButton;
    private JComboBox diffusionCombobox;
    private JSpinner intensitySpinner;
    private JLabel jLabel1;
    private JLabel labelColor;
    private JLabel labelDiffusion;
    private JLabel labelIntensity;

    public BrushPanel() {
        this.initComponents();
        DefaultComboBoxModel<DiffusionMethods.DiffusionMethod> diffusionComboModel = new DefaultComboBoxModel<DiffusionMethods.DiffusionMethod>(DiffusionMethods.DiffusionMethod.values());
        this.diffusionCombobox.setModel(diffusionComboModel);
    }

    public void setIntensity(float intensity) {
        this.intensitySpinner.setValue((int)(intensity * 100.0f));
    }

    public float getIntensity() {
        return ((Integer)this.intensitySpinner.getModel().getValue()).floatValue() / 100.0f;
    }

    public void setColor(Color color) {
        ((JColorButton)this.colorButton).setColor(color);
    }

    public Color getColor() {
        return ((JColorButton)this.colorButton).getColor();
    }

    public void setDiffusionMethod(DiffusionMethods.DiffusionMethod diffusionMethod) {
        this.diffusionCombobox.setSelectedItem((Object)diffusionMethod);
    }

    public DiffusionMethods.DiffusionMethod getDiffusionMethod() {
        return (DiffusionMethods.DiffusionMethod)((Object)this.diffusionCombobox.getSelectedItem());
    }

    private void initComponents() {
        this.labelDiffusion = new JLabel();
        this.labelColor = new JLabel();
        this.diffusionCombobox = new JComboBox();
        this.colorButton = new JColorButton(Color.BLACK);
        this.labelIntensity = new JLabel();
        this.intensitySpinner = new JSpinner();
        this.jLabel1 = new JLabel();
        this.labelDiffusion.setFont(this.labelDiffusion.getFont().deriveFont(10.0f));
        this.labelDiffusion.setText(NbBundle.getMessage(BrushPanel.class, (String)"BrushPanel.labelDiffusion.text"));
        this.labelColor.setFont(this.labelColor.getFont().deriveFont(10.0f));
        this.labelColor.setText(NbBundle.getMessage(BrushPanel.class, (String)"BrushPanel.labelColor.text"));
        this.diffusionCombobox.setFont(this.diffusionCombobox.getFont().deriveFont(10.0f));
        this.diffusionCombobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.colorButton.setText(NbBundle.getMessage(BrushPanel.class, (String)"BrushPanel.colorButton.text"));
        this.colorButton.setContentAreaFilled(false);
        this.colorButton.setFocusPainted(false);
        this.labelIntensity.setFont(this.labelIntensity.getFont().deriveFont(10.0f));
        this.labelIntensity.setText(NbBundle.getMessage(BrushPanel.class, (String)"BrushPanel.labelIntensity.text"));
        this.intensitySpinner.setFont(this.intensitySpinner.getFont().deriveFont(10.0f));
        this.intensitySpinner.setModel(new SpinnerNumberModel(0, 0, 100, 1));
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(10.0f));
        this.jLabel1.setText(NbBundle.getMessage(BrushPanel.class, (String)"BrushPanel.jLabel1.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.labelColor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colorButton, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.labelIntensity).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.intensitySpinner, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 239, Short.MAX_VALUE).addComponent(this.labelDiffusion).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.diffusionCombobox, -2, -1, -2).addGap(2, 2, 2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelColor, -2, 28, -2).addComponent(this.colorButton, -2, 28, -2).addComponent(this.labelIntensity, -2, 28, -2).addComponent(this.intensitySpinner, -2, -1, -2).addComponent(this.jLabel1)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.diffusionCombobox, -2, 22, -2).addComponent(this.labelDiffusion, -2, 28, -2)));
    }
}

